/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.IntConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.RangeSet;
import org.infinispan.commons.util.SmallIntSet;
import org.junit.Assert;
import org.junit.Test;

public class RangeSetTest {
    @Test
    public void testSize() {
        RangeSet rs = new RangeSet(4);
        Assert.assertEquals((long)4L, (long)rs.size());
    }

    @Test
    public void testIsEmpty() {
        RangeSet rs = new RangeSet(0);
        Assert.assertTrue((boolean)rs.isEmpty());
        rs = new RangeSet(3);
        Assert.assertFalse((boolean)rs.isEmpty());
    }

    @Test
    public void contains() throws Exception {
        RangeSet rs = new RangeSet(4);
        Assert.assertFalse((boolean)rs.contains(5));
        Assert.assertTrue((boolean)rs.contains(1));
    }

    @Test
    public void contains1() throws Exception {
        RangeSet rs = new RangeSet(4);
        Assert.assertFalse((boolean)rs.contains((Object)5));
        Assert.assertTrue((boolean)rs.contains((Object)1));
    }

    @Test
    public void iterator() throws Exception {
        RangeSet rs = new RangeSet(4);
        PrimitiveIterator.OfInt iterator = rs.iterator();
        Assert.assertEquals((long)0L, (long)iterator.nextInt());
        Assert.assertEquals((long)1L, (long)iterator.nextInt());
        Assert.assertEquals((long)2L, (long)iterator.nextInt());
        Assert.assertEquals((long)3L, (long)iterator.nextInt());
    }

    @Test
    public void toArray() throws Exception {
        RangeSet rs = new RangeSet(4);
        Object[] array = rs.toArray();
        Assert.assertEquals((long)4L, (long)array.length);
        Assert.assertEquals((Object)0, (Object)array[0]);
        Assert.assertEquals((Object)1, (Object)array[1]);
        Assert.assertEquals((Object)2, (Object)array[2]);
        Assert.assertEquals((Object)3, (Object)array[3]);
    }

    @Test
    public void toArray1() throws Exception {
        RangeSet rs = new RangeSet(4);
        Object[] array = rs.toArray((Object[])new Integer[4]);
        Assert.assertEquals((long)4L, (long)array.length);
        Assert.assertEquals((Object)0, (Object)array[0]);
        Assert.assertEquals((Object)1, (Object)array[1]);
        Assert.assertEquals((Object)2, (Object)array[2]);
        Assert.assertEquals((Object)3, (Object)array[3]);
    }

    @Test
    public void toIntArray() throws Exception {
        RangeSet rs = new RangeSet(4);
        int[] array = rs.toIntArray();
        Assert.assertArrayEquals((int[])new int[]{0, 1, 2, 3}, (int[])array);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void add() throws Exception {
        RangeSet rs = new RangeSet(4);
        rs.add(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void add1() throws Exception {
        RangeSet rs = new RangeSet(4);
        rs.add(Integer.valueOf(1));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void set() throws Exception {
        RangeSet rs = new RangeSet(4);
        rs.set(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void remove() throws Exception {
        RangeSet rs = new RangeSet(4);
        rs.remove(1);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void remove1() throws Exception {
        RangeSet rs = new RangeSet(4);
        rs.remove((Object)1);
    }

    @Test
    public void containsAll() throws Exception {
        RangeSet rs = new RangeSet(4);
        RangeSet rs2 = new RangeSet(4);
        Assert.assertTrue((boolean)rs.containsAll((IntSet)rs2));
        RangeSet rs3 = new RangeSet(3);
        Assert.assertTrue((boolean)rs.containsAll((IntSet)rs3));
        Assert.assertFalse((boolean)rs3.containsAll((IntSet)rs));
    }

    @Test
    public void containsAll1() throws Exception {
        RangeSet rs = new RangeSet(5);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(1);
        hashSet.add(4);
        Assert.assertFalse((boolean)hashSet.containsAll((Collection<?>)rs));
        Assert.assertTrue((boolean)rs.containsAll(hashSet));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addAll() throws Exception {
        RangeSet rs = new RangeSet(4);
        RangeSet rs2 = new RangeSet(5);
        rs.addAll((IntSet)rs2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addAll1() throws Exception {
        RangeSet rs = new RangeSet(4);
        SmallIntSet sis = new SmallIntSet();
        rs.addAll((IntSet)sis);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void addAll2() throws Exception {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(1);
        hashSet.add(4);
        RangeSet rs = new RangeSet(4);
        rs.addAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeAll() throws Exception {
        RangeSet rs = new RangeSet(4);
        RangeSet rs2 = new RangeSet(6);
        rs.removeAll((IntSet)rs2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeAll1() throws Exception {
        RangeSet rs = new RangeSet(5);
        SmallIntSet sis = new SmallIntSet();
        rs.removeAll((IntSet)sis);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeAll2() throws Exception {
        RangeSet rs = new RangeSet(4);
        HashSet hashSet = new HashSet();
        rs.removeAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void retainAll() throws Exception {
        RangeSet rs = new RangeSet(4);
        RangeSet rs2 = new RangeSet(5);
        rs.retainAll((IntSet)rs2);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void retainAll1() throws Exception {
        RangeSet rs = new RangeSet(5);
        SmallIntSet sis = new SmallIntSet();
        rs.retainAll((IntSet)sis);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void retainAll2() throws Exception {
        RangeSet rs = new RangeSet(4);
        HashSet hashSet = new HashSet();
        rs.retainAll(hashSet);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void clear() throws Exception {
        RangeSet rs = new RangeSet(5);
        rs.clear();
    }

    @Test
    public void intStream() throws Exception {
        RangeSet rs = new RangeSet(5);
        Assert.assertEquals((long)10L, (long)rs.intStream().sum());
    }

    @Test
    public void equals() throws Exception {
        RangeSet rs = new RangeSet(4);
        RangeSet rs2 = new RangeSet(5);
        Assert.assertNotEquals((Object)rs, (Object)rs2);
        Assert.assertNotEquals((Object)rs2, (Object)rs);
        RangeSet rs3 = new RangeSet(4);
        Assert.assertEquals((Object)rs3, (Object)rs);
        Assert.assertEquals((Object)rs, (Object)rs3);
    }

    @Test
    public void equals1() throws Exception {
        RangeSet intSet = new RangeSet(4);
        SmallIntSet sis = new SmallIntSet();
        sis.add(0);
        sis.add(1);
        sis.add(2);
        Assert.assertNotEquals((Object)sis, (Object)intSet);
        Assert.assertNotEquals((Object)intSet, (Object)sis);
        sis.add(3);
        Assert.assertEquals((Object)sis, (Object)intSet);
        Assert.assertEquals((Object)intSet, (Object)sis);
    }

    @Test
    public void equals2() throws Exception {
        RangeSet rs = new RangeSet(4);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(0);
        hashSet.add(1);
        hashSet.add(2);
        Assert.assertNotEquals((Object)rs, hashSet);
        Assert.assertNotEquals(hashSet, (Object)rs);
        hashSet.add(3);
        Assert.assertEquals((Object)rs, hashSet);
        Assert.assertEquals(hashSet, (Object)rs);
    }

    @Test
    public void forEachPrimitive() {
        RangeSet rs = new RangeSet(4);
        HashSet results = new HashSet();
        rs.forEach(results::add);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(0));
        Assert.assertTrue((boolean)results.contains(1));
        Assert.assertTrue((boolean)results.contains(2));
        Assert.assertTrue((boolean)results.contains(3));
    }

    @Test
    public void forEachObject() {
        RangeSet rs = new RangeSet(4);
        HashSet results = new HashSet();
        rs.forEach(results::add);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(0));
        Assert.assertTrue((boolean)results.contains(1));
        Assert.assertTrue((boolean)results.contains(2));
        Assert.assertTrue((boolean)results.contains(3));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeIfPrimitive() {
        RangeSet rs = new RangeSet(4);
        rs.removeIf(i -> i == 3);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void removeIfObject() {
        RangeSet rs = new RangeSet(4);
        rs.removeIf(i -> i == 3);
    }

    @Test
    public void intSpliteratorForEachRemaining() {
        RangeSet rs = new RangeSet(4);
        HashSet results = new HashSet();
        rs.intSpliterator().forEachRemaining(results::add);
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(0));
        Assert.assertTrue((boolean)results.contains(1));
        Assert.assertTrue((boolean)results.contains(2));
        Assert.assertTrue((boolean)results.contains(3));
    }

    @Test
    public void intSpliteratorSplitTryAdvance() {
        RangeSet rs = new RangeSet(4);
        HashSet results = new HashSet();
        Spliterator.OfInt spliterator = rs.intSpliterator();
        Spliterator.OfInt split = spliterator.trySplit();
        Assert.assertNotNull((Object)split);
        IntConsumer consumer = results::add;
        while (spliterator.tryAdvance(consumer)) {
        }
        while (split.tryAdvance(consumer)) {
        }
        Assert.assertEquals((long)4L, (long)results.size());
        Assert.assertTrue((boolean)results.contains(0));
        Assert.assertTrue((boolean)results.contains(1));
        Assert.assertTrue((boolean)results.contains(2));
        Assert.assertTrue((boolean)results.contains(3));
    }
}

