/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import org.infinispan.Cache;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.VersionedValue;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.CompatibilityTest")
public class EmbeddedHotRodTest
extends AbstractInfinispanTest {
    CompatibilityCacheFactory<Integer, String> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory();
        this.cacheFactory.setup();
    }

    @AfterClass
    protected void teardown() {
        this.cacheFactory.teardown();
    }

    public void testEmbeddedPutHotRodGet() {
        Integer key = 1;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.put((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
    }

    public void testHotRodPutEmbeddedGet() {
        Integer key = 2;
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.put((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v3")));
        AssertJUnit.assertEquals((String)"v3", (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedPutIfAbsentHotRodGet() {
        Integer key = 3;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.putIfAbsent((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.get((Object)key)));
    }

    public void testHotRodPutIfAbsentEmbeddedGet() {
        Integer key = 4;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).putIfAbsent((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedReplaceHotRodGet() {
        Integer key = 5;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.replace((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.replace((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
    }

    public void testHotRodReplaceEmbeddedGet() {
        Integer key = 6;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).replace((Object)key, (Object)"v2")));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedReplaceConditionalHotRodGet() {
        Integer key = 7;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertTrue((boolean)embedded.replace((Object)key, (Object)"v1", (Object)"v2"));
        AssertJUnit.assertEquals((String)"v2", (String)((String)remote.get((Object)key)));
    }

    public void testHotRodReplaceConditionalEmbeddedGet() {
        Integer key = 8;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.put((Object)key, (Object)"v1")));
        VersionedValue versioned = remote.getVersioned((Object)key);
        AssertJUnit.assertEquals((String)"v1", (String)((String)versioned.getValue()));
        AssertJUnit.assertTrue((0L != versioned.getVersion() ? 1 : 0) != 0);
        AssertJUnit.assertFalse((boolean)remote.replaceWithVersion((Object)key, (Object)"v2", Long.MAX_VALUE));
        AssertJUnit.assertTrue((boolean)remote.replaceWithVersion((Object)key, (Object)"v2", versioned.getVersion()));
        AssertJUnit.assertEquals((String)"v2", (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedRemoveHotRodGet() {
        Integer key = 9;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)embedded.remove((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)remote.get((Object)key)));
    }

    public void testHotRodRemoveEmbeddedGet() {
        Integer key = 10;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        AssertJUnit.assertEquals((String)"v1", (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).remove((Object)key)));
        AssertJUnit.assertEquals(null, (String)((String)embedded.get((Object)key)));
    }

    public void testEmbeddedRemoveConditionalHotRodGet() {
        Integer key = 11;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)embedded.put((Object)key, (Object)"v1")));
        AssertJUnit.assertFalse((boolean)embedded.remove((Object)key, (Object)"vX"));
        AssertJUnit.assertTrue((boolean)embedded.remove((Object)key, (Object)"v1"));
        AssertJUnit.assertEquals(null, (String)((String)remote.get((Object)key)));
    }

    public void testHotRodRemoveConditionalEmbeddedGet() {
        Integer key = 12;
        Cache<Integer, String> embedded = this.cacheFactory.getEmbeddedCache();
        RemoteCache<Integer, String> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (String)((String)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)key, (Object)"v1")));
        VersionedValue versioned = remote.getVersioned((Object)key);
        AssertJUnit.assertFalse((boolean)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeWithVersion((Object)key, Long.MAX_VALUE));
        AssertJUnit.assertTrue((boolean)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).removeWithVersion((Object)key, versioned.getVersion()));
        AssertJUnit.assertEquals(null, (String)((String)embedded.get((Object)key)));
    }
}

