/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.EmbeddedRestHotRodTest")
public class EmbeddedRestHotRodTest {
    CompatibilityCacheFactory<String, Object> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory();
        this.cacheFactory.setup();
    }

    @AfterClass
    protected void teardown() {
        this.cacheFactory.teardown();
    }

    public void testRestPutEmbeddedHotRodGet() throws Exception {
        String key = "1";
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "1");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("<hey>ho</hey>".getBytes(), "application/octet-stream"));
        HttpClient restClient = this.cacheFactory.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        AssertJUnit.assertArrayEquals((byte[])"<hey>ho</hey>".getBytes(), (byte[])((byte[])this.cacheFactory.getEmbeddedCache().get((Object)"1")));
        AssertJUnit.assertArrayEquals((byte[])"<hey>ho</hey>".getBytes(), (byte[])((byte[])this.cacheFactory.getHotRodCache().get((Object)"1")));
    }

    public void testEmbeddedPutRestHotRodGet() throws Exception {
        String key = "2";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getHotRodCache().get((Object)"2"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "2");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }

    public void testHotRodPutEmbeddedRestGet() throws Exception {
        String key = "3";
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"3", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"3"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "3");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }
}

