/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.compatibility;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.infinispan.client.hotrod.Flag;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.io.ByteBuffer;
import org.infinispan.it.compatibility.CompatibilityCacheFactory;
import org.infinispan.marshall.AbstractMarshaller;
import org.infinispan.marshall.Marshaller;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="it.compatibility.EmbeddedRestMemcachedHotRodTest")
public class EmbeddedRestMemcachedHotRodTest {
    static final String CACHE_NAME = "memcachedCache";
    CompatibilityCacheFactory<String, Object> cacheFactory;

    @BeforeClass
    protected void setup() throws Exception {
        this.cacheFactory = new CompatibilityCacheFactory(CACHE_NAME, (Marshaller)new SpyMemcachedCompatibleMarshaller());
        this.cacheFactory.setup();
    }

    @AfterClass
    protected void teardown() {
        this.cacheFactory.teardown();
    }

    public void testMemcachedPutEmbeddedRestHotRodGetTest() throws Exception {
        String key = "1";
        Future f = this.cacheFactory.getMemcachedClient().set("1", 0, (Object)"v1");
        AssertJUnit.assertTrue((boolean)((Boolean)f.get(60L, TimeUnit.SECONDS)));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"1"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "1");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"text/plain", (String)get.getResponseHeader("Content-Type").getValue());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getHotRodCache().get((Object)"1"));
    }

    public void testEmbeddedPutMemcachedRestHotRodGetTest() throws Exception {
        String key = "2";
        AssertJUnit.assertEquals(null, (Object)this.cacheFactory.getEmbeddedCache().put((Object)"2", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getMemcachedClient().get("2"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "2");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getHotRodCache().get((Object)"2"));
    }

    public void testRestPutEmbeddedMemcachedHotRodGetTest() throws Exception {
        String key = "3";
        PutMethod put = new PutMethod(this.cacheFactory.getRestUrl() + "/" + "3");
        put.setRequestEntity((RequestEntity)new ByteArrayRequestEntity("<hey>ho</hey>".getBytes(), "application/octet-stream"));
        HttpClient restClient = this.cacheFactory.getRestClient();
        restClient.executeMethod((HttpMethod)put);
        AssertJUnit.assertEquals((int)200, (int)put.getStatusCode());
        AssertJUnit.assertEquals((String)"", (String)put.getResponseBodyAsString().trim());
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"3"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getMemcachedClient().get("3"));
        AssertJUnit.assertEquals((Object)"<hey>ho</hey>", (Object)this.cacheFactory.getHotRodCache().get((Object)"3"));
    }

    public void testHotRodPutEmbeddedMemcachedRestGetTest() throws Exception {
        String key = "4";
        RemoteCache<String, Object> remote = this.cacheFactory.getHotRodCache();
        AssertJUnit.assertEquals(null, (Object)remote.withFlags(new Flag[]{Flag.FORCE_RETURN_VALUE}).put((Object)"4", (Object)"v1"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getEmbeddedCache().get((Object)"4"));
        AssertJUnit.assertEquals((Object)"v1", (Object)this.cacheFactory.getMemcachedClient().get("4"));
        GetMethod get = new GetMethod(this.cacheFactory.getRestUrl() + "/" + "4");
        this.cacheFactory.getRestClient().executeMethod((HttpMethod)get);
        AssertJUnit.assertEquals((int)200, (int)get.getStatusCode());
        AssertJUnit.assertEquals((String)"v1", (String)get.getResponseBodyAsString());
    }

    private class SpyMemcachedCompatibleMarshaller
    extends AbstractMarshaller {
        private final Transcoder<Object> transcoder = new SerializingTranscoder();

        private SpyMemcachedCompatibleMarshaller() {
        }

        protected ByteBuffer objectToBuffer(Object o, int estimatedSize) {
            CachedData encoded = this.transcoder.encode(o);
            return new ByteBuffer(encoded.getData(), 0, encoded.getData().length);
        }

        public Object objectFromByteBuffer(byte[] buf, int offset, int length) {
            return this.transcoder.decode(new CachedData(0, buf, length));
        }

        public boolean isMarshallable(Object o) throws Exception {
            try {
                this.transcoder.encode(o);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }
    }
}

