/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.compatibility.loaders;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import org.infinispan.compatibility.loaders.Custom52xCacheStore;
import org.infinispan.compatibility.loaders.Custom52xCacheStoreConfig;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.io.UnclosableObjectInputStream;
import org.infinispan.io.UnclosableObjectOutputStream;
import org.infinispan.loaders.BaseCacheStoreTest;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.bucket.Bucket;
import org.infinispan.marshall.StreamingMarshaller;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestInternalCacheEntryFactory;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="compatibility.loaders.Custom52xLoaderTest")
public class Custom52xLoaderTest
extends BaseCacheStoreTest {
    Custom52xCacheStore fcs;
    String tmpDirectory;

    @BeforeClass
    protected void setUpTempDir() {
        this.tmpDirectory = TestingUtil.tmpDirectory((AbstractInfinispanTest)this);
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)this.tmpDirectory);
    }

    protected CacheStore createCacheStore() throws CacheLoaderException {
        this.clearTempDir();
        this.fcs = new Custom52xCacheStore();
        Custom52xCacheStoreConfig cfg = new Custom52xCacheStoreConfig().fetchPersistentState(Boolean.valueOf(true)).fsyncMode(this.getFsyncMode()).location(this.tmpDirectory).purgeSynchronously(Boolean.valueOf(true));
        this.fcs.init((CacheLoaderConfig)cfg, this.getCache(), this.getMarshaller());
        this.fcs.start();
        return this.fcs;
    }

    protected Custom52xCacheStoreConfig.FsyncMode getFsyncMode() {
        return Custom52xCacheStoreConfig.FsyncMode.DEFAULT;
    }

    public void testPreload() throws Exception {
        this.createUnrelatedFile();
        super.testPreload();
    }

    public void testPurgeExpired() throws Exception {
        long lifespan = 1000L;
        this.cs.store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)lifespan));
        this.cs.store(TestInternalCacheEntryFactory.create((Object)"k2", (Object)"v2", (long)lifespan));
        this.cs.store(TestInternalCacheEntryFactory.create((Object)"k3", (Object)"v3", (long)lifespan));
        assert (this.cs.containsKey((Object)"k1"));
        assert (this.cs.containsKey((Object)"k2"));
        assert (this.cs.containsKey((Object)"k3"));
        this.createUnrelatedFile();
        Thread.sleep(lifespan + 100L);
        this.cs.purgeExpired();
        Custom52xCacheStore fcs = (Custom52xCacheStore)this.cs;
        assert (fcs.load((Object)"k1") == null);
        assert (fcs.load((Object)"k2") == null);
        assert (fcs.load((Object)"k3") == null);
    }

    private void createUnrelatedFile() throws IOException {
        File cacheStoreDirectory = new File(this.tmpDirectory);
        assert (cacheStoreDirectory.exists());
        assert (cacheStoreDirectory.canWrite());
        String newfile = cacheStoreDirectory.getAbsolutePath() + File.separator + "mockCache-" + ((Object)((Object)this)).getClass().getName() + File.separator + "externalExistingFile";
        File file = new File(newfile);
        boolean created = file.createNewFile();
        assert (created);
    }

    public void testBucketRemoval() throws Exception {
        InternalCacheEntry se = TestInternalCacheEntryFactory.create((Object)"test", (Object)"value");
        this.fcs.store(se);
        Bucket b = this.fcs.loadBucketContainingKey("test");
        assert (b != null);
        assert (!b.getEntries().isEmpty());
        assert (new File(this.fcs.root, b.getBucketIdAsString()).exists());
        b.removeEntry((Object)"test");
        assert (b.getEntries().isEmpty());
        this.fcs.updateBucket(b);
        this.checkBucketExists(b);
    }

    public void testCacheStoreRebootable() throws Exception {
        String key = "testCacheStoreRebootable";
        InternalCacheEntry se = TestInternalCacheEntryFactory.create((Object)key, (Object)"initialValue");
        this.fcs.store(se);
        Bucket b = this.fcs.loadBucketContainingKey(key);
        this.fcs.stop();
        this.fcs.start();
        InternalCacheEntry entry = b.getEntry((Object)key);
        entry.setValue((Object)"updatedValue");
        this.fcs.updateBucket(b);
        assert ("updatedValue".equals(this.fcs.load((Object)key).getValue()));
    }

    protected void checkBucketExists(Bucket b) {
        File file = new File(this.fcs.root, b.getBucketIdAsString());
        assert (file.exists());
        assert (file.length() == 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testToStream() throws Exception {
        this.cs.store(TestInternalCacheEntryFactory.create((Object)"k1", (Object)"v1", (long)-1L, (long)-1L));
        StreamingMarshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false, 12);
        try {
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            assert (oi.readInt() == 1) : "we have 3 different buckets";
            assert (oi.readObject().equals(this.fcs.getLockFromKey((Object)"k1") + ""));
            assert (oi.readInt() > 0);
        }
        finally {
            marshaller.finishObjectInput(oi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLongKeyValuesToStream() throws Exception {
        String k1 = "SESSION_173";
        String v1 = "@TSXMHVROYNOFCJVEUJQGBCENNQDEWSCYSOHECJOHEICBEIGJVTIBB@TVNCWLTQCGTEJ@NBJLTMVGXCHXTSVE@BCRYGWPRVLXOJXBRJDVNBVXPRTRLBMHPOUYQKDEPDSADUAWPFSIOCINPSSFGABDUXRMTMMJMRTGBGBOAMGVMTKUDUAJGCAHCYW@LAXMDSFYOSXJXLUAJGQKPTHUKDOXRWKEFIVRTH@VIMQBGYPKWMS@HPOESTPIJE@OTOTWUWIOBLYKQQPTNGWVLRRCWHNIMWDQNOO@JHHEVYVQEODMWKFKKKSWURVDLXPTFQYIHLIM@GSBFWMDQGDQIJONNEVHGQTLDBRBML@BEWGHOQHHEBRFUQSLB@@CILXEAVQQBTXSITMBXHMHORHLTJF@MKMHQGHTSENWILTAKCCPVSQIPBVRAFSSEXIOVCPDXHUBIBUPBSCGPRECXEPMQHRHDOHIHVBPNDKOVLPCLKAJMNOTSF@SRXYVUEMQRCXVIETXVHOVNGYERBNM@RIMGHC@FNTUXSJSKALGHAFHGTFEANQUMBPUYFDSGLUYRRFDJHCW@JBWOBGMGTITAICRC@TPVCRKRMFPUSRRAHI@XOYKVGPHEBQD@@APEKSBCTBKREWAQGKHTJ@IHJD@YFSRDQPA@HKKELIJGFDYFEXFCOTCQIHKCQBLVDFHMGOWIDOWMVBDSJQOFGOIAPURRHVBGEJWYBUGGVHE@PU@NMQFMYTNYJDWPIADNVNCNYCCCPGODLAO@YYLVITEMNNKIFSDXKORJYWMFGKNYFPUQIC@AIDR@IWXCVALQBDOXRWIBXLKYTWDNHHSCUROAU@HVNENDAOP@RPTRIGLLLUNDQIDXJDDNF@P@PA@FEIBQKSKFQITTHDYGQRJMWPRLQC@NJVNVSKGOGYXPYSQHKPALKLFWNAOSQFTLEPVOII@RPDNRCVRDUMMFIVSWGIASUBMTGQSDGB@TBBYECFBRBGILJFCJ@JIQIQRVJXWIPGNVXKYATSPJTIPGCMCNPOKNEHBNUIAEQFQTYVLGAR@RVWVA@RMPBX@LRLJUEBUWO@PKXNIP@FKIQSVWKNO@FOJWDSIOLXHXJFBQPPVKKP@YKXPOOMBTLXMEHPRLLSFSVGMPXXNBCYVVSPNGMFBJUDCVOVGXPKVNTOFKVJUJOSDHSCOQRXOKBVP@WCUUFGMJAUQ@GRAGXICFCFICBSNASUBPAFRIPUK@OXOCCNOGTTSFVQKBQNB@DWGVEFSGTAXAPLBJ@SYHUNXWXPMR@KPFAJCIXPDURELFYPMUSLTJSQNDHHKJTIWCGNEKJF@CUWYTWLPNHYPHXNOGLSICKEFDULIXXSIGFMCQGURSRTUJDKRXBUUXIDFECMPXQX@CVYLDABEMFKUGBTBNMNBPCKCHWRJKSOGJFXMFYLLPUVUHBCNULEFAXPVKVKQKYCEFRUYPBRBDBDOVYLIQMQBLTUK@PRDCYBOKJGVUADFJFAFFXKJTNAJTHISWOSMVAYLIOGIORQQWFAKNU@KHPM@BYKTFSLSRHBATQTKUWSFAQS@Y@QIKCUWQYTODBRCYYYIAFMDVRURKVYJXHNGVLSQQFCXKLNUPCTEJSWIJUBFELSBUHANELHSIWLVQSSAIJRUEDOHHX@CKEBPOJRLRHEPLENSCDGEWXRTVUCSPFSAJUXDJOIUWFGPKHBVRVDMUUCPUDKRKVAXPSOBOPKPRRLFCKTLH@VGWKERASJYU@JAVWNBJGQOVF@QPSGJVEPAV@NAD@@FQRYPQIOAURILWXCKINPMBNUHPUID@YDQBHWAVDPPWRFKKGWJQTI@@OPSQ@ROUGHFNHCJBDFCHRLRTEMTUBWVCNOPYXKSSQDCXTOLOIIOCXBTPAUYDICFIXPJRB@CHFNXUCXANXYKXAISDSSLJGQOLBYXWHG@@KPARPCKOXAYVPDGRW@LDCRQBNMJREHWDYMXHEXAJQKHBIRAVHJQIVGOIXNINYQMJBXKM@DXESMBHLKHVSFDLVPOSOVMLHPSHQYY@DNMCGGGAJMHPVDLBGJP@EVDGLYBMD@NWHEYTBPIBPUPYOPOJVV@IVJXJMHIWWSIRKUWSR@U@@TDVMG@GRXVLCNEIISEVIVPOMJHKOWMRMITYDUQASWJIKVNYUFQVDT@BHTOMFXVFRKAARLNOGX@ADWCKHOVEMIGBWXINCUXEMVHSJJQDU@INTHDJQPSAQNAYONDBBFYGBTNGUSJHRKLCPHQMNLDHUQJPLLCDVTYLXTHJCBUXCRDY@YI@IQDCLJBBJC@NXGANXFIWPPNFVTDJWQ@@BIYJONOFP@RHTQEYPVHPPUS@UUENSNNF@WVGTSAVKDSQNMHP@VJORGTVWXVBPWKQNRWLSQFSBMXQKWRYMXPAYREXYGONKEWJMBCSLB@KSHXMIWMSBDGQWPDMUGVNMEWKMJKQECIRRVXBPBLGAFTUFHYSHLF@TGYETMDXRFAXVEUBSTGLSMWJMXJWMDPPDAFGNBMTQEMBDLRASMUMU@QTCDCPEGODHESDQVEIQYBJJPFXDLWPUNFAREYCY@YDDSTMKWCANNPXF@@WLMEXRPUNTWNOX@YKFNNTGMXIBBDA@TYLPJFNFHPQKMSNCLBME@FBPOIYNSDFBLHITKIFEFNXXOJAAFMRTGPALOANXF@YPY@RYTVOW@AKNM@C@LJKGBJMUYGGTXRHQCPOLNOGPPS@YSKAJSTQHLRBXUACXJYBLJSEHDNMLLUBSOIHQUI@VUNF@XAVRXUCYNCBDDGUDNVRYP@TPFPKGVNPTEDOTTUUFKCHQ@WWASQXLCBHNRBVSD@NVYT@GJQYSQGYPJO@WSEYDVKCBWANAFUWLDXOQYCYP@BSJFCBTXGKUNWLWUCYL@TNOWGDFHQTWQVYLQBBRQVMGNDBVXEFXTMMVYSHNVTTQAJCHKULOAJUSGJRPHQFCROWE@OMFUVRKGCWED@IAQGRLADOJGQKLCL@FCKTSITGMJRCCMPLOS@ONPQWFUROXYAUJQXIYVDCYBPYHPYCXNCRKRKLATLWWXLBLNOPUJFUJEDOIRKS@MMYPXIJNXPFOQJCHSCBEBGDUQYXQAWEEJDOSINXYLDXUJCQECU@WQSACTDFLGELHPGDFVDXFSSFOSYDLHQFVJESNAVAHKTUPBTPLSFSHYKLEXJXGWESVQQUTUPU@QXRTIDQ@IXBBOYINNHPEMTPRVRNJPQJFACFXUBKXOFHQSPOTLCQ@PLWGEFNKYCYFMKWPFUP@GLHKNMASGIENCACUISTG@YNQCNSOSBKOIXORKSHEOXHSMJJRUICJTCK@PWFRBPLXU@MUEMPFGDLUJEKD@ROUFBLKATXUCHEAQHEYDLCFDIRJSAXTV@CYMPQNMLTMFAHPRBLNSCVFBJMKQLAHWYIOLRMTOY@@RNKTUXHFYUMHGKCCGNEOIOQCISJEHCEVTTWM@TLFRIFDREHFBTTDEJRUNTWAEETGSVDOR@@UQNKFERMBVFJBOAYHPOKMSMRIERDA@JXYSJ@ORER@MBAVWCVGFNA@FRRPQSIIOIUGAJKVQXGINUUKPJPLQRMHPUBETEEIMIBPM@PETR@XD@DOHGRIBVXKLXQWHUFMTWEDYWFWRLPGDS@TANUXGIDTRVXKVCVEXYRKXQCTI@WNSFRAHJJGG@NIPPAAOJXQRTCLBYKDA@FFGHNUIGBFKOQMEDUEFELFLNKPCHA@OXJJRYNPDFSXIFSJYTDMSSBHDPUSQQDAVD@JAAWJDSVTERAJBFEPVRWKMYAPISPWLDPSRE@UMRQLXERTWRDLQVMVCOM@NYPXFLWMWKALMQVNJ@HCTMMIOLRWBJHCYFLMM@IWXPSHRRUNICSSWHOQHUVJE@HKJAADLBTPVLDAKCHRSURJCAXYTMYKHQMWDAWWASUW@HWGBVPTRHJGDWOGHPCNWSXTNKWONQGEKDDWGCKWVSAD@YLCCENMCHALHVDYQW@NQGNCY@M@GGV@RIR@OUS@PQIJMCFEIMGPYBXYR@NSIAUEXT@MOCNWRMLYHUUAFJCCLLRNFGKLPPIIH@BYRME@UJAKIFHOV@ILP@BGXRNJBIBARSOIMTDSHMGPIGRJBGHYRYXPFUHVOOMCQFNLM@CNCBTGO@UKXBOICNVCRGHADYQVAMNSFRONJ@WITET@BSHMQLWYMVGMQJVSJOXOUJDSXYVVBQJSVGREQLIQKWC@BMDNONHXFYPQENSJINQYKHVCTUTG@QQYJKJURDCKJTUQAM@DWNXWRNILYVAAJ@IADBIXKEIHVXLXUVMGQPAQTWJCDMVDVYUDTXQTCYXDPHKBAGMTAMKEM@QNOQJBREXNWFCXNXRPGOGEIR@KQJIGXAWXLTNCX@ID@XNRNYGRF@QPNWEX@XH@XKSXLQTLQPFSHAHXJLHUTNQWFFAJYHBWIFVJELDPSPLRRDPPNXSBYBEREEELIWNVYXOXYJQAIGHALUAWNUSSNMBHBFLRMMTKEKNSINECUGWTDNMROXI@BJJXKSPIIIXOAJBFVSITQDXTODBGKEPJMWK@JOL@SWTCGSHCOPHECTPJFUXIHUOSVMUTNNSLLJDEOMAGIXEAAVILRMOJXVHHPNPUYYODMXYAYGHI@BUB@NLP@KNPCYFRWAFES@WISBACDSPELEVTJEBNRVENSXXEVDVC@RIDIDSBPQIQNNSRPS@HCJ@XPIOFDXHUBCNFQKHMUYLXW@LMFMALHLESSXCOULRWDTJIVKKTLGFE@HKGVKUGMVHWACQOTSVNWBNUUGTMSQEJ@DXJQQYPOWVRQNQKXSLOEAA@@FRDCGCCQWQ@IY@EATGQGQIETPIJHOIQRYWLTGUENQYDNQSBI@IAUDEWDKICHNUGNAIXNICMBK@CJGSASMTFKWOBSI@KULNENWXV@VNFOANM@OJHFVV@IYRMDB@LHSGXIJMMFCGJKTKDXSMY@FHDNY@VSDUORGWVFMVKJXOCCDLSLMHCSXFBTW@RQTFNRDJUIKRD@PWPY@TSXMHVROYNOFCJVEUJQGBCENNQDEWSCYSOHECJOHEICBEIGJVTIBB@TVNCWLTQCGTEJ@NBJLTMVGXCHXTSVE@BCRYGWPRVLXOJXBRJDVNBVXPRTRLBMHPOUYQKDEPDSADUAWPFSIOCINPSSFGABDUXRMTMMJMRTGBGBOAMGVMTKUDUAJGCAHCYW@LAXMDSFYOSXJXLUAJGQKPTHUKDOXRWKEFIVRTH@VIMQBGYPKWMS@HPOESTPIJE@OTOTWUWIOBLYKQQPTNGWVLRRCWHNIMWDQNOO@JHHEVYVQEODMWKFKKKSWURVDLXPTFQYIHLIM@GSBFWMDQGDQIJONNEVHGQTLDBRBML@BEWGHOQHHEBRFUQSLB@@CILXEAVQQBTXSITMBXHMHORHLTJF@MKMHQGHTSENWILTAKCCPVSQIPBVRAFSSEXIOVCPDXHUBIBUPBSCGPRECXEPMQHRHDOHIHVBPNDKOVLPCLKAJMNOTSF@SRXYVUEMQRCXVIETXVHOVNGYERBNM@RIMGHC@FNTUXSJSKALGHAFHGTFEANQUMBPUYFDSGLUYRRFDJHCW@JBWOBGMGTITAICRC@TPVCRKRMFPUSRRAHI@XOYKVGPHEBQD@@APEKSBCTBKREWAQGKHTJ@IHJD@YFSRDQPA@HKKELIJGFDYFEXFCOTCQIHKCQBLVDFHMGOWIDOWMVBDSJQOFGOIAPURRHVBGEJWYBUGGVHE@PU@NMQFMYTNYJDWPIADNVNCNYCCCPGODLAO@YYLVITEMNNKIFSDXKORJYWMFGKNYFPUQIC@AIDR@IWXCVALQBDOXRWIBXLKYTWDNHHSCUROAU@HVNENDAOP@RPTRIGLLLUNDQIDXJDDNF@P@PA@FEIBQKSKFQITTHDYGQRJMWPRLQC@NJVNVSKGOGYXPYSQHKPALKLFWNAOSQFTLEPVOII@RPDNRCVRDUMMFIVSWGIASUBMTGQSDGB@TBBYECFBRBGILJFCJ@JIQIQRVJXWIPGNVXKYATSPJTIPGCMCNPOKNEHBNUIAEQFQTYVLGAR@RVWVA@RMPBX@LRLJUEBUWO@PKXNIP@FKIQSVWKNO@FOJWDSIOLXHXJFBQPPVKKP@YKXPOOMBTLXMEHPRLLSFSVGMPXXNBCYVVSPNGMFBJUDCVOVGXPKVNTOFKVJUJOSDHSCOQRXOKBVP@WCUUFGMJAUQ@GRAGXICFCFICBSNASUBPAFRIPUK@OXOCCNOGTTSFVQKBQNB@DWGVEFSGTAXAPLBJ@SYHUNXWXPMR@KPFAJCIXPDURELFYPMUSLTJSQNDHHKJTIWCGNEKJF@CUWYTWLPNHYPHXNOGLSICKEFDULIXXSIGFMCQGURSRTUJDKRXBUUXIDFECMPXQX@CVYLDABEMFKUGBTBNMNBPCKCHWRJKSOGJFXMFYLLPUVUHBCNULEFAXPVKVKQKYCEFRUYPBRBDBDOVYLIQMQBLTUK@PRDCYBOKJGVUADFJFAFFXKJTNAJTHISWOSMVAYLIOGIORQQWFAKNU@KHPM@BYKTFSLSRHBATQTKUWSFAQS@Y@QIKCUWQYTODBRCYYYIAFMDVRURKVYJXHNGVLSQQFCXKLNUPCTEJSWIJUBFELSBUHANELHSIWLVQSSAIJRUEDOHHX@CKEBPOJRLRHEPLENSCDGEWXRTVUCSPFSAJUXDJOIUWFGPKHBVRVDMUUCPUDKRKVAXPSOBOPKPRRLFCKTLH@VGWKERASJYU@JAVWNBJGQOVF@QPSGJVEPAV@NAD@@FQRYPQIOAURILWXCKINPMBNUHPUID@YDQBHWAVDPPWRFKKGWJQTI@@OPSQ@ROUGHFNHCJBDFCHRLRTEMTUBWVCNOPYXKSSQDCXTOLOIIOCXBTPAUYDICFIXPJRB@CHFNXUCXANXYKXAISDSSLJGQOLBYXWHG@@KPARPCKOXAYVPDGRW@LDCRQBNMJREHWDYMXHEXAJQKHBIRAVHJQIVGOIXNINYQMJBXKM@DXESMBHLKHVSFDLVPOSOVMLHPSHQYY@DNMCGGGAJMHPVDLBGJP@EVDGLYBMD@NWHEYTBPIBPUPYOPOJVV@IVJXJMHIWWSIRKUWSR@U@@TDVMG@GRXVLCNEIISEVIVPOMJHKOWMRMITYDUQASWJIKVNYUFQVDT@BHTOMFXVFRKAARLNOGX@ADWCKHOVEMIGBWXINCUXEMVHSJJQDU@INTHDJQPSAQNAYONDBBFYGBTNGUSJHRKLCPHQMNLDHUQJPLLCDVTYLXTHJCBUXCRDY@YI@IQDCLJBBJC@NXGANXFIWPPNFVTDJWQ@@BIYJONOFP@RHTQEYPVHPPUS@UUENSNNF@WVGTSAVKDSQNMHP@VJORGTVWXVBPWKQNRWLSQFSBMXQKWRYMXPAYREXYGONKEWJMBCSLB@KSHXMIWMSBDGQWPDMUGVNMEWKMJKQECIRRVXBPBLGAFTUFHYSHLF@TGYETMDXRFAXVEUBSTGLSMWJMXJWMDPPDAFGNBMTQEMBDLRASMUMU@QTCDCPEGODHESDQVEIQYBJJPFXDLWPUNFAREYCY@YDDSTMKWCANNPXF@@WLMEXRPUNTWNOX@YKFNNTGMXIBBDA@TYLPJFNFHPQKMSNCLBME@FBPOIYNSDFBLHITKIFEFNXXOJAAFMRTGPALOANXF@YPY@RYTVOW@AKNM@C@LJKGBJMUYGGTXRHQCPOLNOGPPS@YSKAJSTQHLRBXUACXJYBLJSEHDNMLLUBSOIHQUI@VUNF@XAVRXUCYNCBDDGUDNVRYP@TPFPKGVNPTEDOTTUUFKCHQ@WWASQXLCBHNRBVSD@NVYT@GJQYSQGYPJO@WSEYDVKCBWANAFUWLDXOQYCYP@BSJFCBTXGKUNWLWUCYL@TNOWGDFHQTWQVYLQBBRQVMGNDBVXEFXTMMVYSHNVTTQAJCHKULOAJUSGJRPHQFCROWE@OMFUVRKGCWED@IAQGRLADOJGQKLCL@FCKTSITGMJRCCMPLOS@ONPQWFUROXYAUJQXIYVDCYBPYHPYCXNCRKRKLATLWWXLBLNOPUJFUJEDOIRKS@MMYPXIJNXPFOQJCHSCBEBGDUQYXQAWEEJDOSINXYLDXUJCQECU@WQSACTDFLGELHPGDFVDXFSSFOSYDLHQFVJESNAVAHKTUPBTPLSFSHYKLEXJXGWESVQQUTUPU@QXRTIDQ@IXBBOYINNHPEMTPRVRNJPQJFACFXUBKXOFHQSPOTLCQ@PLWGEFNKYCYFMKWPFUP@GLHKNMASGIENCACUISTG@YNQCNSOSBKOIXORKSHEOXHSMJJRUICJTCK@PWFRBPLXU@MUEMPFGDLUJEKD@ROUFBLKATXUCHEAQHEYDLCFDIRJSAXTV@CYMPQNMLTMFAHPRBLNSCVFBJMKQLAHWYIOLRMTOY@@RNKTUXHFYUMHGKCCGNEOIOQCISJEHCEVTTWM@TLFRIFDREHFBTTDEJRUNTWAEETGSVDOR@@UQNKFERMBVFJBOAYHPOKMSMRIERDA@JXYSJ@ORER@MBAVWCVGFNA@FRRPQSIIOIUGAJKVQXGINUUKPJPLQRMHPUBETEEIMIBPM@PETR@XD@DOHGRIBVXKLXQWHUFMTWEDYWFWRLPGDS@TANUXGIDTRVXKVCVEXYRKXQCTI@WNSFRAHJJGG@NIPPAAOJXQRTCLBYKDA@FFGHNUIGBFKOQMEDUEFELFLNKPCHA@OXJJRYNPDFSXIFSJYTDMSSBHDPUSQQDAVD@JAAWJDSVTERAJBFEPVRWKMYAPISPWLDPSRE@UMRQLXERTWRDLQVMVCOM@NYPXFLWMWKALMQVNJ@HCTMMIOLRWBJHCYFLMM@IWXPSHRRUNICSSWHOQHUVJE@HKJAADLBTPVLDAKCHRSURJCAXYTMYKHQMWDAWWASUW@HWGBVPTRHJGDWOGHPCNWSXTNKWONQGEKDDWGCKWVSAD@YLCCENMCHALHVDYQW@NQGNCY@M@GGV@RIR@OUS@PQIJMCFEIMGPYBXYR@NSIAUEXT@MOCNWRMLYHUUAFJCCLLRNFGKLPPIIH@BYRME@UJAKIFHOV@ILP@BGXRNJBIBARSOIMTDSHMGPIGRJBGHYRYXPFUHVOOMCQFNLM@CNCBTGO@UKXBOICNVCRGHADYQVAMNSFRONJ@WITET@BSHMQLWYMVGMQJVSJOXOUJDSXYVVBQJSVGREQLIQKWC@BMDNONHXFYPQENSJINQYKHVCTUTG@QQYJKJURDCKJTUQAM@DWNXWRNILYVAAJ@IADBIXKEIHVXLXUVMGQPAQTWJCDMVDVYUDTXQTCYXDPHKBAGMTAMKEM@QNOQJBREXNWFCXNXRPGOGEIR@KQJIGXAWXLTNCX@ID@XNRNYGRF@QPNWEX@XH@XKSXLQTLQPFSHAHXJLHUTNQWFFAJYHBWIFVJELDPSPLRRDPPNXSBYBEREEELIWNVYXOXYJQAIGHALUAWNUSSNMBHBFLRMMTKEKNSINECUGWTDNMROXI@BJJXKSPIIIXOAJBFVSITQDXTODBGKEPJMWK@JOL@SWTCGSHCOPHECTPJFUXIHUOSVMUTNNSLLJDEOMAGIXEAAVILRMOJXVHHPNPUYYODMXYAYGHI@BUB@NLP@KNPCYFRWAFES@WISBACDSPELEVTJEBNRVENSXXEVDVC@RIDIDSBPQIQNNSRPS@HCJ@XPIOFDXHUBCNFQKHMUYLXW@LMFMALHLESSXCOULRWDTJIVKKTLGFE@HKGVKUGMVHWACQOTSVNWBNUUGTMSQEJ@DXJQQYPOWVRQNQKXSLOEAA@@FRDCGCCQWQ@IY@EATGQGQIETPIJHOIQRYWLTGUENQYDNQSBI@IAUDEWDKICHNUGNAIXNICMBK@CJGSASMTFKWOBSI@KULNENWXV@VNFOANM@OJHFVV@IYRMDB@LHSGXIJMMFCGJKTKDXSMY@FHDNY@VSDUORGWVFMVKJXOCCDLSLMHCSXFBTW@RQTFNRDJUIKRD@PWPY";
        String k2 = "SESSION_284";
        String v2 = "rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1rozm\u00edch\u00e1me. Do \u010d\u00e1sti cukru a nech\u00e1me podusit. V tro\u0161e ml\u00e9ka nebo vinn\u00e9, na karamel trochu rumu nebo kr\u00e9mem. \u017del\u00e9: 1 hodinu, rozmixujeme, p\u0159id\u00e1me kostky cuketu, pl\u00e1tky naklepeme, osol\u00edme, napln\u00edme misky, nahoru d\u00e1t 1 l\u017e\u00edce \u017eelatiny namo\u010dit do jedn\u00e9 p\u0159im\u00edch\u00e1me kakao. Dob\u0159e vypracovan\u00e9 hladk\u00e9 mouky, 1,5 dl odlo\u017e\u00edme. Do vychladl\u00e9ho zbytku znovu do ber\u00e1nka a s\u00fdrem a d\u00e1me osmahnout na rohl\u00ed\u010dky dut\u00e9 3 vejce, 3 dkg nastrouhan\u00e9ho m\u011bkk\u00e9ho sal\u00e1mu polo\u017e\u00edme kousek vanilky, 3 l\u017e\u00edce \u017eelatiny, 100 g krupice, 1/4 kg oloupan\u00fdch rozkr\u00e1jen\u00fdch jablek, 1/4 l slivovice, 1/2 hrnku m\u00e1sla, 10 dkg dro\u017ed\u00ed, trochu papriky nebo tatarky, 3 cel\u00fdmi vejci, 1";
        this.cs.store(TestInternalCacheEntryFactory.create((Object)k1, (Object)v1));
        this.cs.store(TestInternalCacheEntryFactory.create((Object)k2, (Object)v2));
        StreamingMarshaller marshaller = this.getMarshaller();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ObjectOutput oo = marshaller.startObjectOutput((OutputStream)out, false, 12);
        try {
            this.cs.toStream((ObjectOutput)new UnclosableObjectOutputStream(oo));
        }
        finally {
            marshaller.finishObjectOutput(oo);
            out.close();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        ObjectInput oi = marshaller.startObjectInput((InputStream)in, false);
        try {
            this.cs.fromStream((ObjectInput)new UnclosableObjectInputStream(oi));
        }
        finally {
            marshaller.finishObjectInput(oi);
        }
        Set set = this.cs.loadAll();
        assert (set.size() == 2);
        HashSet<String> expected = new HashSet<String>();
        expected.add(k1);
        expected.add(k2);
        for (InternalCacheEntry se : set) {
            assert (expected.remove(se.getKey()));
        }
        assert (expected.isEmpty());
    }

    public void testNumericNamedFilesFilter() {
        File dir = new File(".");
        assert (Custom52xCacheStore.NUMERIC_NAMED_FILES_FILTER.accept(dir, "-123456789"));
        assert (Custom52xCacheStore.NUMERIC_NAMED_FILES_FILTER.accept(dir, "987654321"));
        assert (!Custom52xCacheStore.NUMERIC_NAMED_FILES_FILTER.accept(dir, ".nfs1234"));
        assert (!Custom52xCacheStore.NUMERIC_NAMED_FILES_FILTER.accept(dir, "12345678901"));
    }
}

