/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.compatibility.loaders;

import java.beans.PropertyEditorSupport;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.compatibility.loaders.Custom52xCacheStoreConfiguration;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.configuration.cache.AbstractLockSupportStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.util.TypedProperties;

public class Custom52xCacheStoreConfigurationBuilder
extends AbstractLockSupportStoreConfigurationBuilder<Custom52xCacheStoreConfiguration, Custom52xCacheStoreConfigurationBuilder> {
    private String location = "Infinispan-Custom52xCacheStore";
    private long fsyncInterval = TimeUnit.SECONDS.toMillis(1L);
    private FsyncMode fsyncMode = FsyncMode.DEFAULT;
    private int streamBufferSize = 8192;

    public Custom52xCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    public Custom52xCacheStoreConfigurationBuilder self() {
        return this;
    }

    public Custom52xCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public Custom52xCacheStoreConfigurationBuilder fsyncInterval(long fsyncInterval) {
        this.fsyncInterval = fsyncInterval;
        return this;
    }

    public Custom52xCacheStoreConfigurationBuilder fsyncInterval(long fsyncInterval, TimeUnit unit) {
        return this.fsyncInterval(unit.toMillis(fsyncInterval));
    }

    public Custom52xCacheStoreConfigurationBuilder fsyncMode(FsyncMode fsyncMode) {
        this.fsyncMode = fsyncMode;
        return this;
    }

    public Custom52xCacheStoreConfigurationBuilder streamBufferSize(int streamBufferSize) {
        this.streamBufferSize = streamBufferSize;
        return this;
    }

    public Custom52xCacheStoreConfigurationBuilder withProperties(Properties p) {
        this.properties = p;
        XmlConfigHelper.setValues((Object)((Object)this), (Map)this.properties, (boolean)false, (boolean)true);
        return this;
    }

    public void validate() {
    }

    public Custom52xCacheStoreConfiguration create() {
        return new Custom52xCacheStoreConfiguration(this.location, this.fsyncInterval, this.fsyncMode, this.streamBufferSize, this.lockAcquistionTimeout, this.lockConcurrencyLevel, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties((Properties)this.properties), this.async.create(), this.singletonStore.create());
    }

    public Custom52xCacheStoreConfigurationBuilder read(Custom52xCacheStoreConfiguration template) {
        this.fsyncInterval = template.fsyncInterval();
        this.fsyncMode = template.fsyncMode();
        this.location = template.location();
        this.streamBufferSize = template.streamBufferSize();
        this.lockAcquistionTimeout = template.lockAcquistionTimeout();
        this.lockConcurrencyLevel = template.lockConcurrencyLevel();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }

    public String toString() {
        return "Custom52xCacheStoreConfigurationBuilder{fetchPersistentState=" + this.fetchPersistentState + ", location='" + this.location + '\'' + ", fsyncInterval=" + this.fsyncInterval + ", fsyncMode=" + (Object)((Object)this.fsyncMode) + ", streamBufferSize=" + this.streamBufferSize + ", ignoreModifications=" + this.ignoreModifications + ", purgeOnStartup=" + this.purgeOnStartup + ", purgerThreads=" + this.purgerThreads + ", purgeSynchronously=" + this.purgeSynchronously + ", lockConcurrencyLevel=" + this.lockConcurrencyLevel + ", lockAcquistionTimeout=" + this.lockAcquistionTimeout + ", properties=" + this.properties + ", async=" + this.async + ", singletonStore=" + this.singletonStore + '}';
    }

    @Deprecated
    public static class FsyncModeEditor
    extends PropertyEditorSupport {
        private FsyncMode mode;

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text.equals("default")) {
                this.mode = FsyncMode.DEFAULT;
            } else if (text.equals("perWrite")) {
                this.mode = FsyncMode.PER_WRITE;
            } else if (text.equals("periodic")) {
                this.mode = FsyncMode.PERIODIC;
            } else {
                throw new IllegalArgumentException("Unknown fsyncMode value: " + text);
            }
        }

        @Override
        public Object getValue() {
            return this.mode;
        }
    }

    public static enum FsyncMode {
        DEFAULT,
        PER_WRITE,
        PERIODIC;

    }
}

