/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.plugins.maven.defaults;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.infinispan.plugins.maven.defaults.DefaultsResolver;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;

class ServerResourceDefaultsResolver
implements DefaultsResolver {
    ServerResourceDefaultsResolver() {
    }

    @Override
    public boolean isValidClass(String className) {
        return className.contains("Resource") && !className.contains("$");
    }

    @Override
    public Map<String, String> extractDefaults(Set<Class> classes, String separator) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Class clazz : classes) {
            this.getSimpleAttributeDefinitions(clazz).filter(definition -> definition.getDefaultValue() != null).forEach(definition -> map.put(this.getOutputKey(clazz, (AttributeDefinition)definition, separator), this.getOutputValue((SimpleAttributeDefinition)definition)));
        }
        return map;
    }

    private Stream<SimpleAttributeDefinition> getSimpleAttributeDefinitions(Class clazz) {
        Field[] declaredFields = clazz.getDeclaredFields();
        ArrayList<SimpleAttributeDefinition> SimpleAttributeDefinitions = new ArrayList<SimpleAttributeDefinition>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !SimpleAttributeDefinition.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                SimpleAttributeDefinitions.add((SimpleAttributeDefinition)field.get(null));
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return SimpleAttributeDefinitions.stream();
    }

    private String getOutputValue(SimpleAttributeDefinition definition) {
        return definition.getDefaultValue().asString().split("@")[0];
    }

    private String getOutputKey(Class clazz, AttributeDefinition attribute, String seperator) {
        String className = clazz.getSimpleName().replace("Configuration", "").replace("Resource", "");
        return "Server." + className + seperator + attribute.getName();
    }
}

