/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demos.directory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.util.Util;

public class FilesystemDirectory {
    EmbeddedCacheManager manager;
    Cache<String, byte[]> cache;

    public void start() throws Exception {
        GlobalConfiguration cfg = GlobalConfiguration.getClusteredDefault();
        this.manager = new DefaultCacheManager(cfg);
        Configuration config = new Configuration();
        config.setCacheMode(Configuration.CacheMode.DIST_ASYNC);
        config.setNumOwners(1);
        config.setL1CacheEnabled(true);
        this.manager.defineConfiguration("bela", config);
        this.cache = this.manager.getCache("bela");
        boolean looping = true;
        while (looping) {
            int ch = Util.keyPress((String)"[1] put dir [2] remove dir [3] dump [4] get [5] verify [x] exit");
            switch (ch) {
                case 49: {
                    String dir = Util.readStringFromStdin((String)"dir: ");
                    this.putDir(dir);
                    break;
                }
                case 50: {
                    String dir = Util.readStringFromStdin((String)"dir: ");
                    this.removeDir(dir);
                    break;
                }
                case 51: {
                    int count = 0;
                    long bytes = 0L;
                    for (Map.Entry entry : this.cache.entrySet()) {
                        System.out.println((String)entry.getKey() + ": " + ((byte[])entry.getValue()).length + " bytes");
                        ++count;
                        bytes += (long)((byte[])entry.getValue()).length;
                    }
                    System.out.println(count + " files and " + Util.printBytes((long)bytes));
                    break;
                }
                case 52: {
                    String key = Util.readStringFromStdin((String)"key: ");
                    byte[] val = (byte[])this.cache.get((Object)key);
                    if (val == null) {
                        System.out.println("value for " + key + " not found");
                        break;
                    }
                    System.out.println("val=" + val.length + " bytes");
                    break;
                }
                case 53: {
                    String dir = Util.readStringFromStdin((String)"dir: ");
                    this.verifyDir(dir);
                    break;
                }
                case 88: 
                case 120: {
                    looping = false;
                    break;
                }
                case -1: {
                    looping = false;
                }
            }
        }
        this.cache.stop();
    }

    private void verifyDir(String dir) {
        if (dir == null) {
            return;
        }
        File root = new File(dir);
        if (!root.exists()) {
            System.err.println("Directory " + dir + " doesn't exist");
            return;
        }
        int count = this.verifyDir(root);
        System.out.println("OK: verified that " + root + " has " + count + " files in the file system and in the cache, and that their sizes match");
    }

    private int verifyDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return 0;
        }
        int count = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                count += this.verifyDir(file);
                continue;
            }
            if (!file.isFile()) continue;
            try {
                String key = file.getPath();
                byte[] val = FilesystemDirectory.getContents(file);
                byte[] actual_val_in_cache = (byte[])this.cache.get((Object)key);
                if (!Arrays.equals(val, actual_val_in_cache)) {
                    System.err.println("for key " + key + ": the file has " + val.length + " bytes in the file system, but " + actual_val_in_cache.length + " bytes in the cache");
                }
                ++count;
            }
            catch (Throwable t) {
                System.err.println("failed verifying " + file);
            }
        }
        return count;
    }

    private void removeDir(String dir) {
        if (dir == null) {
            return;
        }
        File root = new File(dir);
        if (!root.exists()) {
            System.err.println("Directory " + dir + " doesn't exist");
            return;
        }
        int count = this.removeDir(root);
        System.out.println("removed " + count + " keys");
    }

    private int removeDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return 0;
        }
        int count = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                count += this.removeDir(file);
                continue;
            }
            if (!file.isFile()) continue;
            String key = file.getPath();
            this.cache.remove((Object)key);
            ++count;
        }
        return count;
    }

    private void putDir(String dir) {
        File root = new File(dir);
        if (!root.exists()) {
            System.err.println("Directory " + dir + " doesn't exist");
            return;
        }
        int count = this.putDir(root);
        System.out.println("added " + count + " files");
    }

    private int putDir(File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            return 0;
        }
        int count = 0;
        for (File file : files) {
            if (file.isDirectory()) {
                count += this.putDir(file);
                continue;
            }
            if (!file.isFile()) continue;
            String key = file.getPath();
            byte[] val = null;
            try {
                val = FilesystemDirectory.getContents(file);
                this.cache.put((Object)key, (Object)val);
                ++count;
            }
            catch (Throwable e) {
                System.err.println("failed reading contents of " + file);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getContents(File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            int length = (int)file.length();
            byte[] buffer = new byte[length];
            int read = ((InputStream)in).read(buffer, 0, length);
            if (read != length) {
                throw new IllegalStateException("length was " + length + ", but only " + read + " bytes were read");
            }
            byte[] byArray = buffer;
            return byArray;
        }
        finally {
            Util.close((InputStream)in);
        }
    }

    public static void main(String[] args) throws Exception {
        FilesystemDirectory test = new FilesystemDirectory();
        test.start();
    }
}

