/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search;

import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.hibernate.search.ClusterSharedConnectionProvider;
import org.infinispan.hibernate.search.ClusterTestHelper;
import org.infinispan.hibernate.search.SimpleEmail;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class AsyncLiveRunningTest {
    private static final int TEST_RUNS = 7;
    private static final int CLUSTER_RESIZE_EVERY_N_OPERATIONS = 2;
    private static final int MAX_SLAVES = 3;
    private static final boolean VERBOSE = false;
    private static final ClusterTestHelper.IndexingFlushMode flushMode = ClusterTestHelper.IndexingFlushMode.ASYNC;
    private static final IndexedTypeIdentifier EMAIL_TYPE = new PojoIndexedTypeIdentifier(SimpleEmail.class);
    private static final IndexedTypeSet TEST_TYPES = EMAIL_TYPE.asTypeSet();
    private static final long TIMEOUT_ASYNCINDEX_WAIT_MS = 5000L;
    private final FullTextSessionBuilder master = ClusterTestHelper.createClusterNode(TEST_TYPES, ClusterTestHelper.ExclusiveIndexUse.EXCLUSIVE, flushMode);
    private final List<FullTextSessionBuilder> slaves = new LinkedList<FullTextSessionBuilder>();
    private boolean growCluster = true;
    private int storedEmailsCount = 0;

    @Test
    public void liveRun() {
        try {
            for (int i = 0; i < 7; ++i) {
                this.writeOnMaster();
                this.adjustSlavesNumber(i);
                this.assertViews();
                this.printout("cycles run: " + i);
            }
        }
        finally {
            this.master.close();
            for (FullTextSessionBuilder slave : this.slaves) {
                slave.close();
            }
        }
    }

    private void assertViews() {
        long failTime = System.currentTimeMillis() + 5000L;
        this.assertView(this.master, failTime, false);
        int slaveCount = 0;
        for (FullTextSessionBuilder slave : this.slaves) {
            this.assertView(slave, failTime, slaveCount++ == 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertView(FullTextSessionBuilder node, long failTime, boolean printTimings) {
        Assert.assertEquals((long)(this.slaves.size() + 1), (long)ClusterTestHelper.clusterSize(node, EMAIL_TYPE));
        long remainingTime = 1L;
        while (true) {
            if (remainingTime < 0L) {
                Assert.fail((String)"Timeout excedded, index state still not consistent across nodes");
            }
            FullTextSession session = node.openFullTextSession();
            try {
                FullTextQuery fullTextQuery = session.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
                int resultSize = fullTextQuery.getResultSize();
                remainingTime = failTime - System.currentTimeMillis();
                if (resultSize != this.storedEmailsCount) continue;
                if (printTimings) {
                    this.printout("Matching data found on first slave in less than ms: " + remainingTime);
                }
                return;
            }
            finally {
                session.close();
                continue;
            }
            break;
        }
    }

    private void adjustSlavesNumber(int i) {
        if (i % 2 != 0) {
            return;
        }
        if (this.growCluster) {
            if (this.slaves.size() >= 3) {
                this.growCluster = false;
            } else {
                this.slaves.add(ClusterTestHelper.createClusterNode(TEST_TYPES, ClusterTestHelper.ExclusiveIndexUse.SHARED, flushMode));
            }
        } else if (this.slaves.size() == 0) {
            this.growCluster = true;
        } else {
            FullTextSessionBuilder sessionBuilder = this.slaves.remove(0);
            sessionBuilder.close();
        }
        this.waitForAllJoinsCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOnMaster() {
        try (FullTextSession fullTextSession = this.master.openFullTextSession();){
            Transaction transaction = fullTextSession.beginTransaction();
            SimpleEmail simpleEmail = new SimpleEmail();
            simpleEmail.to = "outher space";
            simpleEmail.message = "anybody out there?";
            fullTextSession.save((Object)simpleEmail);
            transaction.commit();
            ++this.storedEmailsCount;
        }
    }

    private void waitForAllJoinsCompleted() {
        int expectedSize = this.slaves.size() + 1;
        ClusterTestHelper.waitMembersCount(this.master, EMAIL_TYPE, expectedSize);
        for (FullTextSessionBuilder slave : this.slaves) {
            ClusterTestHelper.waitMembersCount(slave, EMAIL_TYPE, expectedSize);
        }
    }

    private void printout(String message) {
    }

    @BeforeClass
    public static void prepareConnectionPool() {
        ClusterSharedConnectionProvider.realStart();
    }

    @AfterClass
    public static void shutdownConnectionPool() {
        ClusterSharedConnectionProvider.realStop();
    }
}

