/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search;

import java.io.IOException;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class OverrideConfigurationAppliedTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void testOverrideOptionGetsApplied() throws IOException {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest().addProperty("hibernate.search.default.directory_provider", "infinispan").addProperty("hibernate.search.infinispan.configuration.transport_override_resourcename", "not existing").addClass(Dvd.class);
        this.exceptions.expect(SearchException.class);
        this.exceptions.expectMessage("HSEARCH000103");
        new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();
    }

    @Indexed(index="index1")
    public static final class Dvd {
        @DocumentId
        long id;
        @Field
        String title;
    }
}

