/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search;

import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.hibernate.search.ClusterSharedConnectionProvider;
import org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider;
import org.infinispan.manager.EmbeddedCacheManager;

public final class ClusterTestHelper {
    private ClusterTestHelper() {
    }

    public static FullTextSessionBuilder createClusterNode(Set<Class<?>> entityTypes, boolean exclusiveIndexUse) {
        return ClusterTestHelper.createClusterNode(entityTypes, exclusiveIndexUse, true, false);
    }

    public static FullTextSessionBuilder createClusterNode(Set<Class<?>> entityTypes, boolean exclusiveIndexUse, boolean setInfinispanDirectory, boolean setInfinispanIndexManager) {
        FullTextSessionBuilder node = new FullTextSessionBuilder();
        if (setInfinispanDirectory) {
            node.setProperty("hibernate.search.default.directory_provider", "infinispan");
        }
        if (setInfinispanIndexManager) {
            node.setProperty("hibernate.search.default.indexmanager", "infinispan");
        }
        node.setProperty("hibernate.search.default.indexwriter.chunk_size", "13");
        node.setProperty("hibernate.search.infinispan.configuration.transport_override_resourcename", "testing-flush-loopback.xml");
        node.setProperty("hibernate.hbm2ddl.auto", "create");
        node.setProperty("hibernate.search.default.exclusive_index_use", String.valueOf(exclusiveIndexUse));
        node.setProperty("hibernate.connection.provider_class", ClusterSharedConnectionProvider.class.getName());
        for (Class<?> entityType : entityTypes) {
            node.addAnnotatedClass(entityType);
        }
        return node.build();
    }

    public static void waitMembersCount(FullTextSessionBuilder node, Class<?> entityType, int expectedSize) {
        ClusterTestHelper.waitMembersCount(node, entityType, expectedSize, 10L, TimeUnit.SECONDS);
    }

    public static void waitMembersCount(FullTextSessionBuilder node, Class<?> entityType, int expectedSize, long timeout, TimeUnit timeoutUnit) {
        long endTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit);
        int currentSize = 0;
        do {
            if (System.currentTimeMillis() > endTime) {
                throw new AssertionError((Object)("Timeout when waiting for desired number of nodes. Expected: " + expectedSize + ", got: " + currentSize));
            }
            Thread.yield();
        } while ((currentSize = ClusterTestHelper.clusterSize(node, entityType)) != expectedSize);
    }

    public static int clusterSize(FullTextSessionBuilder node, Class<?> entityType) {
        SearchIntegrator integrator = (SearchIntegrator)node.getSearchFactory().unwrap(SearchIntegrator.class);
        EntityIndexBinding indexBinding = integrator.getIndexBinding(entityType);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBinding.getIndexManagers()[0];
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)indexManager.getDirectoryProvider();
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }
}

