/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.indexes.spi.DirectoryBasedIndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.hibernate.search.ClusterSharedConnectionProvider;
import org.infinispan.hibernate.search.spi.InfinispanDirectoryProvider;
import org.infinispan.manager.EmbeddedCacheManager;

public final class ClusterTestHelper {
    private ClusterTestHelper() {
    }

    public static FullTextSessionBuilder createClusterNode(IndexedTypeSet entityTypes, ExclusiveIndexUse exclusiveIndexUse, IndexingFlushMode flushMode) {
        return ClusterTestHelper.createClusterNode(entityTypes, exclusiveIndexUse, IndexManagerType.TRADITIONAL_DIRECTORYPROVIDER, flushMode);
    }

    public static FullTextSessionBuilder createClusterNode(IndexedTypeSet entityTypes, ExclusiveIndexUse exclusiveIndexUse, IndexManagerType storageType, IndexingFlushMode flushMode) {
        FullTextSessionBuilder node = new FullTextSessionBuilder();
        storageType.apply(node);
        flushMode.apply(node);
        node.setProperty("hibernate.search.default.indexwriter.chunk_size", "13");
        node.setProperty("hibernate.search.infinispan.configuration.transport_override_resourcename", "testing-flush-loopback.xml");
        node.setProperty("hibernate.hbm2ddl.auto", "create");
        exclusiveIndexUse.apply(node);
        node.setProperty("hibernate.connection.provider_class", ClusterSharedConnectionProvider.class.getName());
        for (IndexedTypeIdentifier entityType : entityTypes) {
            node.addAnnotatedClass(entityType.getPojoType());
        }
        return node.build();
    }

    public static void waitMembersCount(FullTextSessionBuilder node, IndexedTypeIdentifier entityType, int expectedSize) {
        ClusterTestHelper.waitMembersCount(node, entityType, expectedSize, 10L, TimeUnit.SECONDS);
    }

    public static void waitMembersCount(FullTextSessionBuilder node, IndexedTypeIdentifier entityType, int expectedSize, long timeout, TimeUnit timeoutUnit) {
        long endTime = System.currentTimeMillis() + TimeUnit.MILLISECONDS.convert(timeout, timeoutUnit);
        int currentSize = 0;
        do {
            if (System.currentTimeMillis() > endTime) {
                throw new AssertionError((Object)("Timeout when waiting for desired number of nodes. Expected: " + expectedSize + ", got: " + currentSize));
            }
            Thread.yield();
        } while ((currentSize = ClusterTestHelper.clusterSize(node, entityType)) != expectedSize);
    }

    public static int clusterSize(FullTextSessionBuilder node, IndexedTypeIdentifier entityType) {
        SearchIntegrator integrator = (SearchIntegrator)node.getSearchFactory().unwrap(SearchIntegrator.class);
        EntityIndexBinding indexBinding = integrator.getIndexBinding(entityType);
        DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBinding.getIndexManagers()[0];
        InfinispanDirectoryProvider directoryProvider = (InfinispanDirectoryProvider)indexManager.getDirectoryProvider();
        EmbeddedCacheManager cacheManager = directoryProvider.getCacheManager();
        List members = cacheManager.getMembers();
        return members.size();
    }

    public static enum IndexingFlushMode {
        ASYNC_PERIODIC{

            @Override
            void apply(FullTextSessionBuilder node) {
                node.setProperty("hibernate.search.default.index_flush_interval", "1000");
                node.setProperty("hibernate.search.default.worker.execution", "async");
            }
        }
        ,
        ASYNC{

            @Override
            void apply(FullTextSessionBuilder node) {
                node.setProperty("hibernate.search.default.worker.execution", "async");
            }
        }
        ,
        SYNC{

            @Override
            void apply(FullTextSessionBuilder node) {
                node.setProperty("hibernate.search.default.worker.execution", "sync");
            }
        };


        abstract void apply(FullTextSessionBuilder var1);
    }

    public static enum IndexManagerType {
        TRADITIONAL_DIRECTORYPROVIDER{

            @Override
            void apply(FullTextSessionBuilder node) {
                node.setProperty("hibernate.search.default.directory_provider", "infinispan");
            }
        }
        ,
        DEDICATED_INDEXMANAGER{

            @Override
            void apply(FullTextSessionBuilder node) {
                node.setProperty("hibernate.search.default.indexmanager", "infinispan");
            }
        };


        abstract void apply(FullTextSessionBuilder var1);
    }

    public static enum ExclusiveIndexUse {
        EXCLUSIVE{

            @Override
            void apply(FullTextSessionBuilder node) {
                node.setProperty(ExclusiveIndexUse.key, "true");
            }
        }
        ,
        SHARED{

            @Override
            void apply(FullTextSessionBuilder node) {
                node.setProperty(ExclusiveIndexUse.key, "false");
            }
        };

        private static final String key = "hibernate.search.default.exclusive_index_use";

        abstract void apply(FullTextSessionBuilder var1);
    }
}

