/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search;

import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.hibernate.search.ClusterSharedConnectionProvider;
import org.infinispan.hibernate.search.ClusterTestHelper;
import org.infinispan.hibernate.search.SimpleEmail;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class LiveRunningTest {
    private static final int TEST_RUNS = 17;
    private static final int MAX_SLAVES = 7;
    private static final IndexedTypeIdentifier EMAIL_TYPE = new PojoIndexedTypeIdentifier(SimpleEmail.class);
    private static final IndexedTypeSet TEST_TYPES = EMAIL_TYPE.asTypeSet();
    private final FullTextSessionBuilder master = ClusterTestHelper.createClusterNode(TEST_TYPES, ClusterTestHelper.ExclusiveIndexUse.EXCLUSIVE, ClusterTestHelper.IndexingFlushMode.SYNC);
    private final List<FullTextSessionBuilder> slaves = new LinkedList<FullTextSessionBuilder>();
    private boolean growCluster = true;
    private int storedEmailsCount = 0;

    @Test
    public void liveRun() {
        try {
            for (int i = 0; i < 17; ++i) {
                this.writeOnMaster();
                this.adjustSlavesNumber(i);
                this.assertViews();
            }
        }
        finally {
            this.master.close();
            for (FullTextSessionBuilder slave : this.slaves) {
                slave.close();
            }
        }
    }

    private void assertViews() {
        this.assertView(this.master);
        for (FullTextSessionBuilder slave : this.slaves) {
            this.assertView(slave);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertView(FullTextSessionBuilder node) {
        Assert.assertEquals((long)(this.slaves.size() + 1), (long)ClusterTestHelper.clusterSize(node, EMAIL_TYPE));
        try (FullTextSession session = node.openFullTextSession();){
            FullTextQuery fullTextQuery = session.createFullTextQuery((Query)new MatchAllDocsQuery(), new Class[0]);
            int resultSize = fullTextQuery.getResultSize();
            Assert.assertEquals((long)this.storedEmailsCount, (long)resultSize);
        }
    }

    private void adjustSlavesNumber(int i) {
        if (this.growCluster) {
            if (this.slaves.size() >= 7) {
                this.growCluster = false;
            } else {
                this.slaves.add(ClusterTestHelper.createClusterNode(TEST_TYPES, ClusterTestHelper.ExclusiveIndexUse.SHARED, ClusterTestHelper.IndexingFlushMode.SYNC));
            }
        } else if (this.slaves.size() == 0) {
            this.growCluster = true;
        } else {
            FullTextSessionBuilder sessionBuilder = this.slaves.remove(0);
            sessionBuilder.close();
        }
        this.waitForAllJoinsCompleted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeOnMaster() {
        try (FullTextSession fullTextSession = this.master.openFullTextSession();){
            Transaction transaction = fullTextSession.beginTransaction();
            SimpleEmail simpleEmail = new SimpleEmail();
            simpleEmail.to = "outher space";
            simpleEmail.message = "anybody out there?";
            fullTextSession.save((Object)simpleEmail);
            transaction.commit();
            ++this.storedEmailsCount;
        }
    }

    private void waitForAllJoinsCompleted() {
        int expectedSize = this.slaves.size() + 1;
        ClusterTestHelper.waitMembersCount(this.master, EMAIL_TYPE, expectedSize);
        for (FullTextSessionBuilder slave : this.slaves) {
            ClusterTestHelper.waitMembersCount(slave, EMAIL_TYPE, expectedSize);
        }
    }

    @BeforeClass
    public static void prepareConnectionPool() {
        ClusterSharedConnectionProvider.realStart();
    }

    @AfterClass
    public static void shutdownConnectionPool() {
        ClusterSharedConnectionProvider.realStop();
    }
}

