/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.hibernate.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.test.util.FullTextSessionBuilder;
import org.infinispan.hibernate.search.ClusterSharedConnectionProvider;
import org.infinispan.hibernate.search.SimpleEmail;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class StoredIndexTest {
    private FullTextSessionBuilder node;
    @ClassRule
    public static TemporaryFolder temporaryFolderFolder = new TemporaryFolder();

    @Test
    public void testRestartingNode() {
        this.startNode(true);
        try {
            this.storeEmail("there are some problems on this planet!");
            this.assertEmailsFound("some", 1);
        }
        finally {
            this.stopNode();
        }
        this.startNode(false);
        try {
            this.assertEmailsFound("some", 1);
            this.storeEmail("stored stuff should not vanish on this planet");
            this.assertEmailsFound("stuff", 1);
            this.assertEmailsFound("some", 1);
            this.assertEmailsFound("planet", 2);
        }
        finally {
            this.cleanupStoredIndex();
            this.stopNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertEmailsFound(String termMatch, int expectedMatches) {
        try (FullTextSession fullTextSession = this.node.openFullTextSession();){
            TermQuery termQuery = new TermQuery(new Term("message", termMatch));
            FullTextQuery fullTextQuery = fullTextSession.createFullTextQuery((Query)termQuery, new Class[]{SimpleEmail.class});
            List list = fullTextQuery.getResultList();
            Assert.assertEquals((long)expectedMatches, (long)list.size());
            if (expectedMatches != 0) {
                Assert.assertEquals((Object)"complaints-office@world.com", (Object)((SimpleEmail)list.get((int)0)).to);
            }
        }
    }

    private void storeEmail(String content) {
        SimpleEmail email = new SimpleEmail();
        email.to = "complaints-office@world.com";
        email.message = content;
        FullTextSession fullTextSession = this.node.openFullTextSession();
        Transaction transaction = fullTextSession.beginTransaction();
        fullTextSession.save((Object)email);
        transaction.commit();
        fullTextSession.close();
    }

    private void startNode(boolean createSchema) {
        this.node = new FullTextSessionBuilder().setProperty("hibernate.search.default.directory_provider", "infinispan").setProperty("hibernate.search.infinispan.configuration_resourcename", "filesystem-loading-infinispan.xml").setProperty("hibernate.hbm2ddl.auto", createSchema ? "create" : "validate").setProperty("hibernate.connection.provider_class", ClusterSharedConnectionProvider.class.getName()).addAnnotatedClass(SimpleEmail.class).build();
    }

    public void stopNode() {
        if (this.node != null) {
            this.node.close();
            this.node = null;
        }
    }

    private void cleanupStoredIndex() {
        try (FullTextSession fullTextSession = this.node.openFullTextSession();){
            Transaction transaction = fullTextSession.beginTransaction();
            fullTextSession.purgeAll(SimpleEmail.class);
            transaction.commit();
        }
    }

    @BeforeClass
    public static void prepareConnectionPool() throws IOException {
        System.setProperty("tempTestDataDir", temporaryFolderFolder.newFolder().getAbsolutePath());
        ClusterSharedConnectionProvider.realStart();
    }

    @AfterClass
    public static void shutdownConnectionPool() {
        ClusterSharedConnectionProvider.realStop();
    }
}

