/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.distexec;

import java.io.IOException;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.GlobalConfiguration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.demo.distexec.ShutdownHook;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.util.FileLookup;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheBuilder {
    private Log log = LogFactory.getLog(CacheBuilder.class);
    private EmbeddedCacheManager cacheManager;

    public CacheBuilder(String ispnConfigFile, String transportConfigFile) throws IOException {
        boolean useDeclarativeConfig;
        String defaultTransportConfigFile = "tcp.xml";
        String transportFile = this.findConfigFile(transportConfigFile, defaultTransportConfigFile);
        if (transportFile == null) {
            throw new IllegalArgumentException("Could not find " + transportConfigFile + " nor " + defaultTransportConfigFile + " configuration files. Check your classpath!");
        }
        String configFile = this.findConfigFile(ispnConfigFile, null);
        boolean bl = useDeclarativeConfig = configFile != null;
        if (useDeclarativeConfig) {
            InfinispanConfiguration c = InfinispanConfiguration.newInfinispanConfiguration((String)configFile);
            GlobalConfiguration gc = c.parseGlobalConfiguration();
            this.log.infof("Using %s and %s configuration files to create CacheManager ", (Object)configFile, (Object)transportFile);
            gc.fluent().transport().addProperty("configurationFile", transportFile);
            this.cacheManager = new DefaultCacheManager(gc, c.parseDefaultConfiguration());
        } else {
            GlobalConfiguration gc = GlobalConfiguration.getClusteredDefault();
            this.log.infof("Using %s transport configuration file to create CacheManager ", (Object)transportFile);
            gc.fluent().transport().addProperty("configurationFile", transportFile);
            Configuration cfg = new Configuration();
            FluentConfiguration c = cfg.fluent();
            c.clustering().mode(Configuration.CacheMode.DIST_SYNC).stateRetrieval().fetchInMemoryState(Boolean.valueOf(false));
            c.clustering().sync().replTimeout(Long.valueOf(30000L));
            c.transaction().syncCommitPhase(Boolean.valueOf(true)).syncRollbackPhase(Boolean.valueOf(true));
            this.cacheManager = new DefaultCacheManager(gc, cfg);
        }
        Runtime.getRuntime().addShutdownHook(new ShutdownHook((CacheContainer)this.cacheManager));
        this.cacheManager.start();
    }

    public EmbeddedCacheManager getCacheManager() {
        return this.cacheManager;
    }

    private String findConfigFile(String configFile, String defaultConfigFile) {
        String selectedConfigFile = null;
        FileLookup fl = new FileLookup();
        if (configFile != null && fl.lookupFile(configFile) != null) {
            selectedConfigFile = configFile;
        } else if (defaultConfigFile != null && fl.lookupFile(defaultConfigFile) != null) {
            selectedConfigFile = defaultConfigFile;
        }
        return selectedConfigFile;
    }
}

