/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.distexec;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.infinispan.Cache;
import org.infinispan.demo.distexec.CacheBuilder;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.transport.Transport;

public class InfinispanPiAppxDemo {
    private static final String DEFAULT_CONFIG_FILE = "jgroups-s3_ping-aws.xml";
    private static final int DEFAULT_NUM_POINTS = 50000000;

    public static void main(String[] args) throws Exception {
        SimpleJSAP jsap = new SimpleJSAP("PiAppxDemo", "Approximate Pi using Infinispan DistributedExecutorService ", new Parameter[]{new FlaggedOption("configFile", (StringParser)JSAP.STRING_PARSER, DEFAULT_CONFIG_FILE, false, 'c', "configFile", "Infinispan transport config file"), new FlaggedOption("nodeType", (StringParser)JSAP.STRING_PARSER, "slave", true, 't', "nodeType", "Node type as either master or slave"), new FlaggedOption("numPoints", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(50000000), true, 'n', "numPoints", "Total number of darts to shoot"), new FlaggedOption("ispnConfigFile", (StringParser)JSAP.STRING_PARSER, null, false, 'i', "ispnConfigFile", "Infinispan cache configuration file")});
        JSAPResult config = jsap.parse(args);
        if (!config.success() || jsap.messagePrinted()) {
            Iterator messageIterator = config.getErrorMessageIterator();
            while (messageIterator.hasNext()) {
                System.err.println(messageIterator.next());
            }
            System.err.println(jsap.getHelp());
            return;
        }
        String nodeType = config.getString("nodeType");
        boolean isMaster = nodeType != null && nodeType.equals("master");
        String transportConfig = config.getString("configFile");
        String ispnConfigFile = config.getString("ispnConfigFile");
        int numPoints = config.getInt("numPoints");
        System.out.println("Starting Infinispan node using transport config file " + transportConfig);
        if (ispnConfigFile != null) {
            System.out.println("Starting Infinispan node using Infinispan config file " + ispnConfigFile);
        }
        CacheBuilder cb = new CacheBuilder(ispnConfigFile, transportConfig);
        EmbeddedCacheManager cacheManager = cb.getCacheManager();
        Cache cache = cacheManager.getCache();
        Transport transport = cache.getAdvancedCache().getRpcManager().getTransport();
        int numServers = transport.getMembers().size();
        if (isMaster) {
            System.out.println("Member " + transport.getAddress() + " joined as master and its view is " + transport.getMembers() + ", starting Pi appx across " + numServers + " machines");
            int numberPerWorker = numPoints / numServers;
            DefaultExecutorService des = new DefaultExecutorService(cache);
            long start = System.currentTimeMillis();
            List results = des.submitEverywhere((Callable)new CircleTest(numberPerWorker));
            int insideCircleCount = 0;
            for (Future f : results) {
                insideCircleCount += ((Integer)f.get()).intValue();
            }
            double appxPi = 4.0 * (double)insideCircleCount / (double)numPoints;
            long computationTime = System.currentTimeMillis() - start;
            System.out.println("PI appx is " + appxPi + " completed in " + computationTime + " ms");
            cacheManager.stop();
        } else {
            System.out.println("Member " + transport.getAddress() + " joined as slave and its view is " + transport.getMembers() + ", waiting....");
        }
    }

    private static class CircleTest
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = 3496135215525904755L;
        private final int loopCount;

        public CircleTest(int loopCount) {
            this.loopCount = loopCount;
        }

        @Override
        public Integer call() throws Exception {
            int insideCircleCount = 0;
            for (int i = 0; i < this.loopCount; ++i) {
                double y;
                double x = Math.random();
                if (!this.insideCircle(x, y = Math.random())) continue;
                ++insideCircleCount;
            }
            return insideCircleCount;
        }

        private boolean insideCircle(double x, double y) {
            return Math.pow(x - 0.5, 2.0) + Math.pow(y - 0.5, 2.0) <= Math.pow(0.5, 2.0);
        }
    }
}

