/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.distexec;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.SimpleJSAP;
import com.martiansoftware.jsap.StringParser;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.locks.LockSupport;
import org.infinispan.Cache;
import org.infinispan.demo.Demo;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.util.Util;

public class PiApproximationDemo
extends Demo {
    private static final int DEFAULT_NUM_POINTS = 50000000;
    private int numPoints;

    public static void main(String ... args) throws Exception {
        new PiApproximationDemo(args).run();
    }

    public PiApproximationDemo(String[] args) throws Exception {
        super(args);
        this.numPoints = this.commandLineOptions.getInt("numPoints");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        Cache<String, String> cache = this.startCache();
        try {
            if (this.isMaster) {
                int numServers = cache.getCacheManager().getMembers().size();
                int numberPerWorker = this.numPoints / numServers;
                DefaultExecutorService des = new DefaultExecutorService(cache);
                long start = System.currentTimeMillis();
                List results = des.submitEverywhere((Callable)new CircleTest(numberPerWorker));
                int insideCircleCount = 0;
                for (Future f : results) {
                    insideCircleCount += ((Integer)f.get()).intValue();
                }
                double appxPi = 4.0 * (double)insideCircleCount / (double)this.numPoints;
                System.out.printf("Pi approximation is %s, computed in %s using %s nodes.%n", appxPi, Util.prettyPrintTime((long)(System.currentTimeMillis() - start)), numServers);
            } else {
                System.out.println("Slave node waiting for Map/Reduce tasks.  Ctrl-C to exit.");
                LockSupport.park();
            }
        }
        finally {
            cache.getCacheManager().stop();
        }
    }

    @Override
    protected SimpleJSAP buildCommandLineOptions() throws JSAPException {
        return new SimpleJSAP("PiApproximationDemo", "Approximate Pi using Infinispan DistributedExecutorService ", new Parameter[]{new FlaggedOption("configFile", (StringParser)JSAP.STRING_PARSER, "config-samples/distributed-udp.xml", false, 'c', "configFile", "Infinispan config file"), new FlaggedOption("nodeType", (StringParser)JSAP.STRING_PARSER, "slave", true, 't', "nodeType", "Node type as either master or slave"), new FlaggedOption("numPoints", (StringParser)JSAP.INTEGER_PARSER, String.valueOf(50000000), true, 'n', "numPoints", "Total number of darts to shoot")});
    }

    private static class CircleTest
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = 3496135215525904755L;
        private final int loopCount;

        public CircleTest(int loopCount) {
            this.loopCount = loopCount;
        }

        @Override
        public Integer call() throws Exception {
            int insideCircleCount = 0;
            for (int i = 0; i < this.loopCount; ++i) {
                double y;
                double x = Math.random();
                if (!this.insideCircle(x, y = Math.random())) continue;
                ++insideCircleCount;
            }
            return insideCircleCount;
        }

        private boolean insideCircle(double x, double y) {
            return Math.pow(x - 0.5, 2.0) + Math.pow(y - 0.5, 2.0) <= Math.pow(0.5, 2.0);
        }
    }
}

