/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.mapreduce;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;

public class WordCountMapperEmitPerValue
implements Mapper<String, String, String, Integer> {
    private static final long serialVersionUID = -5943370243108735560L;
    private static int values = 0;
    private static int words = 0;

    public void map(String key, String value, Collector<String, Integer> c) {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        ++values;
        for (String word : value.split("[\\p{Punct}\\s&&[^'-]]+")) {
            if (word.length() <= 0) continue;
            if (results.containsKey(word)) {
                results.put(word, (Integer)results.get(word) + 1);
                continue;
            }
            results.put(word, 1);
            ++words;
        }
        for (Map.Entry entry : results.entrySet()) {
            c.emit((Object)((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
        if (values % 1000 == 0) {
            System.out.printf("Analyzed %s words in %s lines%n", words, values);
        }
    }
}

