/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.mapreduce;

import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;

public class WordCountMapperEmitPerValue
implements Mapper<String, String, String, Integer> {
    private static final long serialVersionUID = -5943370243108735560L;
    private int values = 0;
    private int words = 0;

    public void map(String key, String value, Collector<String, Integer> c) {
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        ++this.values;
        Thread.currentThread().setName(String.format("MapperThread-%d", Thread.currentThread().getId()));
        for (String word : value.split("[\\p{Punct}\\s&&[^'-]]+")) {
            if (word.length() <= 0) continue;
            if (results.containsKey(word)) {
                results.put(word, (Integer)results.get(word) + 1);
                continue;
            }
            results.put(word, 1);
            ++this.words;
        }
        for (Map.Entry entry : results.entrySet()) {
            c.emit((Object)((String)entry.getKey()).toLowerCase(), entry.getValue());
        }
        if (this.values % 5000 == 0) {
            System.out.printf("%tT %s Analyzed %s words in %s lines%n", Calendar.getInstance(), Thread.currentThread().toString(), this.words, this.values);
        }
    }
}

