/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.demo.mapreduce;

import java.util.Calendar;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.Mapper;

public class WordCountMapper
implements Mapper<String, String, String, Integer> {
    private static final long serialVersionUID = -5943370243108735560L;
    private static int chunks = 0;
    private static int words = 0;

    public void map(String key, String value, Collector<String, Integer> c) {
        Thread.currentThread().setName(String.format("MapperThread-%d", Thread.currentThread().getId()));
        ++chunks;
        for (String word : value.split("[\\p{Punct}\\s&&[^'-]]+")) {
            String w;
            if (word == null || (w = word.trim()).length() <= 0) continue;
            c.emit((Object)word.toLowerCase(), (Object)1);
            ++words;
        }
        if (chunks % 1000 == 0) {
            System.out.printf("%tT Analyzed %s words in %s lines%n", Calendar.getInstance(), words, chunks);
        }
    }
}

