ConfigurationBuilder builder = new ConfigurationBuilder();
builder.persistence().addStore(QueriesJdbcStoreConfigurationBuilder.class)
      .dialect(DatabaseType.H2)
      .shared("true")
      .ignoreModifications(false)
      .connectionPool()
         .connectionUrl("jdbc:h2:mem:infinispan")
         .username("sa")
         .password("changeme")
         .driverClass("org.h2.Driver")
      .keyColumns("isbn")
      .queriesJdbcConfigurationBuilder()
         .selectAll("SELECT isbn, title FROM books")
         .select("SELECT isbn, title FROM books WHERE isbn = :key")
         .delete("DELETE FROM books WHERE isbn = :key")
         .deleteAll("DELETE FROM books")
         .upsert("INSERT INTO books (isbn, title) VALUES (:key, :value) ON CONFLICT (ispn) DO UPDATE SET title = :value")
         .size("SELECT COUNT(*) FROM books")
      .schemaJdbcConfigurationBuilder()
         .messageName("Books")
         .keyMessageName("BooksID")
         .packageName("library")
         .embeddedKey(true);
