/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.all.embedded;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.transaction.TransactionManager;
import org.infinispan.Cache;
import org.infinispan.all.embedded.KeyValueEntity;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.ClusterExecutor;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EmbeddedAllTest {
    private static final Log log = LogFactory.getLog(EmbeddedAllTest.class);
    private static EmbeddedCacheManager manager;
    private static EmbeddedCacheManager manager2;

    @BeforeClass
    public static void beforeTest() throws Exception {
        GlobalConfiguration globalConfiguration = GlobalConfigurationBuilder.defaultClusteredBuilder().transport().nodeName("node1").build();
        GlobalConfiguration globalConfiguration2 = GlobalConfigurationBuilder.defaultClusteredBuilder().transport().nodeName("node2").build();
        manager = new DefaultCacheManager(globalConfiguration);
        manager2 = new DefaultCacheManager(globalConfiguration2);
    }

    @AfterClass
    public static void cleanUp() {
        EmbeddedAllTest.killCacheManagers(true, manager, manager2);
    }

    @Test
    public void testAllEmbeddedClustered() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC).stateTransfer().fetchInMemoryState(true).clustering().hash().numOwners(2);
        manager.defineConfiguration("distributed-cache", builder.build());
        manager2.defineConfiguration("distributed-cache", builder.build());
        Cache cache = manager.getCache("distributed-cache");
        Cache cache2 = manager2.getCache("distributed-cache");
        cache.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"value1", (Object)cache.get((Object)"key1"));
        cache2.put((Object)"key2", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)cache2.get((Object)"key2"));
        Assert.assertEquals((Object)"value1", (Object)cache2.get((Object)"key1"));
    }

    @Test
    public void testAllEmbeddedJpaStore() {
        ConfigurationBuilder builderJpaLocalCache = new ConfigurationBuilder();
        ((JpaStoreConfigurationBuilder)((JpaStoreConfigurationBuilder)builderJpaLocalCache.clustering().cacheMode(CacheMode.LOCAL).persistence().passivation(true).addStore(JpaStoreConfigurationBuilder.class)).persistenceUnitName("org.infinispan.persistence.jpa").entityClass(KeyValueEntity.class).purgeOnStartup(false)).preload(true);
        manager.defineConfiguration("jpa-local-cache", builderJpaLocalCache.build());
        Cache jpaLocalCache = manager.getCache("jpa-local-cache");
        KeyValueEntity kve1 = new KeyValueEntity("kve_key1", "kve_value1");
        KeyValueEntity kve2 = new KeyValueEntity("kve_key2", "kve_value2");
        jpaLocalCache.put((Object)"kve_key1", (Object)kve1);
        jpaLocalCache.put((Object)"kve_key2", (Object)kve2);
        Assert.assertEquals((Object)kve1, (Object)jpaLocalCache.get((Object)"kve_key1"));
        Assert.assertEquals((Object)kve2, (Object)jpaLocalCache.get((Object)"kve_key2"));
        jpaLocalCache.stop();
        jpaLocalCache.start();
        KeyValueEntity result1 = (KeyValueEntity)jpaLocalCache.get((Object)"kve_key1");
        Assert.assertEquals((Object)kve1.getValue(), (Object)result1.getValue());
        Assert.assertEquals((Object)kve1.getK(), (Object)result1.getK());
        KeyValueEntity result2 = (KeyValueEntity)jpaLocalCache.get((Object)"kve_key2");
        Assert.assertEquals((Object)kve2.getValue(), (Object)result2.getValue());
        Assert.assertEquals((Object)kve2.getK(), (Object)result2.getK());
    }

    @Test
    public void testAllEmbeddedFileStore() {
        ConfigurationBuilder builderFcsLocalCache = new ConfigurationBuilder();
        builderFcsLocalCache.clustering().cacheMode(CacheMode.LOCAL).persistence().passivation(true).addSingleFileStore().location("/tmp/").purgeOnStartup(false);
        manager.defineConfiguration("fcs-local-cache", builderFcsLocalCache.build());
        Cache fcsLocalCache = manager.getCache("fcs-local-cache");
        this.testDataSurvived((Cache<Object, Object>)fcsLocalCache);
    }

    @Test
    public void testAllEmbeddedJdbcStore() {
        ConfigurationBuilder builderJdbcLocalCache = new ConfigurationBuilder();
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builderJdbcLocalCache.clustering().cacheMode(CacheMode.LOCAL).persistence().passivation(true).addStore(JdbcStringBasedStoreConfigurationBuilder.class)).purgeOnStartup(false)).preload(true)).table().dropOnExit(false)).createOnStart(true)).tableNamePrefix("ISPN_STRING_TABLE")).idColumnName("ID_COLUMN")).idColumnType("VARCHAR(255)")).dataColumnName("DATA_COLUMN")).dataColumnType("BINARY")).timestampColumnName("TIMESTAMP_COLUMN")).timestampColumnType("BIGINT")).connectionPool().connectionUrl("jdbc:h2:mem:infinispan_binary_based;DB_CLOSE_DELAY=-1").username("sa").driverClass("org.h2.Driver");
        manager.defineConfiguration("jdbc-local-cache", builderJdbcLocalCache.build());
        Cache jdbcLocalCache = manager.getCache("jdbc-local-cache");
        this.testDataSurvived((Cache<Object, Object>)jdbcLocalCache);
    }

    @Test
    public void testAllEmbeddedRocksDbStore() {
        ConfigurationBuilder builderRocksDbLocalCache = new ConfigurationBuilder();
        ((RocksDBStoreConfigurationBuilder)builderRocksDbLocalCache.clustering().cacheMode(CacheMode.LOCAL).persistence().passivation(true).addStore(RocksDBStoreConfigurationBuilder.class)).location("/tmp/rocksdb/data").expiredLocation("/tmp/rocksdb/expired").build();
        manager.defineConfiguration("rocksdb-local-cache", builderRocksDbLocalCache.build());
        Cache rocksDbLocalCache = manager.getCache("rocksdb-local-cache");
        this.testDataSurvived((Cache<Object, Object>)rocksDbLocalCache);
    }

    @Test
    public void testEmbeddedClusterExec() throws Exception {
        ClusterExecutor clusterExecutor = manager.executor();
        List<String> synchronizedList = Collections.synchronizedList(new ArrayList());
        CompletableFuture future = clusterExecutor.submitConsumer((Function)new TestCallable(), (a, v, t) -> {
            if (t != null) {
                throw new CacheException(t);
            }
            synchronizedList.add(v);
        });
        future.join();
        for (String result : synchronizedList) {
            Assert.assertEquals((Object)"OK", (Object)result);
        }
    }

    private void testDataSurvived(Cache<Object, Object> cache) {
        String key1 = "key1_" + cache.getName();
        String key2 = "key2_" + cache.getName();
        String value1 = "value1_" + cache.getName();
        String value2 = "value2_" + cache.getName();
        cache.put((Object)key1, (Object)value1);
        cache.put((Object)key2, (Object)value2);
        Assert.assertEquals((Object)value1, (Object)cache.get((Object)key1));
        Assert.assertEquals((Object)value2, (Object)cache.get((Object)key2));
        cache.stop();
        cache.start();
        Assert.assertEquals((Object)value1, (Object)cache.get((Object)key1));
        Assert.assertEquals((Object)value2, (Object)cache.get((Object)key2));
    }

    private static void killCacheManagers(boolean clear, EmbeddedCacheManager ... cacheManagers) {
        for (EmbeddedCacheManager cm : cacheManagers) {
            try {
                EmbeddedAllTest.killCaches(clear, EmbeddedAllTest.getRunningCaches(cm));
            }
            catch (Throwable e) {
                log.warn((Object)("Problems stopping cache manager " + cm), e);
            }
        }
        for (EmbeddedCacheManager cm : cacheManagers) {
            try {
                if (cm == null) continue;
                cm.stop();
            }
            catch (Throwable e) {
                log.warn((Object)("Problems killing cache manager " + cm), e);
            }
        }
    }

    private static void killCaches(boolean clear, Collection<Cache> caches) {
        for (Cache c : caches) {
            try {
                if (c == null || c.getStatus() != ComponentStatus.RUNNING) continue;
                TransactionManager tm = c.getAdvancedCache().getTransactionManager();
                if (tm != null) {
                    try {
                        tm.rollback();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (c.getAdvancedCache().getRpcManager() != null) {
                    log.tracef("Cache contents on %s before stopping: %s", (Object)c.getAdvancedCache().getRpcManager().getAddress(), (Object)c.entrySet());
                } else {
                    log.tracef("Cache contents before stopping: %s", (Object)c.entrySet());
                }
                if (clear) {
                    try {
                        c.clear();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                c.stop();
            }
            catch (Throwable t) {
                log.tracef("Problems with killing caches: %s", (Object[])t.getStackTrace());
            }
        }
    }

    private static Set<Cache> getRunningCaches(EmbeddedCacheManager cacheContainer) {
        Cache defaultCache;
        HashSet<Cache> running = new HashSet<Cache>();
        if (cacheContainer == null || !cacheContainer.getStatus().allowInvocations()) {
            return running;
        }
        for (String cacheName : cacheContainer.getCacheNames()) {
            Cache c;
            if (!cacheContainer.isRunning(cacheName) || !(c = cacheContainer.getCache(cacheName)).getStatus().allowInvocations()) continue;
            running.add(c);
        }
        if (cacheContainer.isDefaultRunning() && (defaultCache = cacheContainer.getCache()).getStatus().allowInvocations()) {
            running.add(defaultCache);
        }
        return running;
    }

    static final class TestCallable
    implements Function<EmbeddedCacheManager, String>,
    Serializable {
        TestCallable() {
        }

        @Override
        public String apply(EmbeddedCacheManager embeddedCacheManager) {
            return "OK";
        }
    }
}

