/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.all.embeddedquery;

import java.util.List;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.RangeMatchingContext;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.infinispan.Cache;
import org.infinispan.all.embeddedquery.AbstractQueryTest;
import org.infinispan.all.embeddedquery.testdomain.NumericType;
import org.infinispan.all.embeddedquery.testdomain.Person;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class QueryPhrasesTest
extends AbstractQueryTest {
    private Person person1;
    private Person person2;
    private Person person3;
    private Person person4;
    protected String key1 = "test1";
    protected String key2 = "test2";
    protected String key3 = "test3";
    private NumericType type1;
    private NumericType type2;
    private NumericType type3;

    @Before
    public void init() throws Exception {
        cache = QueryPhrasesTest.createCacheManager().getCache();
    }

    @After
    public void after() {
        cache.clear();
    }

    @Test
    public void testBooleanQueriesMustNot() {
        this.loadTestingData();
        QueryBuilder queryBuilder = new QueryBuilder(STANDARD_ANALYZER);
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().bool().must(queryBuilder.createBooleanQuery("name", "Goat")).not().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(this.person1));
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().bool().must(queryBuilder.createBooleanQuery("name", "Goat")).createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
    }

    @Test
    public void testBooleanQueriesShould() {
        this.loadTestingData();
        QueryBuilder queryBuilder = new QueryBuilder(STANDARD_ANALYZER);
        Query subQuery = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").below((Object)20).createQuery();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().bool().should(queryBuilder.createBooleanQuery("name", "Goat")).should(subQuery).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person1));
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        subQuery = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").below((Object)20).excludeLimit().createQuery();
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().bool().should(queryBuilder.createBooleanQuery("name", "Goat")).should(subQuery).createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
    }

    @Test
    public void testBooleanQueriesShouldNot() {
        this.loadTestingData();
        Query subQuery1 = ((TermMatchingContext)Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").boostedTo(0.5f)).matching((Object)"Goat").createQuery();
        Query subQuery2 = ((RangeMatchingContext)Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().range().onField("age").boostedTo(2.0f)).below((Object)20).createQuery();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().bool().should(subQuery1).should(subQuery2).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (((Person)found.get(0)).equals(this.person1));
        assert (((Person)found.get(1)).equals(this.person2));
        assert (((Person)found.get(2)).equals(this.person3));
        subQuery1 = ((TermMatchingContext)Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").boostedTo(3.5f)).matching((Object)"Goat").createQuery();
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().bool().should(subQuery1).should(subQuery2).createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (((Person)found.get(0)).equals(this.person2));
        assert (((Person)found.get(1)).equals(this.person3));
        assert (((Person)found.get(2)).equals(this.person1));
    }

    @Test
    public void testFuzzyOnFieldsAndField() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().onField("name").matching((Object)"Goat").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        this.person4 = new Person();
        this.person4.setName("Test");
        this.person4.setBlurb("Test goat");
        cache.put((Object)"testKey", (Object)this.person4);
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().onField("name").andField("blurb").matching((Object)"goat").createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().onFields(new String[]{"name", "blurb"}).matching((Object)"goat").createQuery();
        List foundOnFields = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]).list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    @Test
    public void testFuzzyWithThresholdWithPrefixLength() {
        this.person1 = new Person("yyJohn", "Eat anything", 10);
        this.person2 = new Person("yyJonn", "Eat anything", 10);
        cache.put((Object)this.key1, (Object)this.person1);
        cache.put((Object)this.key2, (Object)this.person2);
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().withEditDistanceUpTo(1).withPrefixLength(2).onField("name").matching((Object)"yyJohny").createQuery();
        List found = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]).list();
        Assert.assertEquals((long)1L, (long)found.size());
        Assert.assertTrue((boolean)found.contains(this.person1));
        Query queryReturnAll = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().fuzzy().withEditDistanceUpTo(2).withPrefixLength(2).onField("name").matching((Object)"yyJohn").createQuery();
        List foundWithLowerThreshold = Search.getSearchManager((Cache)cache).getQuery(queryReturnAll, new Class[0]).list();
        Assert.assertEquals((long)2L, (long)foundWithLowerThreshold.size());
        Assert.assertTrue((boolean)foundWithLowerThreshold.contains(this.person1));
        Assert.assertTrue((boolean)foundWithLowerThreshold.contains(this.person2));
    }

    @Test
    public void testQueryingRangeWithAnd() {
        NumericType type1 = new NumericType(10, 20);
        NumericType type2 = new NumericType(20, 10);
        NumericType type3 = new NumericType(10, 10);
        cache.put((Object)this.key1, (Object)type1);
        cache.put((Object)this.key2, (Object)type2);
        cache.put((Object)this.key3, (Object)type3);
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().range().onField("num1").andField("num2").below((Object)20).excludeLimit().createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(type1));
        assert (found.contains(type2));
        assert (found.contains(type3));
        NumericType type4 = new NumericType(11, 10);
        cache.put((Object)"newKey", (Object)type4);
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)4L, (long)found.size());
        assert (found.contains(type3));
        assert (found.contains(type2));
        assert (found.contains(type1));
        assert (found.contains(type4));
    }

    @Test(expected=SearchException.class)
    public void testWildcardWithWrongName() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().wildcard().onField("wrongname").matching((Object)"Goat").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
    }

    @Test
    public void testWildcard() {
        this.loadNumericTypes();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"*wildcard*").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.type1));
        assert (found.contains(this.type2));
        assert (found.contains(this.type3));
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"nothing*").createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)0L, (long)found.size());
        NumericType type4 = new NumericType(35, 40);
        type4.setName("nothing special.");
        cache.put((Object)"otherKey", (Object)type4);
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(type4));
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"*nothing*").createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.type2));
        assert (found.contains(type4));
    }

    @Test
    public void testKeyword() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").andField("blurb").matching((Object)"Eats").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        this.person4 = new Person();
        this.person4.setName("Some name with Eats");
        this.person4.setBlurb("Description without keyword.");
        cache.put((Object)"someKey", (Object)this.person4);
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4));
    }

    @Test
    public void testPhraseSentence() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().phrase().onField("blurb").sentence("Eats grass").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(this.person2));
        this.person4 = new Person();
        this.person4.setName("Another goat");
        this.person4.setBlurb("Eats grass and drinks water.");
        cache.put((Object)"anotherKey", (Object)this.person4);
        found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
    }

    @Test
    public void testPhraseSentenceForNonAnalyzedEntries() {
        this.loadNumericTypes();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().phrase().onField("name").sentence("Some string").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)0L, (long)found.size());
        NumericType type4 = new NumericType(45, 50);
        type4.setName("Some string");
        cache.put((Object)"otherKey", (Object)type4);
        found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(type4));
    }

    @Test
    public void testPhraseWithSlop() {
        this.loadTestingData();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().phrase().withSlop(3).onField("blurb").sentence("Eats grass").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(this.person2));
        this.person4 = new Person();
        this.person4.setName("other goat");
        this.person4.setBlurb("Eats green grass.");
        cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        this.person4.setBlurb("Eats green tasty grass.");
        cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        this.person4.setBlurb("Eats green, tasty, juicy grass.");
        cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        Assert.assertEquals((long)2L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person4));
        this.person4.setBlurb("Eats green, tasty, juicy, fresh grass.");
        cache.put((Object)"otherKey", (Object)this.person4);
        found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(this.person2));
    }

    @Test
    public void testPhraseWithSlopWithoutAnalyzer() {
        this.loadNumericTypes();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().phrase().withSlop(1).onField("name").sentence("Some string").createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)0L, (long)found.size());
        NumericType type = new NumericType(10, 60);
        type.setName("Some string");
        cache.put((Object)"otherKey", (Object)type);
        found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(type));
        NumericType type1 = new NumericType(20, 60);
        type1.setName("Some other string");
        cache.put((Object)"otherKey1", (Object)type1);
        found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(type));
    }

    @Test
    public void testAllExcept() {
        this.loadTestingData();
        Query subQuery = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().keyword().onField("name").matching((Object)"Goat").createQuery();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().all().except(new Query[0]).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person1));
        assert (found.contains(this.person3));
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().all().except(new Query[]{query}).createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)0L, (long)found.size());
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(Person.class).get().all().except(new Query[]{subQuery}).createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)1L, (long)found.size());
        assert (found.contains(this.person1));
    }

    @Test
    public void testAllExceptWithoutAnalyzer() {
        this.loadNumericTypes();
        Query subQuery = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().keyword().wildcard().onField("name").matching((Object)"*string*").createQuery();
        Query query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().all().except(new Query[0]).createQuery();
        CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        List found = cacheQuery.list();
        Assert.assertEquals((long)3L, (long)found.size());
        assert (found.contains(this.type1));
        assert (found.contains(this.type2));
        assert (found.contains(this.type3));
        query = Search.getSearchManager((Cache)cache).buildQueryBuilderForClass(NumericType.class).get().all().except(new Query[]{subQuery}).createQuery();
        cacheQuery = Search.getSearchManager((Cache)cache).getQuery(query, new Class[0]);
        found = cacheQuery.list();
        Assert.assertEquals((long)0L, (long)found.size());
    }

    private void loadTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(20);
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(30);
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(25);
        cache.put((Object)this.key1, (Object)this.person1);
        cache.put((Object)this.key2, (Object)this.person2);
        cache.put((Object)this.key3, (Object)this.person3);
    }

    private void loadNumericTypes() {
        this.type1 = new NumericType(10, 20);
        this.type1.setName("Some string for testing wildcards.");
        this.type2 = new NumericType(15, 25);
        this.type2.setName("This string has nothing to do with wildcards.");
        this.type3 = new NumericType(20, 30);
        this.type3.setName("Some other string for testing wildcards.");
        cache.put((Object)this.key1, (Object)this.type1);
        cache.put((Object)this.key2, (Object)this.type2);
        cache.put((Object)this.key3, (Object)this.type3);
    }
}

