/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.all.embeddedquery;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.QueryBuilder;
import org.hibernate.search.spi.IndexedTypeSet;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.infinispan.Cache;
import org.infinispan.all.embeddedquery.testdomain.Car;
import org.infinispan.all.embeddedquery.testdomain.NumericType;
import org.infinispan.all.embeddedquery.testdomain.Person;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.transaction.TransactionMode;
import org.junit.Assert;

public abstract class AbstractQueryTest {
    protected static Cache<Object, Object> cache;
    protected static final Analyzer STANDARD_ANALYZER;

    protected static EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcfg = new GlobalConfigurationBuilder();
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(NumericType.class).addIndexedEntity(Person.class).addIndexedEntity(Car.class).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.all.embeddedquery.testdomain.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        DefaultCacheManager cm = new DefaultCacheManager(gcfg.build(), cfg.build());
        return cm;
    }

    protected <E> CacheQuery<E> createCacheQuery(Cache m_cache, String fieldName, String searchString) {
        QueryBuilder queryBuilder = new QueryBuilder(STANDARD_ANALYZER);
        Query query = queryBuilder.createBooleanQuery(fieldName, searchString);
        SearchManager queryFactory = Search.getSearchManager((Cache)m_cache);
        return queryFactory.getQuery(query, new Class[0]);
    }

    protected void assertIndexingKnows(BasicCache<?, ?> cache, Class<?> ... types) {
        ComponentRegistry cr = ((Cache)cache).getAdvancedCache().getComponentRegistry();
        SearchIntegrator searchIntegrator = (SearchIntegrator)cr.getComponent(SearchIntegrator.class);
        Assert.assertNotNull((Object)searchIntegrator);
        IndexedTypeSet expectedTypes = IndexedTypeSets.fromClasses((Class[])types);
        IndexedTypeSet indexedTypes = searchIntegrator.getIndexBindings().keySet();
        Assert.assertEquals((Object)expectedTypes, (Object)indexedTypes);
    }

    static {
        STANDARD_ANALYZER = new StandardAnalyzer();
    }
}

