/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.all.embeddedquery;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TimeZone;
import org.infinispan.Cache;
import org.infinispan.all.embeddedquery.AbstractQueryTest;
import org.infinispan.all.embeddedquery.testdomain.Account;
import org.infinispan.all.embeddedquery.testdomain.Address;
import org.infinispan.all.embeddedquery.testdomain.ModelFactory;
import org.infinispan.all.embeddedquery.testdomain.NotIndexed;
import org.infinispan.all.embeddedquery.testdomain.Transaction;
import org.infinispan.all.embeddedquery.testdomain.User;
import org.infinispan.all.embeddedquery.testdomain.hsearch.ModelFactoryHS;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.objectfilter.ParsingException;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.Expression;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryFactory;
import org.infinispan.transaction.TransactionMode;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class QueryDslConditionsTest
extends AbstractQueryTest {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");

    private static Date makeDate(String dateStr) throws ParseException {
        DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        return DATE_FORMAT.parse(dateStr);
    }

    protected static EmbeddedCacheManager createCacheManager() {
        GlobalConfigurationBuilder gcfg = new GlobalConfigurationBuilder();
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addIndexedEntity(QueryDslConditionsTest.getModelFactory().getUserImplClass()).addIndexedEntity(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).addIndexedEntity(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.all.embeddedquery.testdomain.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        return new DefaultCacheManager(gcfg.build(), cfg.build());
    }

    private static ModelFactory getModelFactory() {
        return ModelFactoryHS.INSTANCE;
    }

    protected static QueryFactory getQueryFactory() {
        return Search.getQueryFactory((Cache)((Cache)QueryDslConditionsTest.getCacheForQuery()));
    }

    protected static BasicCache<Object, Object> getCacheForWrite() {
        return cache;
    }

    protected static BasicCache<Object, Object> getCacheForQuery() {
        return cache;
    }

    @BeforeClass
    public static void populateCache() throws Exception {
        cache = QueryDslConditionsTest.createCacheManager().getCache();
        User user1 = QueryDslConditionsTest.getModelFactory().makeUser();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAge(22);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        user1.setNotes("Lorem ipsum dolor sit amet");
        user1.setCreationDate(Instant.parse("2011-12-03T10:15:30Z"));
        user1.setPasswordExpirationDate(Instant.parse("2011-12-03T10:15:30Z"));
        Address address1 = QueryDslConditionsTest.getModelFactory().makeAddress();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        address1.setNumber(156);
        user1.setAddresses(Collections.singletonList(address1));
        User user2 = QueryDslConditionsTest.getModelFactory().makeUser();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setSalutation("Mr.");
        user2.setGender(User.Gender.MALE);
        user2.setAccountIds(Collections.singleton(3));
        user2.setCreationDate(Instant.parse("2011-12-03T10:15:30Z"));
        user2.setPasswordExpirationDate(Instant.parse("2011-12-03T10:15:30Z"));
        Address address2 = QueryDslConditionsTest.getModelFactory().makeAddress();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        address2.setNumber(-12);
        Address address3 = QueryDslConditionsTest.getModelFactory().makeAddress();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        address3.setNumber(312);
        user2.setAddresses(Arrays.asList(address2, address3));
        User user3 = QueryDslConditionsTest.getModelFactory().makeUser();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setSalutation("Ms.");
        user3.setGender(User.Gender.FEMALE);
        user3.setAccountIds(Collections.emptySet());
        user3.setCreationDate(Instant.parse("2011-12-03T10:15:30Z"));
        user3.setPasswordExpirationDate(Instant.parse("2011-12-03T10:15:30Z"));
        Account account1 = QueryDslConditionsTest.getModelFactory().makeAccount();
        account1.setId(1);
        account1.setDescription("John Doe's first bank account");
        account1.setCreationDate(QueryDslConditionsTest.makeDate("2013-01-03"));
        Account account2 = QueryDslConditionsTest.getModelFactory().makeAccount();
        account2.setId(2);
        account2.setDescription("John Doe's second bank account");
        account2.setCreationDate(QueryDslConditionsTest.makeDate("2013-01-04"));
        Account account3 = QueryDslConditionsTest.getModelFactory().makeAccount();
        account3.setId(3);
        account3.setCreationDate(QueryDslConditionsTest.makeDate("2013-01-20"));
        Transaction transaction0 = QueryDslConditionsTest.getModelFactory().makeTransaction();
        transaction0.setId(0);
        transaction0.setDescription("Birthday present");
        transaction0.setAccountId(1);
        transaction0.setAmount(1800.0);
        transaction0.setDate(QueryDslConditionsTest.makeDate("2012-09-07"));
        transaction0.setDebit(false);
        transaction0.setValid(true);
        Transaction transaction1 = QueryDslConditionsTest.getModelFactory().makeTransaction();
        transaction1.setId(1);
        transaction1.setDescription("Feb. rent payment");
        transaction1.setLongDescription("Feb. rent payment");
        transaction1.setAccountId(1);
        transaction1.setAmount(1500.0);
        transaction1.setDate(QueryDslConditionsTest.makeDate("2013-01-05"));
        transaction1.setDebit(true);
        transaction1.setValid(true);
        Transaction transaction2 = QueryDslConditionsTest.getModelFactory().makeTransaction();
        transaction2.setId(2);
        transaction2.setDescription("Starbucks");
        transaction2.setLongDescription("Starbucks");
        transaction2.setAccountId(1);
        transaction2.setAmount(23.0);
        transaction2.setDate(QueryDslConditionsTest.makeDate("2013-01-09"));
        transaction2.setDebit(true);
        transaction2.setValid(true);
        Transaction transaction3 = QueryDslConditionsTest.getModelFactory().makeTransaction();
        transaction3.setId(3);
        transaction3.setDescription("Hotel");
        transaction3.setAccountId(2);
        transaction3.setAmount(45.0);
        transaction3.setDate(QueryDslConditionsTest.makeDate("2013-02-27"));
        transaction3.setDebit(true);
        transaction3.setValid(true);
        Transaction transaction4 = QueryDslConditionsTest.getModelFactory().makeTransaction();
        transaction4.setId(4);
        transaction4.setDescription("Last january");
        transaction4.setLongDescription("Last january");
        transaction4.setAccountId(2);
        transaction4.setAmount(95.0);
        transaction4.setDate(QueryDslConditionsTest.makeDate("2013-01-31"));
        transaction4.setDebit(true);
        transaction4.setValid(true);
        Transaction transaction5 = QueryDslConditionsTest.getModelFactory().makeTransaction();
        transaction5.setId(5);
        transaction5.setDescription("-Popcorn");
        transaction5.setLongDescription("-Popcorn");
        transaction5.setAccountId(2);
        transaction5.setAmount(5.0);
        transaction5.setDate(QueryDslConditionsTest.makeDate("2013-01-01"));
        transaction5.setDebit(true);
        transaction5.setValid(true);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("user_" + user1.getId()), (Object)user1);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("user_" + user2.getId()), (Object)user2);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("user_" + user3.getId()), (Object)user3);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("account_" + account1.getId()), (Object)account1);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("account_" + account2.getId()), (Object)account2);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("account_" + account3.getId()), (Object)account3);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("transaction_" + transaction0.getId()), (Object)transaction0);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("transaction_" + transaction1.getId()), (Object)transaction1);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("transaction_" + transaction2.getId()), (Object)transaction2);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("transaction_" + transaction3.getId()), (Object)transaction3);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("transaction_" + transaction4.getId()), (Object)transaction4);
        QueryDslConditionsTest.getCacheForWrite().put((Object)("transaction_" + transaction5.getId()), (Object)transaction5);
        for (int i = 0; i < 50; ++i) {
            Transaction transaction = QueryDslConditionsTest.getModelFactory().makeTransaction();
            transaction.setId(50 + i);
            transaction.setDescription("Expensive shoes " + i);
            transaction.setLongDescription("Expensive shoes " + i);
            transaction.setAccountId(2);
            transaction.setAmount(100 + i);
            transaction.setDate(QueryDslConditionsTest.makeDate("2013-08-20"));
            transaction.setDebit(true);
            transaction.setValid(true);
            QueryDslConditionsTest.getCacheForWrite().put((Object)("transaction_" + transaction.getId()), (Object)transaction);
        }
        QueryDslConditionsTest.getCacheForWrite().put((Object)"dummy", (Object)"a primitive value cannot be queried");
        QueryDslConditionsTest.getCacheForWrite().put((Object)"notIndexed1", (Object)new NotIndexed("testing 123"));
        QueryDslConditionsTest.getCacheForWrite().put((Object)"notIndexed2", (Object)new NotIndexed("xyz"));
    }

    @Test
    public void testIndexPresence() {
        this.assertIndexingKnows(QueryDslConditionsTest.getCacheForQuery(), QueryDslConditionsTest.getModelFactory().getUserImplClass(), QueryDslConditionsTest.getModelFactory().getAccountImplClass(), QueryDslConditionsTest.getModelFactory().getTransactionImplClass());
    }

    @Test
    public void testQueryFactoryType() {
        Assert.assertEquals(EmbeddedQueryFactory.class, QueryDslConditionsTest.getQueryFactory().getClass());
    }

    @Test
    public void testEq1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    @Test
    public void testEqEmptyString() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"").build();
        List list = q.list();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testEqSentence() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).having("description").eq((Object)"John Doe's first bank account").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
    }

    @Test
    public void testEq() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"Jacob").build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testEqNonIndexedType() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(NotIndexed.class).having("notIndexedField").eq((Object)"testing 123").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"testing 123", (Object)((NotIndexed)list.get((int)0)).notIndexedField);
    }

    @Test
    public void testEqNonIndexedField() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testEqHybridQuery() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet")).and().having("surname").eq((Object)"Doe").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testEqHybridQueryWithParam() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("notes").eq((Object)"Lorem ipsum dolor sit amet")).and().having("surname").eq((Object)Expression.param((String)"surnameParam")).build();
        q.setParameter("surnameParam", (Object)"Doe");
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testEqHybridQueryWithPredicateOptimisation() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("notes").like("%ipsum%").and((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or().having("name").eq((Object)"Jane")).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Lorem ipsum dolor sit amet", (Object)((User)list.get(0)).getNotes());
    }

    @Test
    public void testEqInNested1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("addresses.postCode").eq((Object)"X1234").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"X1234", (Object)((User)list.get(0)).getAddresses().get(0).getPostCode());
    }

    @Test
    public void testEqInNested2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("addresses.postCode").eq((Object)"Y12").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getAddresses().size());
    }

    @Test
    public void testLike() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("description").like("%rent%").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getAccountId());
        Assert.assertEquals((double)1500.0, (double)((Transaction)list.get(0)).getAmount(), (double)0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBetweenArgsAreComparable() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("date").between(new Object(), new Object()).build();
    }

    @Test
    public void testBetween1() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("date").between((Object)QueryDslConditionsTest.makeDate("2013-01-01"), (Object)QueryDslConditionsTest.makeDate("2013-01-31")).build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBetween2() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("date").between((Object)QueryDslConditionsTest.makeDate("2013-01-01"), (Object)QueryDslConditionsTest.makeDate("2013-01-31")).includeUpper(false).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-31")) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBetween3() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("date").between((Object)QueryDslConditionsTest.makeDate("2013-01-01"), (Object)QueryDslConditionsTest.makeDate("2013-01-31")).includeLower(false).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-01")) > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testGt() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("amount").gt((Object)1500).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((((Transaction)list.get(0)).getAmount() > 1500.0 ? 1 : 0) != 0);
    }

    @Test
    public void testGte() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("amount").gte((Object)1500).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() >= 1500.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLt() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("amount").lt((Object)1500).build();
        List list = q.list();
        Assert.assertEquals((long)54L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() < 1500.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLte() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("amount").lte((Object)1500).build();
        List list = q.list();
        Assert.assertEquals((long)55L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() <= 1500.0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLteOnFieldWithNullToken() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("description").lte((Object)"-Popcorn").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"-Popcorn", (Object)((Transaction)list.get(0)).getDescription());
    }

    @Test
    public void testAnd1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider")).and().having("surname").eq((Object)"Man").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testAnd2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider")).and((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testAnd3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE)).and().having("gender").eq((Object)User.Gender.FEMALE).build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testAnd4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"Spider")).or((FilterConditionContext)qf.having("name").eq((Object)"John")).and((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testOr1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man")).or().having("surname").eq((Object)"Woman").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertEquals((Object)"Spider", (Object)u.getName());
        }
    }

    @Test
    public void testOr2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man")).or((FilterConditionContext)qf.having("surname").eq((Object)"Woman")).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertEquals((Object)"Spider", (Object)u.getName());
        }
    }

    @Test
    public void testOr3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE)).or().having("gender").eq((Object)User.Gender.FEMALE).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testOr4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)((FilterConditionContext)((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("surname", SortOrder.DESC).having("gender").eq((Object)User.Gender.MALE)).or().having("name").eq((Object)"Spider")).and().having("gender").eq((Object)User.Gender.FEMALE)).or().having("surname").like("%oe%").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(1)).getSurname());
    }

    @Test
    public void testOr5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)((FilterConditionContext)((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.MALE)).or().having("name").eq((Object)"Spider")).or().having("gender").eq((Object)User.Gender.FEMALE)).and().having("surname").like("%oe%").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    @Test
    public void testNot1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"Spider").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    @Test
    public void testNot2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().not().having("surname").eq((Object)"Doe").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    @Test
    public void testNot3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"John")).and().having("surname").eq((Object)"Man").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
    }

    @Test
    public void testNot4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("surname").eq((Object)"Man")).and().not().having("name").eq((Object)"John").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
    }

    @Test
    public void testNot5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"Spider")).or().having("surname").eq((Object)"Man").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertNotEquals((Object)"Woman", (Object)u.getSurname());
        }
    }

    @Test
    public void testNot6() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not(qf.not((FilterConditionContext)qf.having("gender").eq((Object)User.Gender.FEMALE))).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
    }

    @Test
    public void testNot7() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender").eq((Object)User.Gender.FEMALE)).and().not((FilterConditionContext)qf.having("name").eq((Object)"Spider")).build();
        List list = q.list();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test
    public void testNot8() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or((FilterConditionContext)qf.having("surname").eq((Object)"Man"))).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
    }

    @Test
    public void testNot9() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).and((FilterConditionContext)qf.having("surname").eq((Object)"Doe"))).orderBy("id", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Man", (Object)((User)list.get(0)).getSurname());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(1)).getSurname());
    }

    @Test
    public void testNot10() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or((FilterConditionContext)qf.having("surname").eq((Object)"Man"))).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertNotEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
    }

    @Test
    public void testNot11() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not(qf.not((FilterConditionContext)((FilterConditionContext)qf.having("name").eq((Object)"John")).or((FilterConditionContext)qf.having("surname").eq((Object)"Man")))).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertNotEquals((Object)"Woman", (Object)((User)list.get(0)).getSurname());
    }

    @Test
    public void testEmptyQuery() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testTautology() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").gt((Object)"A").or().having("name").lte((Object)"A").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testContradiction() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").gt((Object)"A").and().having("name").lte((Object)"A").build();
        List list = q.list();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    @Test(expected=ParsingException.class)
    public void testInvalidEmbeddedAttributeQuery() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        QueryBuilder queryBuilder = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"addresses"});
        Query q = queryBuilder.build();
        q.list();
    }

    @Test(expected=ParsingException.class)
    public void testRejectProjectionOfRepeatedProperty() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"addresses.postCode"}).build();
        q.list();
    }

    @Test
    public void testIsNull1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("surname").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testIsNull2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("surname").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testIsNull3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("addresses").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testIsNullNumericWithProjection1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"name", "surname", "age"}).orderBy("name", SortOrder.ASC).orderBy("surname", SortOrder.ASC).orderBy("age", SortOrder.ASC).having("age").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Man", (Object)((Object[])list.get(0))[1]);
        Assert.assertNull((Object)((Object[])list.get(0))[2]);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"Woman", (Object)((Object[])list.get(1))[1]);
        Assert.assertNull((Object)((Object[])list.get(1))[2]);
    }

    @Test
    public void testIsNullNumericWithProjection2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"name", "age"}).not().having("age").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)22, (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testContains1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)2).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testContains2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)42).build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testContainsAll1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{1, 2}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testContainsAll2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAll(Collections.singleton(1)).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testContainsAll3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{1, 2, 3}).build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testContainsAll4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAll(Collections.emptySet()).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testContainsAny1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).having("accountIds").containsAny(new Object[]{2, 3}).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((User)list.get(1)).getId());
    }

    @Test
    public void testContainsAny2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAny(new Object[]{4, 5}).build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testContainsAny3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAny(Collections.emptySet()).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testIn1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        List<Integer> ids = Arrays.asList(1, 3);
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("id").in(ids).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertTrue((boolean)ids.contains(u.getId()));
        }
    }

    @Test
    public void testIn2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("id").in(new Object[]{4}).build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIn3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("id").in(Collections.emptySet());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIn4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("id").in((Collection)null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIn5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("id").in((Object[])null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIn6() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Object[] array = new Object[]{};
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("id").in(array);
    }

    @Test
    public void testSampleDomainQuery1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).having("gender").eq((Object)User.Gender.MALE).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    @Test
    public void testSampleDomainQuery2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).not((FilterConditionContext)qf.having("gender").eq((Object)User.Gender.FEMALE)).and((FilterConditionContext)qf.not().not((FilterConditionContext)qf.having("gender").eq((Object)User.Gender.MALE))).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    @Test
    public void testStringLiteralEscape() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).having("description").eq((Object)"John Doe's first bank account").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
    }

    @Test
    public void testSortByDate() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).orderBy("creationDate", SortOrder.DESC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Account)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Account)list.get(1)).getId());
        Assert.assertEquals((long)1L, (long)((Account)list.get(2)).getId());
    }

    @Test
    public void testSampleDomainQuery3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.ASC).having("gender").eq((Object)User.Gender.MALE).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    @Test
    public void testSampleDomainQuery4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(2)).getName());
    }

    @Test
    public void testSampleDomainQuery4With2SortingOptions() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).orderBy("surname", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(2)).getName());
        Assert.assertEquals((Object)"Man", (Object)((User)list.get(0)).getSurname());
        Assert.assertEquals((Object)"Woman", (Object)((User)list.get(1)).getSurname());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(2)).getSurname());
    }

    @Test
    public void testSampleDomainQuery5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("name", SortOrder.DESC).select(new String[]{"name"}).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(2))[0]);
    }

    @Test
    public void testSampleDomainQuery6() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"John")).and().having("surname").eq((Object)"Doe").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    @Test
    public void testSampleDomainQuery7() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)1)).and().having("description").like("%rent%").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getId());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getAccountId());
        Assert.assertTrue((boolean)((Transaction)list.get(0)).getDescription().contains("rent"));
    }

    @Test
    public void testSampleDomainQuery8() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("date").between((Object)QueryDslConditionsTest.makeDate("2013-01-01"), (Object)QueryDslConditionsTest.makeDate("2013-01-31")).build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(QueryDslConditionsTest.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSampleDomainQuery9() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)QueryDslConditionsTest.makeDate("2013-01-01"), (Object)QueryDslConditionsTest.makeDate("2013-01-31")).build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(3)).length);
        for (int i = 0; i < 4; ++i) {
            Date d = (Date)((Object[])list.get(i))[0];
            Assert.assertTrue((d.compareTo(QueryDslConditionsTest.makeDate("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((d.compareTo(QueryDslConditionsTest.makeDate("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSampleDomainQuery10() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)2)).and().having("amount").gt((Object)40).build();
        List list = q.list();
        Assert.assertEquals((long)52L, (long)list.size());
        Assert.assertTrue((((Transaction)list.get(0)).getAmount() > 40.0 ? 1 : 0) != 0);
        Assert.assertTrue((((Transaction)list.get(1)).getAmount() > 40.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSampleDomainQuery11() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"John")).and().having("addresses.postCode").eq((Object)"X1234")).and((FilterConditionContext)qf.having("accountIds").eq((Object)1)).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    @Test
    public void testSampleDomainQuery12() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).having("accountId").eq((Object)1)).and().not().having("isDebit").eq((Object)true).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertFalse((boolean)((Transaction)list.get(0)).isDebit());
    }

    @Test
    public void testSampleDomainQuery13() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").contains((Object)3).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(3));
    }

    @Test
    public void testSampleDomainQuery14() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAll(new Object[]{2, 1}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(1));
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(2));
    }

    @Test
    public void testSampleDomainQuery15() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("accountIds").containsAny(new Object[]{1, 3}).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    @Test
    public void testSampleDomainQuery16() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)((QueryBuilder)((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).startOffset(20L)).maxResults(10)).orderBy("id", SortOrder.ASC).having("accountId").eq((Object)2)).and().having("description").like("Expensive%").build();
        List list = q.list();
        Assert.assertEquals((long)50L, (long)q.getResultSize());
        Assert.assertEquals((long)10L, (long)list.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("Expensive shoes " + (20 + i)), (Object)((Transaction)list.get(i)).getDescription());
        }
    }

    @Test
    public void testSampleDomainQuery17() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q1 = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("id").eq((Object)1).build();
        List users = q1.list();
        Query q2 = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).orderBy("description", SortOrder.ASC).having("id").in(((User)users.get(0)).getAccountIds()).build();
        List list = q2.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John Doe's first bank account", (Object)((Account)list.get(0)).getDescription());
        Assert.assertEquals((Object)"John Doe's second bank account", (Object)((Account)list.get(1)).getDescription());
    }

    @Test
    public void testSampleDomainQuery18() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).orderBy("description", SortOrder.ASC).having("accountId").eq((Object)1)).and((FilterConditionContext)qf.having("amount").gt((Object)1600).or().having("description").like("%rent%")).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Birthday present", (Object)((Transaction)list.get(0)).getDescription());
        Assert.assertEquals((Object)"Feb. rent payment", (Object)((Transaction)list.get(1)).getDescription());
    }

    @Test
    public void testProjectionOnOptionalField() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"id", "age"}).orderBy("id", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)1, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(2))[0]);
        Assert.assertEquals((Object)22, (Object)((Object[])list.get(0))[1]);
        Assert.assertNull((Object)((Object[])list.get(1))[1]);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testNullOnIntegerField() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("age").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertNull((Object)((User)list.get(0)).getAge());
        Assert.assertNull((Object)((User)list.get(1)).getAge());
    }

    @Test
    public void testIsNotNullOnIntegerField() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("age").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
        Assert.assertNotNull((Object)((User)list.get(0)).getAge());
    }

    @Test
    public void testSampleDomainQuery19() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("addresses.postCode").in(new Object[]{"ZZ", "X1234"}).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    @Test
    public void testSampleDomainQuery20() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("addresses.postCode").in(new Object[]{"X1234"}).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    @Test
    public void testSampleDomainQuery21() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("addresses").isNull().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    @Test
    public void testSampleDomainQuery22() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("addresses.postCode").like("%123%").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    @Test
    public void testSampleDomainQuery23() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((User)list.get(0)).getId());
    }

    @Test
    public void testSampleDomainQuery24() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).includeLower(false).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(1)).getId()));
    }

    @Test
    public void testSampleDomainQuery25() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("id").between((Object)1, (Object)2).includeUpper(false).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    @Test
    public void testSampleDomainQuery26() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).having("creationDate").eq((Object)QueryDslConditionsTest.makeDate("2013-01-20")).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Account)list.get(0)).getId());
    }

    @Test
    public void testSampleDomainQuery27() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).orderBy("id", SortOrder.ASC).having("creationDate").lt((Object)QueryDslConditionsTest.makeDate("2013-01-20")).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Account)list.get(1)).getId());
    }

    @Test
    public void testSampleDomainQuery28() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).orderBy("id", SortOrder.ASC).having("creationDate").lte((Object)QueryDslConditionsTest.makeDate("2013-01-20")).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((Account)list.get(1)).getId());
        Assert.assertEquals((long)3L, (long)((Account)list.get(2)).getId());
    }

    @Test
    public void testSampleDomainQuery29() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).having("creationDate").gt((Object)QueryDslConditionsTest.makeDate("2013-01-04")).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Account)list.get(0)).getId());
    }

    @Test(expected=IllegalStateException.class)
    public void testWrongQueryBuilding1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.not().having("name").eq((Object)"John").build();
    }

    @Test(expected=IllegalStateException.class)
    public void testWrongQueryBuilding2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").having("surname").eq((Object)"Man").build();
    }

    @Test(expected=IllegalStateException.class)
    public void testWrongQueryBuilding3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not().having("name").eq((Object)"John").not().having("surname").eq((Object)"Man").build();
    }

    @Test(expected=IllegalStateException.class)
    public void testWrongQueryBuilding4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not((FilterConditionContext)qf.having("name").eq((Object)"John")).not((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
    }

    @Test(expected=IllegalStateException.class)
    public void testWrongQueryBuilding5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).not((FilterConditionContext)qf.having("name").eq((Object)"John")).not((FilterConditionContext)qf.having("surname").eq((Object)"Man")).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testWrongQueryBuilding6() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender").eq(null).build();
    }

    @Test(expected=IllegalStateException.class)
    public void testWrongQueryBuilding7() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        FilterConditionEndContext q1 = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender");
        q1.eq((Object)User.Gender.MALE);
        q1.eq((Object)User.Gender.FEMALE);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPagination1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).maxResults(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPagination2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).maxResults(-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPagination3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).startOffset(-3L);
    }

    @Test
    public void testOrderedPagination4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).maxResults(5)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testUnorderedPagination4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).maxResults(5)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testOrderedPagination5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(20L)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testUnorderedPagination5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).startOffset(20L)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testOrderedPagination6() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(20L)).maxResults(10)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testUnorderedPagination6() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).startOffset(20L)).maxResults(10)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testOrderedPagination7() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(1L)).maxResults(10)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testUnorderedPagination7() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).startOffset(1L)).maxResults(10)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testOrderedPagination8() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).orderBy("id", SortOrder.ASC).startOffset(0L)).maxResults(2)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testUnorderedPagination8() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((QueryBuilder)((QueryBuilder)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).startOffset(0L)).maxResults(2)).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)q.getResultSize());
        Assert.assertEquals((long)2L, (long)list.size());
    }

    @Test
    public void testGroupBy1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"name"}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
    }

    @Test
    public void testGroupBy2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertNull((Object)((Object[])list.get(1))[0]);
    }

    @Test(expected=ParsingException.class)
    public void testGroupBy3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"name"}).groupBy(new String[]{"name"}).orderBy("surname").build();
        q.list();
    }

    @Test
    public void testGroupBy4() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"addresses.postCode")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"ZZ", (Object)((Object[])list.get(1))[0]);
    }

    @Test(expected=ParsingException.class)
    public void testGroupBy5() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).groupBy(new String[]{"name"}).build();
        q.list();
    }

    @Test(expected=IllegalStateException.class)
    public void testGroupBy6() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"name")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
    }

    @Test(expected=ParsingException.class)
    public void testGroupBy7() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).having(Expression.sum((String)"age")).gt((Object)10).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)3L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((double)1500.0, (double)((Double)((Object[])list.get(0))[2]), (double)1.0E-4);
        Assert.assertEquals((double)45.0, (double)((Double)((Object[])list.get(1))[2]), (double)1.0E-4);
    }

    @Test
    public void testHavingWithSum() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.sum((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.sum((String)"amount")).gt((Object)3324).orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)6370.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    @Test
    public void testHavingWithAvg() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.avg((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.avg((String)"amount")).lt((Object)130.0).orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)120.188679, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    @Test
    public void testHavingWithMin() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.min((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.min((String)"amount")).lt((Object)10).orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)5.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    @Test
    public void testHavingWithMax() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.max((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.avg((String)"amount")).lt((Object)150).orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((double)149.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
    }

    @Test
    public void testSum() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertNull((Object)((Object[])list.get(1))[0]);
    }

    @Test
    public void testEmbeddedSum() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.sum((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)156L, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)300L, (Object)((Object[])list.get(1))[1]);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testGlobalSum() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.sum((String)"amount")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((double)9693.0, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
    }

    @Test
    public void testEmbeddedGlobalSum() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"addresses.number")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)456L, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testCount() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.count((String)"age")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)0L, (Object)((Object[])list.get(1))[1]);
        Assert.assertEquals((Object)0L, (Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testEmbeddedCount1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.count((String)"accountIds")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)2L, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(1))[1]);
        Assert.assertEquals((Object)0L, (Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testEmbeddedCount2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.count((String)"addresses.street")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)2L, (Object)((Object[])list.get(1))[1]);
        Assert.assertEquals((Object)0L, (Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testGlobalCount() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).select(new Expression[]{Expression.count((String)"creationDate")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)3L, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testEmbeddedGlobalCount() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"accountIds")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)3L, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testAvg() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.avg((String)"amount")}).groupBy(new String[]{"accountId"}).orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((double)1107.6666, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
        Assert.assertEquals((double)120.18867, (double)((Double)((Object[])list.get(1))[1]), (double)1.0E-4);
    }

    @Test
    public void testEmbeddedAvg() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.avg((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((double)156.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
        Assert.assertEquals((double)150.0, (double)((Double)((Object[])list.get(1))[1]), (double)1.0E-4);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testGlobalAvg() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.avg((String)"amount")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((double)173.0892, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
    }

    @Test
    public void testEmbeddedGlobalAvg() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"addresses.number")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((double)152.0, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
    }

    @Test
    public void testMin() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.min((String)"amount")}).groupBy(new String[]{"accountId"}).orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)23.0, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)5.0, (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testMinString() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"surname")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Doe", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Man", (Object)((Object[])list.get(1))[0]);
    }

    @Test
    public void testEmbeddedMin() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.min((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)156, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)-12, (Object)((Object[])list.get(1))[1]);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testGlobalMinDouble() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.min((String)"amount")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)5.0, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testGlobalMinString() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"name")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testEmbeddedGlobalMin() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"addresses.number")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)-12, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testMax() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.max((String)"amount")}).groupBy(new String[]{"accountId"}).orderBy("accountId").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)1800.0, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)149.0, (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testMaxString() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"surname")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Doe", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Woman", (Object)((Object[])list.get(1))[0]);
    }

    @Test
    public void testEmbeddedMax() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"surname"), Expression.max((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)156, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)312, (Object)((Object[])list.get(1))[1]);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testEmbeddedMaxString() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"addresses.postCode")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"ZZ", (Object)((Object[])list.get(1))[0]);
    }

    @Test
    public void testGlobalMaxDouble() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.max((String)"amount")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1800.0, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testGlobalMaxString() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"name")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testEmbeddedGlobalMax() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.max((String)"addresses.number")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)312, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testOrderBySum() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).orderBy(Expression.sum((String)"age")).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22L, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testGroupingWithFilter() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"name"}).having("name").eq((Object)"John").groupBy(new String[]{"name"}).having("name").eq((Object)"John").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testCountNull() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"age")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testCountNull2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"name"), Expression.count((String)"age")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)0L, (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testCountNull3() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.property((String)"name"), Expression.count((String)"salutation")}).groupBy(new String[]{"name"}).orderBy("name").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)0L, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)2L, (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testAvgNull() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"age")}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)22.0, (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testDateGrouping1() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)QueryDslConditionsTest.makeDate("2013-02-15"), (Object)QueryDslConditionsTest.makeDate("2013-03-15")).groupBy(new String[]{"date"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testDateGrouping2() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.count((String)"date"), Expression.min((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testDateGrouping3() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.min((String)"date"), Expression.count((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testParam() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender").eq((Object)Expression.param((String)"param2")).build();
        q.setParameter("param2", (Object)User.Gender.MALE);
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
        Assert.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(1)).getGender()));
        q.setParameter("param2", (Object)User.Gender.FEMALE);
        list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)((Object)User.Gender.FEMALE), (Object)((Object)((User)list.get(0)).getGender()));
    }

    @Test
    public void testWithParameterMap() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("gender").eq((Object)Expression.param((String)"param1"))).and().having("name").eq((Object)Expression.param((String)"param2")).build();
        HashMap<String, Object> parameterMap = new HashMap<String, Object>(2);
        parameterMap.put("param1", (Object)User.Gender.MALE);
        parameterMap.put("param2", "John");
        q.setParameters(parameterMap);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        parameterMap = new HashMap(2);
        parameterMap.put("param1", (Object)User.Gender.MALE);
        parameterMap.put("param2", "Spider");
        q.setParameters(parameterMap);
        list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)((Object)User.Gender.MALE), (Object)((Object)((User)list.get(0)).getGender()));
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
    }

    @Test
    public void testDateParam() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = (Query)qf.from(QueryDslConditionsTest.getModelFactory().getAccountImplClass()).having("creationDate").eq((Object)Expression.param((String)"param1")).build().setParameter("param1", (Object)QueryDslConditionsTest.makeDate("2013-01-03"));
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Account)list.get(0)).getId());
    }

    @Test
    public void testParamWithGroupBy() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.property((String)"accountId"), Expression.property((String)"date"), Expression.sum((String)"amount")}).groupBy(new String[]{"accountId", "date"}).having(Expression.sum((String)"amount")).gt((Object)Expression.param((String)"param")).build();
        q.setParameter("param", (Object)1801);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)6225.0, (Object)((Object[])list.get(0))[2]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnknownParam() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1")).build();
        q.setParameter("param2", (Object)"John");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnknownParamWithParameterMap() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1")).build();
        HashMap<String, User.Gender> parameterMap = new HashMap<String, User.Gender>(1);
        parameterMap.put("param2", User.Gender.MALE);
        q.setParameters(parameterMap);
    }

    @Test(expected=IllegalStateException.class)
    public void testQueryWithNoParams() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build().setParameter("param1", (Object)"John");
    }

    @Test(expected=IllegalStateException.class)
    public void testQueryWithNoParamsWithParameterMap() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build();
        HashMap<String, User.Gender> parameterMap = new HashMap<String, User.Gender>(1);
        parameterMap.put("param1", User.Gender.MALE);
        q.setParameters(parameterMap);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullParamName() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param(null)).build();
        q.setParameter(null, (Object)"John");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyParamName() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"")).build();
        q.setParameter("", (Object)"John");
    }

    @Test(expected=IllegalStateException.class)
    public void testMissingParam() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1"))).and().having("gender").eq((Object)Expression.param((String)"param2")).build();
        q.setParameter("param1", (Object)"John");
        q.list();
    }

    @Test(expected=IllegalStateException.class)
    public void testMissingParamWithParameterMap() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = ((FilterConditionContext)qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)Expression.param((String)"param1"))).and().having("gender").eq((Object)Expression.param((String)"param2")).build();
        HashMap<String, String> parameterMap = new HashMap<String, String>(1);
        parameterMap.put("param1", "John");
        q.setParameters(parameterMap);
        q.list();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testQueryWithNoParamsWithNullParameterMap() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").eq((Object)"John").build();
        q.setParameters(null);
    }

    @Test
    public void testComplexQuery() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.avg((String)"amount"), Expression.sum((String)"amount"), Expression.count((String)"date"), Expression.min((String)"date"), Expression.max((String)"accountId")}).having("isDebit").eq((Object)Expression.param((String)"param")).orderBy(Expression.avg((String)"amount"), SortOrder.DESC).orderBy(Expression.count((String)"date"), SortOrder.DESC).orderBy(Expression.max((String)"amount"), SortOrder.ASC).build();
        q.setParameter("param", (Object)true);
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)5L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((double)143.50909, (double)((Double)((Object[])list.get(0))[0]), (double)1.0E-4);
        Assert.assertEquals((double)7893.0, (double)((Double)((Object[])list.get(0))[1]), (double)1.0E-4);
        Assert.assertEquals((Object)55L, (Object)((Object[])list.get(0))[2]);
        Assert.assertEquals(Date.class, ((Object[])list.get(0))[3].getClass());
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-01-01"), (Object)((Object[])list.get(0))[3]);
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(0))[4]);
    }

    @Test
    public void testDateFilteringWithGroupBy() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"date"}).having("date").between((Object)QueryDslConditionsTest.makeDate("2013-02-15"), (Object)QueryDslConditionsTest.makeDate("2013-03-15")).groupBy(new String[]{"date"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals(Date.class, ((Object[])list.get(0))[0].getClass());
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testAggregateDate() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.count((String)"date"), Expression.min((String)"date")}).having("description").eq((Object)"Hotel").groupBy(new String[]{"id"}).build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals(Date.class, ((Object[])list.get(0))[1].getClass());
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
    }

    @Test
    public void testNotIndexedProjection() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isValid"}).having("id").gte((Object)98).orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testNotStoredProjection() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "description"}).having("id").gte((Object)98).orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Expensive shoes 48", (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"Expensive shoes 49", (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testNotIndexedOrderBy() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isValid"}).having("id").gte((Object)98).orderBy("isValid").orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testNotStoredOrderBy() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "description"}).having("id").gte((Object)98).orderBy("description").orderBy("id").build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)98, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Expensive shoes 48", (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((long)2L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((Object)99, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"Expensive shoes 49", (Object)((Object[])list.get(1))[1]);
    }

    @Test
    public void testDuplicateDateProjection() throws Exception {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "date", "date"}).having("description").eq((Object)"Hotel").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)QueryDslConditionsTest.makeDate("2013-02-27"), (Object)((Object[])list.get(0))[2]);
    }

    @Test
    public void testDuplicateBooleanProjection() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new String[]{"id", "isDebit", "isDebit"}).having("description").eq((Object)"Hotel").build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)true, (Object)((Object[])list.get(0))[2]);
    }

    @Test(expected=ParsingException.class)
    public void testGroupByMustNotAcceptRepeatedProperty() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"name")}).groupBy(new String[]{"addresses.street"}).build();
        q.list();
    }

    @Test(expected=ParsingException.class)
    public void testOrderByMustNotAcceptRepeatedProperty() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"name"}).orderBy("addresses.street").build();
        q.list();
    }

    @Test
    public void testOrderByInAggregationQueryMustAcceptRepeatedProperty() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.avg((String)"age"), Expression.property((String)"name")}).having("name").gt((Object)"A").groupBy(new String[]{"name"}).having(Expression.max((String)"addresses.street")).gt((Object)"A").orderBy(Expression.min((String)"addresses.street")).build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertNull((Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)22.0, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(1))[1]);
    }

    @Test(expected=ParsingException.class)
    public void testRejectAggregationsInWhereClause() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new String[]{"name"}).having("name").eq((Object)Expression.min((String)"addresses.street")).build();
        q.list();
    }

    @Test
    public void testAggregateRepeatedField() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.min((String)"addresses.street")}).having("name").eq((Object)"Spider").build();
        List list = q.list();
        Assert.assertEquals((Object)"Bond Street", (Object)((Object[])list.get(0))[0]);
    }

    @Test
    public void testGroupingAndAggregationOnSameField() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"surname")}).groupBy(new String[]{"surname"}).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(2))[0]);
    }

    @Test
    public void testTwoPhaseGroupingAndAggregationOnSameField() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.count((String)"surname"), Expression.sum((String)"addresses.number")}).groupBy(new String[]{"surname"}).orderBy("surname").build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)156L, (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)300L, (Object)((Object[])list.get(1))[1]);
        Assert.assertEquals((Object)1L, (Object)((Object[])list.get(2))[0]);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    @Test
    public void testLuceneWildcardsAreEscaped() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q1 = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").like("J%n").build();
        Assert.assertEquals((long)1L, (long)q1.list().size());
        Query q2 = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").like("J*n").build();
        Assert.assertEquals((long)0L, (long)q2.list().size());
        Query q3 = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").like("Jo_n").build();
        Assert.assertEquals((long)1L, (long)q3.list().size());
        Query q4 = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("name").like("Jo?n").build();
        Assert.assertEquals((long)0L, (long)q4.list().size());
    }

    @Test
    public void testCompareLongWithInt() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).select(new Expression[]{Expression.sum((String)"age")}).groupBy(new String[]{"name"}).having(Expression.sum((String)"age")).gt((Object)50000).build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testCompareDoubleWithInt() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getTransactionImplClass()).select(new Expression[]{Expression.sum((String)"amount")}).groupBy(new String[]{"accountId"}).having(Expression.sum((String)"amount")).gt((Object)50000).build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testFullTextTerm() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.create("from " + QueryDslConditionsTest.getModelFactory().getTransactionTypeName() + " where longDescription:'rent'");
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testFullTextPhrase() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.create("from " + QueryDslConditionsTest.getModelFactory().getTransactionTypeName() + " where longDescription:'expensive shoes'");
        List list = q.list();
        Assert.assertEquals((long)50L, (long)list.size());
    }

    @Test
    public void testInstant1() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("creationDate").eq((Object)Instant.parse("2011-12-03T10:15:30Z")).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    @Test
    public void testInstant2() {
        QueryFactory qf = QueryDslConditionsTest.getQueryFactory();
        Query q = qf.from(QueryDslConditionsTest.getModelFactory().getUserImplClass()).having("passwordExpirationDate").eq((Object)Instant.parse("2011-12-03T10:15:30Z")).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }
}

