/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.all.embeddedquery;

import org.infinispan.all.embeddedquery.LocalCacheTest;
import org.infinispan.all.embeddedquery.testdomain.Person;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.TransactionMode;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class IndexedEntityAutodetectTest
extends LocalCacheTest {
    protected static EmbeddedCacheManager createCacheManager() throws Exception {
        GlobalConfigurationBuilder gcfg = new GlobalConfigurationBuilder();
        ConfigurationBuilder cfg = new ConfigurationBuilder();
        cfg.transaction().transactionMode(TransactionMode.TRANSACTIONAL).indexing().index(Index.ALL).addProperty("default.directory_provider", "local-heap").addProperty("error_handler", "org.infinispan.all.embeddedquery.testdomain.StaticTestingErrorHandler").addProperty("lucene_version", "LUCENE_CURRENT");
        DefaultCacheManager cm = new DefaultCacheManager(gcfg.build(), cfg.build());
        return cm;
    }

    @Override
    @Before
    public void init() throws Exception {
        this.cacheManager = IndexedEntityAutodetectTest.createCacheManager();
        this.cache = this.cacheManager.getCache();
    }

    @After
    public void tearDown() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    @Override
    protected void loadTestingData() {
        this.assertIndexingKnows((BasicCache<?, ?>)this.cache, new Class[0]);
        super.loadTestingData();
        this.assertIndexingKnows((BasicCache<?, ?>)this.cache, Person.class);
    }

    @Test
    public void testEntityDiscovery() {
        this.assertIndexingKnows((BasicCache<?, ?>)this.cache, new Class[0]);
        Person p = new Person();
        p.setName("Lucene developer");
        p.setAge(30);
        p.setBlurb("works best on weekends");
        this.cache.put((Object)p.getName(), (Object)p);
        this.assertIndexingKnows((BasicCache<?, ?>)this.cache, Person.class);
    }
}

