/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.all.embeddedquery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.filter.FullTextFilter;
import org.infinispan.Cache;
import org.infinispan.all.embeddedquery.AbstractQueryTest;
import org.infinispan.all.embeddedquery.testdomain.Person;
import org.infinispan.all.embeddedquery.testdomain.StaticTestingErrorHandler;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LocalCacheTest
extends AbstractQueryTest {
    protected EmbeddedCacheManager cacheManager;
    protected Cache<Object, Object> cache;
    private Person person1;
    private Person person2;
    private Person person3;
    private Person person4;
    private String key1 = "Navin";
    private String key2 = "BigGoat";
    private String key3 = "MiniGoat";

    @Before
    public void init() throws Exception {
        this.cacheManager = LocalCacheTest.createCacheManager();
        this.cache = this.cacheManager.getCache();
    }

    @After
    public void after() {
        if (this.cacheManager != null) {
            this.cacheManager.stop();
        }
    }

    @Test
    public void testSimple() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        List found = cacheQuery.list();
        this.assertPeopleInList(found, this.person1);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testSimpleForNonField() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "nonIndexedField", "test1");
        List found = cacheQuery.list();
        int elems = found.size();
        Assert.assertEquals((String)("Expected 0 but was " + elems), (long)0L, (long)elems);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testEagerIterator() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            Assert.assertTrue((boolean)found.hasNext());
            found.next();
            Assert.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testEagerIteratorRemove() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            Assert.assertTrue((boolean)found.hasNext());
            found.remove();
        }
    }

    @Test(expected=NoSuchElementException.class)
    public void testEagerIteratorExCase() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            Assert.assertTrue((boolean)found.hasNext());
            found.next();
            Assert.assertFalse((boolean)found.hasNext());
            found.next();
        }
    }

    @Test
    public void testModified() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        List found = cacheQuery.list();
        this.assertPeopleInList(found, this.person1);
        this.person1.setBlurb("Likes pizza");
        this.cache.put((Object)this.key1, (Object)this.person1);
        cacheQuery = this.createCacheQuery(this.cache, "blurb", "pizza");
        found = cacheQuery.list();
        this.assertPeopleInList(found, this.person1);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testAdded() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        List found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2, this.person3);
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache.put((Object)"mighty", (Object)this.person4);
        cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2, this.person3, this.person4);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testRemoved() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        List found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2, this.person3);
        this.cache.remove((Object)this.key3);
        cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testUpdated() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        List found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2, this.person3);
        this.cache.put((Object)this.key2, (Object)this.person1);
        cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        found = cacheQuery.list();
        this.assertPeopleInList(found, this.person3);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testSetSort() {
        this.loadTestingData();
        Sort sort = new Sort(new SortField("age", SortField.Type.STRING));
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        List found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2, this.person3);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        this.assertPeopleInSortedList(found, this.person3, this.person2);
        StaticTestingErrorHandler.assertAllGood(this.cache);
        this.person2.setAge(10);
        this.cache.put((Object)this.key2, (Object)this.person2);
        cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2, this.person3);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        this.assertPeopleInSortedList(found, this.person2, this.person3);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testSetFilter() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "name", "Goat");
        List found = cacheQuery.list();
        this.assertPeopleInList(found, this.person2, this.person3);
        PrefixFilter filter = new PrefixFilter(new Term("blurb", "cheese"));
        cacheQuery.filter((Filter)filter);
        found = cacheQuery.list();
        this.assertPeopleInList(found, this.person3);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testLazyIterator() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            Assert.assertTrue((boolean)found.hasNext());
            found.next();
            Assert.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnknownFetchModeIterator() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions(){

            public FetchOptions.FetchMode getFetchMode() {
                return null;
            }
        });){
            Assert.assertTrue((boolean)found.hasNext());
            found.next();
            Assert.assertFalse((boolean)found.hasNext());
        }
    }

    @Test
    public void testIteratorWithDefaultOptions() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        try (ResultIterator found = cacheQuery.iterator();){
            Assert.assertTrue((boolean)found.hasNext());
            found.next();
            Assert.assertFalse((boolean)found.hasNext());
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testExplain() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "Eats");
        int matchCounter = 0;
        int i = 0;
        try {
            do {
                Explanation found;
                if (!(found = cacheQuery.explain(i)).isMatch()) continue;
                ++matchCounter;
            } while (++i < 10 && matchCounter != 2);
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)matchCounter);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test
    public void testFullTextFilterOnOff() {
        this.loadTestingData();
        CacheQuery query = this.createCacheQuery(this.cache, "blurb", "Eats");
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"cheese");
        List found = query.list();
        this.assertPeopleInList(found, this.person3);
        query.disableFullTextFilter("personFilter");
        found = query.list();
        this.assertPeopleInList(found, this.person2, this.person3);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIteratorRemove() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "Eats");
        try (ResultIterator iterator = cacheQuery.iterator();){
            if (iterator.hasNext()) {
                iterator.next();
                iterator.remove();
            }
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSearchManagerWithNullCache() {
        Search.getSearchManager(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLazyIteratorWithInvalidFetchSize() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "Eats").firstResult(1);
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY).fetchSize(0));
    }

    @Test(expected=NoSuchElementException.class)
    public void testLazyIteratorWithNoElementsFound() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "fish").firstResult(1);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            found.next();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testIteratorWithNullFetchMode() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "Eats").firstResult(1);
        try (ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(null));){
            found.next();
        }
    }

    @Test
    public void testGetResultSize() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "playing");
        Assert.assertEquals((long)1L, (long)cacheQuery.getResultSize());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMaxResults() {
        this.loadTestingData();
        CacheQuery cacheQuery = this.createCacheQuery(this.cache, "blurb", "eats").maxResults(1);
        Assert.assertEquals((long)2L, (long)cacheQuery.getResultSize());
        Assert.assertEquals((long)1L, (long)cacheQuery.list().size());
        try (ResultIterator eagerIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER));){
            Assert.assertEquals((long)1L, (long)this.countElements((Iterator<?>)eagerIterator));
        }
        try (ResultIterator lazyIterator = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));){
            Assert.assertEquals((long)1L, (long)this.countElements((Iterator<?>)lazyIterator));
        }
        try (ResultIterator defaultIterator = cacheQuery.iterator();){
            Assert.assertEquals((long)1L, (long)this.countElements((Iterator<?>)defaultIterator));
        }
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private int countElements(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    @Test
    public void testClear() {
        this.loadTestingData();
        Term navin = new Term("name", "navin");
        Term goat = new Term("name", "goat");
        BooleanQuery luceneQuery = new BooleanQuery();
        luceneQuery.add((Query)new TermQuery(goat), BooleanClause.Occur.SHOULD);
        luceneQuery.add((Query)new TermQuery(navin), BooleanClause.Occur.SHOULD);
        CacheQuery cacheQuery = Search.getSearchManager(this.cache).getQuery((Query)luceneQuery, new Class[0]);
        Assert.assertEquals((String)("Expected 3, got " + cacheQuery.getResultSize()), (long)3L, (long)cacheQuery.getResultSize());
        this.cache.clear();
        cacheQuery = Search.getSearchManager(this.cache).getQuery((Query)luceneQuery, new Class[0]);
        Assert.assertEquals((long)0L, (long)cacheQuery.getResultSize());
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    protected void loadTestingData() {
        this.prepareTestingData();
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
        StaticTestingErrorHandler.assertAllGood(this.cache);
    }

    private void prepareTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setAge(20);
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setNonIndexedField("test1");
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setAge(30);
        this.person2.setBlurb("Eats grass");
        this.person2.setNonIndexedField("test2");
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setAge(25);
        this.person3.setBlurb("Eats cheese");
        this.person3.setNonIndexedField("test3");
    }

    private void assertPeopleInSortedList(List<?> actualList, Object ... expected) {
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expected));
        Assert.assertEquals((String)"Result doesn't match expected result.", expectedList, actualList);
    }

    private void assertPeopleInList(List<?> actualList, Object ... expected) {
        ArrayList<Object> expectedList = new ArrayList<Object>(Arrays.asList(expected));
        Assert.assertEquals((String)"Size of the result doesn't match.", (long)expected.length, (long)actualList.size());
        Assert.assertTrue((String)("Result doesn't match expected result. Expected: <" + expectedList + ">, was: <" + actualList + ">"), (!Collections.disjoint(actualList, expectedList) ? 1 : 0) != 0);
    }
}

