/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import infinispan.org.apache.commons.csv.CSVFormat;
import infinispan.org.apache.commons.csv.CSVPrinter;
import infinispan.org.apache.commons.csv.QuoteMode;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractCsvLayout;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="CsvLogEventLayout", category="Core", elementType="layout", printObject=true)
public class CsvLogEventLayout
extends AbstractCsvLayout {
    private static final long serialVersionUID = 1L;

    public static CsvLogEventLayout createDefaultLayout() {
        return new CsvLogEventLayout(Charset.forName("UTF-8"), CSVFormat.valueOf((String)"Default"), null, null);
    }

    public static CsvLogEventLayout createLayout(CSVFormat format) {
        return new CsvLogEventLayout(Charset.forName("UTF-8"), format, null, null);
    }

    @PluginFactory
    public static CsvLogEventLayout createLayout(@PluginAttribute(value="format", defaultString="Default") String format, @PluginAttribute(value="delimiter") Character delimiter, @PluginAttribute(value="escape") Character escape, @PluginAttribute(value="quote") Character quote, @PluginAttribute(value="quoteMode") QuoteMode quoteMode, @PluginAttribute(value="nullString") String nullString, @PluginAttribute(value="recordSeparator") String recordSeparator, @PluginAttribute(value="charset", defaultString="UTF-8") Charset charset, @PluginAttribute(value="header") String header, @PluginAttribute(value="footer") String footer) {
        CSVFormat csvFormat = CsvLogEventLayout.createFormat(format, delimiter, escape, quote, quoteMode, nullString, recordSeparator);
        return new CsvLogEventLayout(charset, csvFormat, header, footer);
    }

    protected CsvLogEventLayout(Charset charset, CSVFormat csvFormat, String header, String footer) {
        super(charset, csvFormat, header, footer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String toSerializable(LogEvent event) {
        StringBuilder buffer = this.getStringBuilder();
        try (CSVPrinter printer = new CSVPrinter((Appendable)buffer, this.getFormat());){
            printer.print((Object)event.getNanoTime());
            printer.print((Object)event.getTimeMillis());
            printer.print((Object)event.getLevel());
            printer.print((Object)event.getThreadName());
            printer.print((Object)event.getMessage().getFormattedMessage());
            printer.print((Object)event.getLoggerFqcn());
            printer.print((Object)event.getLoggerName());
            printer.print((Object)event.getMarker());
            printer.print((Object)event.getThrownProxy());
            printer.print((Object)event.getSource());
            printer.print(event.getContextMap());
            printer.print((Object)event.getContextStack());
            printer.println();
            String string = buffer.toString();
            return string;
        }
        catch (IOException e) {
            StatusLogger.getLogger().error(event.toString(), (Throwable)e);
            return this.getFormat().getCommentMarker() + " " + e;
        }
    }
}

