/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql;

import infinispan.org.antlr.runtime.ANTLRStringStream;
import infinispan.org.antlr.runtime.CommonTokenStream;
import infinispan.org.antlr.runtime.RecognitionException;
import infinispan.org.antlr.runtime.Token;
import infinispan.org.antlr.runtime.tree.CommonTree;
import org.hibernate.hql.ParsingException;
import org.hibernate.hql.ast.origin.hql.parse.HQLLexer;
import org.hibernate.hql.ast.origin.hql.parse.HQLParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.AstProcessor;
import org.hibernate.hql.internal.logging.Log;
import org.hibernate.hql.internal.logging.LoggerFactory;

public class QueryParser {
    private static final Log log = LoggerFactory.make();

    public <T> T parseQuery(String queryString, AstProcessingChain<T> processingChain) throws ParsingException {
        HQLLexer lexer = new HQLLexer(new ANTLRStringStream(queryString));
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        HQLParser parser = new HQLParser(tokens);
        try {
            HQLParser.statement_return r = parser.statement();
            if (parser.hasErrors()) {
                throw log.getInvalidQuerySyntaxException(queryString, parser.getErrorMessages());
            }
            String unconsumedTokens = this.getUnconsumedTokens(tokens);
            if (unconsumedTokens != null) {
                throw log.getInvalidQuerySyntaxDueToUnconsumedTokensException(queryString, unconsumedTokens);
            }
            CommonTree tree = (CommonTree)r.getTree();
            boolean debugEnabled = log.isDebugEnabled();
            for (AstProcessor processor : processingChain) {
                tree = processor.process(tokens, tree);
                if (!debugEnabled) continue;
                log.debug("Processed tree: " + tree.toStringTree());
            }
            return processingChain.getResult();
        }
        catch (RecognitionException e) {
            throw log.getInvalidQuerySyntaxException(queryString, e);
        }
    }

    private String getUnconsumedTokens(CommonTokenStream tokens) {
        tokens.fill();
        if (tokens.index() == tokens.size() - 1) {
            return null;
        }
        StringBuilder nonEofEndingTokens = new StringBuilder();
        for (Token endToken : tokens.getTokens(tokens.index(), tokens.size() - 1)) {
            if (endToken.getType() == -1) continue;
            nonEofEndingTokens.append(endToken.getText());
        }
        return nonEofEndingTokens.length() > 0 ? nonEofEndingTokens.toString() : null;
    }
}

