/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.lucene.internal.builder.predicate;

import org.apache.lucene.search.Query;
import org.hibernate.hql.ast.spi.predicate.ComparisonPredicate;
import org.hibernate.hql.lucene.internal.builder.predicate.MatchingContextSupport;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.query.dsl.QueryBuilder;

public class LuceneComparisonPredicate
extends ComparisonPredicate<Query> {
    private final MatchingContextSupport matchingContextSupport;

    public LuceneComparisonPredicate(QueryBuilder builder, FieldBridge fieldBridge, String propertyName, ComparisonPredicate.Type comparisonType, Object value) {
        super(propertyName, comparisonType, value);
        this.matchingContextSupport = new MatchingContextSupport(builder, fieldBridge, propertyName);
    }

    @Override
    protected Query getStrictlyLessQuery() {
        return this.matchingContextSupport.rangeMatchingContext().below(this.value).excludeLimit().createQuery();
    }

    @Override
    protected Query getLessOrEqualsQuery() {
        return this.matchingContextSupport.rangeMatchingContext().below(this.value).createQuery();
    }

    @Override
    protected Query getEqualsQuery() {
        return this.matchingContextSupport.keyWordTermMatchingContext().matching(this.value).createQuery();
    }

    @Override
    protected Query getGreaterOrEqualsQuery() {
        return this.matchingContextSupport.rangeMatchingContext().above(this.value).createQuery();
    }

    @Override
    protected Query getStrictlyGreaterQuery() {
        return this.matchingContextSupport.rangeMatchingContext().above(this.value).excludeLimit().createQuery();
    }
}

