/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.impl;

import org.hibernate.search.analyzer.impl.RemoteAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LazyRemoteAnalyzer
extends RemoteAnalyzer {
    private static final Log log = LoggerFactory.make();
    private RemoteAnalyzer delegate;

    public LazyRemoteAnalyzer(String name) {
        super(name);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getName(String fieldName) {
        this.validate();
        return this.name;
    }

    @Override
    public void close() {
        if (this.delegate != null) {
            this.delegate.close();
        }
    }

    public void setDelegate(RemoteAnalyzer analyzer) {
        this.delegate = analyzer;
    }

    private void validate() {
        if (this.delegate == null) {
            throw log.lazyRemoteAnalyzerNotInitialized(this);
        }
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("<");
        sb.append(this.name);
        if (this.delegate != null) {
            sb.append(", delegate: ");
            sb.append(this.delegate);
        }
        sb.append(">");
        return sb.toString();
    }
}

