/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl;

import java.util.Properties;
import java.util.Set;
import org.apache.lucene.search.similarities.Similarity;
import org.hibernate.search.cfg.spi.IndexManagerFactory;
import org.hibernate.search.engine.impl.DynamicShardingStrategy;
import org.hibernate.search.engine.impl.MutableEntityIndexBinding;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.indexes.impl.IndexManagerHolder;
import org.hibernate.search.indexes.interceptor.EntityIndexingInterceptor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.ShardIdentifierProvider;

public class DynamicShardingEntityIndexBinding
implements MutableEntityIndexBinding {
    private final DynamicShardingStrategy shardingStrategy;
    private final Similarity similarityInstance;
    private final ShardIdentifierProvider shardIdentityProvider;
    private final Properties properties;
    private final ExtendedSearchIntegrator extendedIntegrator;
    private final IndexManagerHolder indexManagerHolder;
    private final String rootDirectoryProviderName;
    private DocumentBuilderIndexedEntity documentBuilder;
    private final EntityIndexingInterceptor entityIndexingInterceptor;
    private IndexManagerFactory indexManagerFactory;

    public DynamicShardingEntityIndexBinding(ShardIdentifierProvider shardIdentityProvider, Similarity similarityInstance, EntityIndexingInterceptor entityIndexingInterceptor, Properties properties, ExtendedSearchIntegrator extendedIntegrator, IndexManagerHolder indexManagerHolder, String rootDirectoryProviderName) {
        this.shardIdentityProvider = shardIdentityProvider;
        this.similarityInstance = similarityInstance;
        this.entityIndexingInterceptor = entityIndexingInterceptor;
        this.properties = properties;
        this.extendedIntegrator = extendedIntegrator;
        this.indexManagerFactory = this.indexManagerFactory;
        this.indexManagerHolder = indexManagerHolder;
        this.rootDirectoryProviderName = rootDirectoryProviderName;
        this.shardingStrategy = new DynamicShardingStrategy(shardIdentityProvider, indexManagerHolder, this, rootDirectoryProviderName);
    }

    @Override
    public void setDocumentBuilderIndexedEntity(DocumentBuilderIndexedEntity documentBuilder) {
        this.documentBuilder = documentBuilder;
    }

    @Override
    public Similarity getSimilarity() {
        return this.similarityInstance;
    }

    @Override
    public IndexShardingStrategy getSelectionStrategy() {
        return this.shardingStrategy;
    }

    @Override
    public ShardIdentifierProvider getShardIdentifierProvider() {
        return this.shardingStrategy.getShardIdentifierProvider();
    }

    @Override
    public DocumentBuilderIndexedEntity getDocumentBuilder() {
        return this.documentBuilder;
    }

    @Override
    public void postInitialize(Set<Class<?>> indexedClasses) {
        this.documentBuilder.postInitialize(indexedClasses);
    }

    @Override
    public IndexManager[] getIndexManagers() {
        return this.shardingStrategy.getIndexManagersForAllShards();
    }

    @Override
    public EntityIndexingInterceptor getEntityIndexingInterceptor() {
        return this.entityIndexingInterceptor;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ExtendedSearchIntegrator getSearchIntegrator() {
        return this.extendedIntegrator;
    }

    public IndexManagerFactory getIndexManagerFactory() {
        return this.indexManagerFactory;
    }

    public MutableEntityIndexBinding cloneWithSimilarity(Similarity entitySimilarity) {
        return new DynamicShardingEntityIndexBinding(this.shardIdentityProvider, entitySimilarity, this.entityIndexingInterceptor, this.properties, this.extendedIntegrator, this.indexManagerHolder, this.rootDirectoryProviderName);
    }
}

