/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.impl.nullencoding;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.engine.impl.nullencoding.NullMarkerCodec;

class NumericIntegerNullCodec
implements NullMarkerCodec {
    private final Integer indexNullAs;

    NumericIntegerNullCodec(Integer indexNullAs) {
        if (indexNullAs == null) {
            throw new NullPointerException("The constructor parameter is mandatory");
        }
        this.indexNullAs = indexNullAs;
    }

    @Override
    public String nullRepresentedAsString() {
        return this.indexNullAs.toString();
    }

    @Override
    public void encodeNullValue(String name, Document document, LuceneOptions luceneOptions) {
        luceneOptions.addNumericFieldToDocument(name, this.indexNullAs, document);
    }

    @Override
    public Query createNullMatchingQuery(String fieldName) {
        return NumericRangeQuery.newIntRange(fieldName, this.indexNullAs, this.indexNullAs, true, true);
    }

    @Override
    public boolean representsNullValue(IndexableField field) {
        Number numericValue = field.numericValue();
        return this.indexNullAs.equals(numericValue);
    }
}

