/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.HashSet;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FileHelper {
    private static final Log log = LoggerFactory.make();
    private static final int FAT_PRECISION = 2000;
    public static final long DEFAULT_COPY_BUFFER_SIZE = 0x1000000L;

    private FileHelper() {
    }

    public static boolean areInSync(File source, File destination) throws IOException {
        if (source.isDirectory()) {
            String[] dests;
            if (!destination.exists()) {
                return false;
            }
            if (!destination.isDirectory()) {
                throw new IOException("Source and Destination not of the same type:" + source.getCanonicalPath() + " , " + destination.getCanonicalPath());
            }
            String[] sources = source.list();
            HashSet<String> srcNames = new HashSet<String>(Arrays.asList(sources));
            for (String fileName : dests = destination.list()) {
                if (srcNames.contains(fileName)) continue;
                return false;
            }
            boolean inSync = true;
            for (String fileName : sources) {
                File srcFile = new File(source, fileName);
                File destFile = new File(destination, fileName);
                if (FileHelper.areInSync(srcFile, destFile)) continue;
                inSync = false;
                break;
            }
            return inSync;
        }
        if (destination.exists() && destination.isFile()) {
            long dts;
            long sts = source.lastModified() / 2000L;
            return sts == (dts = destination.lastModified() / 2000L);
        }
        return false;
    }

    public static void synchronize(File source, File destination, boolean smart) throws IOException {
        FileHelper.synchronize(source, destination, smart, 0x1000000L);
    }

    public static void synchronize(File source, File destination, boolean smart, long chunkSize) throws IOException {
        if (chunkSize <= 0L) {
            log.checkSizeMustBePositive();
            chunkSize = 0x1000000L;
        }
        if (source.isDirectory()) {
            String[] dests;
            if (!destination.exists()) {
                if (!destination.mkdirs()) {
                    throw new IOException("Could not create path " + destination);
                }
            } else if (!destination.isDirectory()) {
                throw new IOException("Source and Destination not of the same type:" + source.getCanonicalPath() + " , " + destination.getCanonicalPath());
            }
            String[] sources = source.list();
            HashSet<String> srcNames = new HashSet<String>(Arrays.asList(sources));
            for (String fileName : dests = destination.list()) {
                if (srcNames.contains(fileName)) continue;
                FileHelper.delete(new File(destination, fileName));
            }
            for (String fileName : sources) {
                File srcFile = new File(source, fileName);
                File destFile = new File(destination, fileName);
                FileHelper.synchronize(srcFile, destFile, smart, chunkSize);
            }
        } else {
            if (destination.exists() && destination.isDirectory()) {
                FileHelper.delete(destination);
            }
            if (destination.exists()) {
                long sts = source.lastModified() / 2000L;
                long dts = destination.lastModified() / 2000L;
                if (!smart || sts == 0L || sts != dts || source.length() != destination.length()) {
                    FileHelper.copyFile(source, destination, chunkSize);
                }
            } else {
                FileHelper.copyFile(source, destination, chunkSize);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File srcFile, File destFile, long chunkSize) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            long transferredLength;
            is = new FileInputStream(srcFile);
            FileChannel iChannel = is.getChannel();
            os = new FileOutputStream(destFile, false);
            FileChannel oChannel = os.getChannel();
            long doneBytes = 0L;
            for (long todoBytes = srcFile.length(); todoBytes != 0L; todoBytes -= transferredLength) {
                long iterationBytes = Math.min(todoBytes, chunkSize);
                if (iterationBytes != (transferredLength = oChannel.transferFrom(iChannel, doneBytes, iterationBytes))) {
                    throw new IOException("Error during file transfer: expected " + iterationBytes + " bytes, only " + transferredLength + " bytes copied.");
                }
                doneBytes += transferredLength;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        boolean successTimestampOp = destFile.setLastModified(srcFile.lastModified());
        if (!successTimestampOp) {
            log.notChangeTimestamp(destFile);
        }
    }

    @Deprecated
    public static void delete(File file) throws IOException {
        FileHelper.delete(file.toPath());
    }

    public static void delete(Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

