/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.hibernate.search.engine.service.classloading.spi.ClassLoaderService;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class HibernateSearchResourceLoader
implements ResourceLoader {
    private static final Log log = LoggerFactory.make();
    private final ServiceManager serviceManager;

    public HibernateSearchResourceLoader(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public InputStream openResource(String resource) throws IOException {
        ClassLoaderService classLoaderService = this.serviceManager.getClassLoaderService();
        InputStream inputStream = classLoaderService.locateResourceStream(resource);
        if (inputStream == null) {
            throw log.unableToLoadResource(resource);
        }
        return inputStream;
    }

    @Override
    public <T> Class<? extends T> findClass(String className, Class<T> expectedType) {
        return ClassLoaderHelper.classForName(expectedType, className, HibernateSearchResourceLoader.describeComponent(className), this.serviceManager);
    }

    @Override
    public <T> T newInstance(String className, Class<T> expectedType) {
        return ClassLoaderHelper.instanceFromName(expectedType, className, HibernateSearchResourceLoader.describeComponent(className), this.serviceManager);
    }

    private static String describeComponent(String className) {
        return "Lucene Analyzer component " + className;
    }
}

