/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.predicateindex;

import java.util.Iterator;
import org.infinispan.objectfilter.impl.predicateindex.AttributeNode;
import org.infinispan.objectfilter.impl.predicateindex.MatcherEvalContext;
import org.infinispan.objectfilter.impl.util.ReflectionHelper;

public final class ReflectionMatcherEvalContext
extends MatcherEvalContext<Class<?>, ReflectionHelper.PropertyAccessor, String> {
    private final Class<?> entityType;

    public ReflectionMatcherEvalContext(Object userContext, Object eventType, Object instance) {
        super(userContext, eventType, instance);
        this.entityType = instance.getClass();
    }

    @Override
    public Class<?> getEntityType() {
        return this.entityType;
    }

    @Override
    protected void processAttributes(AttributeNode<ReflectionHelper.PropertyAccessor, String> node, Object instance) {
        for (AttributeNode<ReflectionHelper.PropertyAccessor, String> childAttribute : node.getChildren()) {
            if (instance == null) {
                this.processAttribute(childAttribute, null);
                continue;
            }
            ReflectionHelper.PropertyAccessor accessor = childAttribute.getMetadata();
            if (accessor.isMultiple()) {
                Iterator<Object> valuesIt = accessor.getValueIterator(instance);
                if (valuesIt == null) {
                    this.processAttribute(childAttribute, null);
                    continue;
                }
                while (valuesIt.hasNext()) {
                    Object attributeValue = valuesIt.next();
                    this.processAttribute(childAttribute, attributeValue);
                }
                continue;
            }
            Object attributeValue = accessor.getValue(instance);
            this.processAttribute(childAttribute, attributeValue);
        }
    }

    private void processAttribute(AttributeNode<ReflectionHelper.PropertyAccessor, String> attributeNode, Object attributeValue) {
        attributeNode.processValue(attributeValue, this);
        this.processAttributes(attributeNode, attributeValue);
    }
}

