/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.objectfilter.impl.syntax;

import java.util.List;
import org.infinispan.objectfilter.PropertyPath;
import org.infinispan.objectfilter.impl.syntax.PropertyValueExpr;
import org.infinispan.objectfilter.impl.syntax.ValueExpr;
import org.infinispan.objectfilter.impl.syntax.Visitor;

public final class AggregationExpr
extends PropertyValueExpr {
    private final PropertyPath propertyPath;

    public AggregationExpr(PropertyPath.AggregationType aggregationType, List<String> propertyPath, boolean isRepeated) {
        super(propertyPath, isRepeated);
        if (aggregationType == null) {
            throw new IllegalArgumentException("aggregationType cannot be null");
        }
        this.propertyPath = new PropertyPath(aggregationType, propertyPath);
    }

    public PropertyPath getAggregationPath() {
        return this.propertyPath;
    }

    public PropertyPath.AggregationType getAggregationType() {
        return this.propertyPath.getAggregationType();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationExpr other = (AggregationExpr)o;
        return this.propertyPath.equals(other.propertyPath);
    }

    @Override
    public int hashCode() {
        return this.propertyPath.hashCode();
    }

    @Override
    public String toString() {
        return this.propertyPath.getAggregationType().name() + "(" + super.toString() + ")";
    }

    @Override
    public String toJpaString() {
        return this.propertyPath.getAggregationType().name() + "(" + super.toJpaString() + ")";
    }

    @Override
    public ValueExpr acceptVisitor(Visitor visitor) {
        return visitor.visit(this);
    }
}

