/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.embedded.impl.DelegatingQuery;
import org.infinispan.query.dsl.embedded.impl.EmbeddedQueryFactory;
import org.infinispan.query.dsl.embedded.impl.QueryEngine;
import org.infinispan.query.dsl.impl.BaseQueryBuilder;
import org.infinispan.query.dsl.impl.JPAQueryGenerator;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class EmbeddedQueryBuilder
extends BaseQueryBuilder<Query> {
    private static final Log log = (Log)LogFactory.getLog(EmbeddedQueryBuilder.class, Log.class);
    private static final boolean trace = log.isTraceEnabled();
    private final QueryEngine queryEngine;

    EmbeddedQueryBuilder(EmbeddedQueryFactory queryFactory, QueryEngine queryEngine, String rootType) {
        super(queryFactory, rootType);
        this.queryEngine = queryEngine;
    }

    @Override
    public Query build() {
        JPAQueryGenerator generator = new JPAQueryGenerator();
        String jpqlString = this.accept(generator);
        if (trace) {
            log.tracef("JPQL string : %s", jpqlString);
        }
        return new DelegatingQuery(this.queryEngine, this.queryFactory, jpqlString, generator.getNamedParameters(), this.getProjectionPaths(), this.startOffset, this.maxResults);
    }
}

