/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.context.InvocationContext;
import org.infinispan.query.indexmanager.AbstractUpdateCommand;

public class IndexUpdateCommand
extends AbstractUpdateCommand {
    public static final byte COMMAND_ID = 102;

    public IndexUpdateCommand(String cacheName) {
        super(cacheName);
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        if (this.queryInterceptor.isStopping()) {
            throw log.cacheIsStoppingNoCommandAllowed(this.cacheName);
        }
        IndexManager indexManager = this.searchFactory.getIndexManager(this.indexName);
        if (indexManager == null) {
            throw new SearchException("Unknown index referenced : " + this.indexName);
        }
        List<LuceneWork> luceneWorks = indexManager.getSerializer().toLuceneWorks(this.serializedModel);
        List<LuceneWork> workToApply = this.transformKeysToStrings(luceneWorks);
        indexManager.performOperations(workToApply, null);
        return Boolean.TRUE;
    }

    @Override
    public byte getCommandId() {
        return 102;
    }
}

