/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partionhandling.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.partionhandling.impl.AvailabilityMode;
import org.infinispan.partionhandling.impl.AvailabilityStrategy;
import org.infinispan.partionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PreferConsistencyStrategy
implements AvailabilityStrategy {
    private static final Log log = LogFactory.getLog(PreferConsistencyStrategy.class);

    @Override
    public void onJoin(AvailabilityStrategyContext context, Address joiner) {
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s not available (%s), postponing rebalance for joiner %s", (Object)context.getCacheName(), (Object)context.getAvailabilityMode(), (Object)joiner);
            return;
        }
        context.queueRebalance(context.getExpectedMembers());
    }

    @Override
    public void onGracefulLeave(AvailabilityStrategyContext context, Address leaver) {
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s is not available, ignoring graceful leaver %s", (Object)context.getCacheName(), (Object)leaver);
            return;
        }
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        newMembers.retainAll(context.getExpectedMembers());
        if (this.isDataLost(context.getStableTopology().getCurrentCH(), newMembers)) {
            log.enteringUnavailableModeGracefulLeaver(context.getCacheName(), leaver);
            context.updateAvailabilityMode(AvailabilityMode.UNAVAILABLE);
            return;
        }
        this.updateMembersAndRebalance(context, newMembers);
    }

    @Override
    public void onClusterViewChange(AvailabilityStrategyContext context, List<Address> clusterMembers) {
        if (context.getAvailabilityMode() != AvailabilityMode.AVAILABLE) {
            log.debugf("Cache %s is not available, ignoring cluster view change", (Object)context.getCacheName());
            return;
        }
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        if (!newMembers.retainAll(clusterMembers)) {
            log.debugf("Cache %s did not lose any members, ignoring view change", (Object)context.getCacheName());
            return;
        }
        CacheTopology stableTopology = context.getStableTopology();
        List<Address> stableMembers = stableTopology.getMembers();
        ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
        lostMembers.removeAll(newMembers);
        if (this.isDataLost(stableTopology.getCurrentCH(), newMembers)) {
            log.enteringDegradedModeLostData(context.getCacheName(), lostMembers);
            context.updateAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
            return;
        }
        if ((double)lostMembers.size() >= (double)stableMembers.size() - Math.ceil((double)stableMembers.size() / 2.0)) {
            log.enteringDegradedModeMinorityPartition(context.getCacheName(), lostMembers.size(), stableMembers.size());
            context.updateAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
            return;
        }
        this.updateMembersAndRebalance(context, newMembers);
    }

    @Override
    public void onPartitionMerge(AvailabilityStrategyContext context, Collection<CacheStatusResponse> statusResponses) {
        CacheTopology mergedTopology;
        AvailabilityMode mergedAvailabilityMode;
        CacheTopology maxActiveTopology = null;
        CacheTopology maxDegradedTopology = null;
        CacheTopology maxUnavailableTopology = null;
        CacheTopology maxStableTopology = null;
        for (CacheStatusResponse response : statusResponses) {
            CacheTopology partitionTopology;
            CacheTopology partitionStableTopology = response.getStableTopology();
            if (maxStableTopology == null || !maxStableTopology.equals(partitionStableTopology)) {
                log.tracef("Found stable partition topology: %s", (Object)maxStableTopology);
            }
            if (partitionStableTopology == null) continue;
            if (maxStableTopology == null || maxStableTopology.getTopologyId() < partitionStableTopology.getTopologyId()) {
                maxStableTopology = partitionStableTopology;
            }
            if ((partitionTopology = response.getCacheTopology()) == null) continue;
            if (response.getAvailabilityMode() == AvailabilityMode.AVAILABLE) {
                if (maxActiveTopology == null || !maxActiveTopology.equals(partitionTopology)) {
                    log.tracef("Found active partition topology: %s", (Object)maxActiveTopology);
                }
                if (maxActiveTopology != null && maxActiveTopology.getTopologyId() >= partitionTopology.getTopologyId()) continue;
                maxActiveTopology = partitionTopology;
                continue;
            }
            if (response.getAvailabilityMode() == AvailabilityMode.DEGRADED_MODE) {
                if (maxDegradedTopology == null || !maxDegradedTopology.equals(partitionTopology)) {
                    log.tracef("Found degraded partition topology: %s", (Object)maxDegradedTopology);
                }
                if (maxDegradedTopology != null && maxDegradedTopology.getTopologyId() >= partitionTopology.getTopologyId()) continue;
                maxDegradedTopology = partitionTopology;
                continue;
            }
            if (response.getAvailabilityMode() == AvailabilityMode.UNAVAILABLE) {
                if (maxUnavailableTopology == null || !maxUnavailableTopology.equals(partitionTopology)) {
                    log.tracef("Found unavailable partition topology: %s", (Object)maxUnavailableTopology);
                }
                if (maxUnavailableTopology != null && maxUnavailableTopology.getTopologyId() >= partitionTopology.getTopologyId()) continue;
                maxUnavailableTopology = partitionTopology;
                continue;
            }
            log.unexpectedAvailabilityMode(context.getAvailabilityMode(), context.getCacheName(), response.getCacheTopology());
        }
        if (maxUnavailableTopology != null) {
            log.debugf("One of the partitions is unavailable, using that partition's topology and staying in unavailable mode", new Object[0]);
            mergedAvailabilityMode = AvailabilityMode.UNAVAILABLE;
            mergedTopology = maxUnavailableTopology;
        } else if (maxActiveTopology != null) {
            log.debugf("One of the partitions is available, using that partition's topology and staying in available mode", new Object[0]);
            mergedAvailabilityMode = AvailabilityMode.AVAILABLE;
            mergedTopology = maxActiveTopology;
        } else if (maxDegradedTopology != null) {
            log.debugf("No active or unavailable partitions, so all the partitions must be in degraded mode.", new Object[0]);
            mergedAvailabilityMode = AvailabilityMode.DEGRADED_MODE;
            mergedTopology = maxDegradedTopology;
        } else {
            log.debugf("No current topology, recovered only joiners for cache %s", (Object)context.getCacheName());
            mergedAvailabilityMode = AvailabilityMode.AVAILABLE;
            mergedTopology = null;
        }
        if (mergedTopology != null && mergedTopology.getPendingCH() != null) {
            mergedTopology = new CacheTopology(mergedTopology.getTopologyId() + 1, mergedTopology.getRebalanceId(), mergedTopology.getCurrentCH(), null);
        }
        log.debugf("Updating topologies after merge for cache %s, current topology = %s, stable topology = %s, availability mode = %s", new Object[]{context.getCacheName(), mergedTopology, maxStableTopology, mergedAvailabilityMode});
        context.updateTopologiesAfterMerge(mergedTopology, maxStableTopology, mergedAvailabilityMode);
        if (mergedAvailabilityMode == AvailabilityMode.UNAVAILABLE) {
            log.debugf("After merge, cache %s is staying in unavailable mode", (Object)context.getCacheName());
            context.updateAvailabilityMode(AvailabilityMode.UNAVAILABLE);
            return;
        }
        ArrayList<Address> newMembers = new ArrayList<Address>(mergedTopology.getMembers());
        newMembers.retainAll(context.getExpectedMembers());
        if (maxStableTopology != null) {
            List<Address> stableMembers = maxStableTopology.getMembers();
            ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
            lostMembers.removeAll(context.getExpectedMembers());
            if (this.isDataLost(maxStableTopology.getCurrentCH(), newMembers)) {
                log.keepingDegradedModeAfterMergeDataLost(context.getCacheName(), lostMembers);
                context.updateAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
                return;
            }
            if ((double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0)) {
                log.keepingDegradedModeAfterMergeMinorityPartition(context.getCacheName(), lostMembers.size(), stableMembers.size());
                context.updateAvailabilityMode(AvailabilityMode.DEGRADED_MODE);
                return;
            }
        }
        log.debugf("After merge, cache %s has recovered and is entering available mode", new Object[0]);
        this.updateMembersAndRebalance(context, context.getExpectedMembers());
    }

    @Override
    public void onRebalanceEnd(AvailabilityStrategyContext context) {
    }

    @Override
    public void onManualAvailabilityChange(AvailabilityStrategyContext context) {
        this.updateMembersAndRebalance(context, context.getExpectedMembers());
    }

    private void updateMembersAndRebalance(AvailabilityStrategyContext context, List<Address> newMembers) {
        context.updateAvailabilityMode(AvailabilityMode.AVAILABLE);
        context.updateCurrentTopology(newMembers);
        context.queueRebalance(context.getExpectedMembers());
    }

    private boolean isDataLost(ConsistentHash currentCH, List<Address> newMembers) {
        for (int i = 0; i < currentCH.getNumSegments(); ++i) {
            if (this.containsAny(newMembers, currentCH.locateOwnersForSegment(i))) continue;
            return true;
        }
        return false;
    }

    private boolean containsAny(List<Address> newMembers, List<Address> owners) {
        for (Address owner : owners) {
            if (!newMembers.contains(owner)) continue;
            return true;
        }
        return false;
    }
}

