/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.partionhandling.impl.AvailabilityMode;
import org.infinispan.partionhandling.impl.AvailabilityStrategy;
import org.infinispan.partionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.ClusterTopologyManager;
import org.infinispan.topology.RebalanceConfirmationCollector;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class ClusterCacheStatus
implements AvailabilityStrategyContext {
    private static final Log log = LogFactory.getLog(ClusterCacheStatus.class);
    private static boolean trace = log.isTraceEnabled();
    private final String cacheName;
    private final AvailabilityStrategy availabilityStrategy;
    private final ClusterTopologyManager clusterTopologyManager;
    private volatile CacheJoinInfo joinInfo;
    private volatile List<Address> expectedMembers;
    private volatile Map<Address, Float> capacityFactors;
    private volatile List<Address> joiners;
    private volatile CacheTopology currentTopology;
    private volatile CacheTopology stableTopology;
    private volatile AvailabilityMode availabilityMode = AvailabilityMode.AVAILABLE;
    private volatile List<Address> queuedRebalanceMembers;
    private volatile RebalanceConfirmationCollector rebalanceConfirmationCollector;

    public ClusterCacheStatus(String cacheName, AvailabilityStrategy availabilityStrategy, ClusterTopologyManager clusterTopologyManager) {
        this.cacheName = cacheName;
        this.availabilityStrategy = availabilityStrategy;
        this.clusterTopologyManager = clusterTopologyManager;
        this.currentTopology = null;
        this.stableTopology = null;
        this.expectedMembers = InfinispanCollections.emptyList();
        this.capacityFactors = InfinispanCollections.emptyMap();
        this.joiners = InfinispanCollections.emptyList();
        if (trace) {
            log.tracef("Cache %s initialized, join info is %s", (Object)cacheName, (Object)this.joinInfo);
        }
    }

    public CacheJoinInfo getJoinInfo() {
        return this.joinInfo;
    }

    @Override
    public List<Address> getExpectedMembers() {
        return this.expectedMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void queueRebalance(List<Address> newMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (newMembers != null && !newMembers.isEmpty()) {
                log.debugf("Queueing rebalance for cache %s with members %s", (Object)this.cacheName, (Object)newMembers);
                this.queuedRebalanceMembers = newMembers;
                this.startQueuedRebalance();
            }
        }
    }

    public boolean isTotalOrder() {
        return this.joinInfo.isTotalOrder();
    }

    public boolean isDistributed() {
        return this.joinInfo.isDistributed();
    }

    public Map<Address, Float> getCapacityFactors() {
        return this.capacityFactors;
    }

    @Override
    public CacheTopology getCurrentTopology() {
        return this.currentTopology;
    }

    @Override
    public CacheTopology getStableTopology() {
        return this.stableTopology;
    }

    @Override
    public AvailabilityMode getAvailabilityMode() {
        return this.availabilityMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            boolean modeChanged = this.setAvailabilityMode(newAvailabilityMode);
            if (modeChanged) {
                CacheTopology newTopology = new CacheTopology(this.currentTopology.getTopologyId() + 1, this.currentTopology.getRebalanceId(), this.currentTopology.getCurrentCH(), this.currentTopology.getPendingCH());
                this.setCurrentTopology(newTopology);
                this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, newAvailabilityMode, this.isTotalOrder(), this.isDistributed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTopologiesAfterMerge(CacheTopology currentTopology, CacheTopology stableTopology, AvailabilityMode availabilityMode) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            log.debugf("Updating topologies after merge for cache %s, current topology = %s, stable topology = %s, availability mode = %s", new Object[]{this.cacheName, currentTopology, stableTopology, availabilityMode});
            this.currentTopology = currentTopology;
            this.stableTopology = stableTopology;
            this.availabilityMode = availabilityMode;
            if (currentTopology != null) {
                this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, currentTopology, availabilityMode, this.isTotalOrder(), this.isDistributed());
            }
            if (stableTopology != null) {
                this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, stableTopology, this.isTotalOrder(), this.isDistributed());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addMember(Address joiner, CacheJoinInfo joinInfo) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.expectedMembers.contains(joiner)) {
                return false;
            }
            if (this.joinInfo == null) {
                this.joinInfo = joinInfo;
            }
            HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            newCapacityFactors.put(joiner, Float.valueOf(joinInfo.getCapacityFactor()));
            this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
            this.expectedMembers = this.immutableAdd(this.expectedMembers, joiner);
            this.joiners = this.immutableAdd(this.joiners, joiner);
            if (trace) {
                log.tracef("Added joiner %s to cache %s: members = %s, joiners = %s", joiner, this.cacheName, this.expectedMembers, this.joiners);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMember(Address leaver) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (!this.expectedMembers.contains(leaver)) {
                if (trace) {
                    log.tracef("Trying to remove node %s from cache %s, but it is not a member: members = %s", (Object)leaver, (Object)this.cacheName, (Object)this.expectedMembers);
                }
                return false;
            }
            this.expectedMembers = this.immutableRemove(this.expectedMembers, leaver);
            HashMap<Address, Float> newCapacityFactors = new HashMap<Address, Float>(this.capacityFactors);
            newCapacityFactors.remove(leaver);
            this.capacityFactors = Immutables.immutableMapWrap(newCapacityFactors);
            this.joiners = this.immutableRemove(this.joiners, leaver);
            if (trace) {
                log.tracef("Removed node %s from cache %s: members = %s, joiners = %s", leaver, this.cacheName, this.expectedMembers, this.joiners);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retainMembers(List<Address> newClusterMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (newClusterMembers.containsAll(this.expectedMembers)) {
                if (trace) {
                    log.tracef("Cluster members updated for cache %s, no abrupt leavers detected: cache members = %s. Existing members = %s", (Object)this.cacheName, (Object)newClusterMembers, (Object)this.expectedMembers);
                }
                return false;
            }
            this.expectedMembers = this.immutableRetainAll(this.expectedMembers, newClusterMembers);
            this.joiners = this.immutableRetainAll(this.joiners, newClusterMembers);
            if (trace) {
                log.tracef("Cluster members updated for cache %s: members = %s, joiners = %s", (Object)this.cacheName, (Object)this.expectedMembers, (Object)this.joiners);
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCurrentTopology(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.currentTopology = newTopology;
            if (newTopology != null) {
                this.joiners = this.immutableRemoveAll(this.expectedMembers, newTopology.getCurrentCH().getMembers());
            }
            if (trace) {
                log.tracef("Cache %s topology updated: %s, members = %s, joiners = %s", this.cacheName, this.currentTopology, this.expectedMembers, this.joiners);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setStableTopology(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.stableTopology = newTopology;
            if (trace) {
                log.tracef("Cache %s stable topology updated: members = %s, joiners = %s, topology = %s", this.cacheName, this.expectedMembers, this.joiners, newTopology);
            }
        }
    }

    private boolean needConsistentHashUpdate() {
        return !this.expectedMembers.equals(this.currentTopology.getMembers());
    }

    private List<Address> pruneInvalidMembers(List<Address> possibleMembers) {
        return this.immutableRetainAll(possibleMembers, this.expectedMembers);
    }

    public boolean isRebalanceInProgress() {
        return this.rebalanceConfirmationCollector != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initRebalanceConfirmationCollector(CacheTopology newTopology) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector != null) {
                return false;
            }
            this.rebalanceConfirmationCollector = new RebalanceConfirmationCollector(this.cacheName, newTopology.getTopologyId(), newTopology.getMembers());
            this.setCurrentTopology(newTopology);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doConfirmRebalance(Address member, int receivedTopologyId) throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector == null) {
                throw new CacheException(String.format("Received invalid rebalance confirmation from %s for cache %s, we don't have a rebalance in progress", member, this.cacheName));
            }
            boolean rebalanceCompleted = this.rebalanceConfirmationCollector.confirmRebalance(member, receivedTopologyId);
            if (rebalanceCompleted) {
                this.endRebalance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateRebalanceMembers() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector == null) {
                return false;
            }
            return this.rebalanceConfirmationCollector.updateMembers(this.expectedMembers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleClusterView(List<Address> newClusterMembers) throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            boolean rebalanceCompleted;
            if (this.currentTopology == null) {
                return;
            }
            boolean cacheMembersModified = this.retainMembers(newClusterMembers);
            this.availabilityStrategy.onClusterViewChange(this, newClusterMembers);
            if (cacheMembersModified && (rebalanceCompleted = this.updateRebalanceMembers())) {
                this.endRebalance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endRebalance() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            this.removeRebalanceConfirmationCollector();
            CacheTopology currentTopology = this.getCurrentTopology();
            if (currentTopology == null) {
                log.tracef("Rebalance finished because there are no more members in cache %s", (Object)this.cacheName);
                return;
            }
            int currentTopologyId = currentTopology.getTopologyId();
            log.debugf("Finished cluster-wide rebalance for cache %s, topology id = %d", (Object)this.cacheName, (Object)currentTopologyId);
            int newTopologyId = currentTopologyId + 1;
            ConsistentHash newCurrentCH = currentTopology.getPendingCH();
            CacheTopology newTopology = new CacheTopology(newTopologyId, this.getCurrentTopology().getRebalanceId(), newCurrentCH, null);
            this.setCurrentTopology(newTopology);
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
            this.availabilityStrategy.onRebalanceEnd(this);
            this.startQueuedRebalance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRebalanceConfirmationCollector() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.rebalanceConfirmationCollector == null) {
                throw new IllegalStateException("Can't end rebalance, there is no rebalance in progress");
            }
            this.rebalanceConfirmationCollector = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCurrentTopology(List<Address> newMembers) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.currentTopology == null) {
                this.createInitialCacheTopology();
            }
            ConsistentHashFactory consistentHashFactory = this.getJoinInfo().getConsistentHashFactory();
            int topologyId = this.currentTopology.getTopologyId();
            int rebalanceId = this.currentTopology.getRebalanceId();
            ConsistentHash currentCH = this.currentTopology.getCurrentCH();
            ConsistentHash pendingCH = this.currentTopology.getPendingCH();
            if (!this.needConsistentHashUpdate()) {
                log.tracef("Cache %s members list was updated, but the cache topology doesn't need to change: %s", (Object)this.cacheName, (Object)this.currentTopology);
                return;
            }
            if (newMembers.isEmpty()) {
                log.tracef("Cache %s no longer has any members, removing topology", (Object)this.cacheName);
                this.setCurrentTopology(null);
                this.setStableTopology(null);
                return;
            }
            ConsistentHash newCurrentCH = consistentHashFactory.updateMembers(currentCH, newMembers, this.getCapacityFactors());
            ConsistentHash newPendingCH = null;
            if (pendingCH != null) {
                List<Address> newPendingMembers = this.pruneInvalidMembers(pendingCH.getMembers());
                newPendingCH = consistentHashFactory.updateMembers(pendingCH, newPendingMembers, this.getCapacityFactors());
            }
            CacheTopology newTopology = new CacheTopology(topologyId + 1, rebalanceId, newCurrentCH, newPendingCH);
            this.setCurrentTopology(newTopology);
            newTopology.logRoutingTableInformation();
            this.clusterTopologyManager.broadcastTopologyUpdate(this.cacheName, newTopology, this.availabilityMode, this.isTotalOrder(), this.isDistributed());
        }
    }

    private boolean setAvailabilityMode(AvailabilityMode newAvailabilityMode) {
        if (newAvailabilityMode == this.availabilityMode) {
            return false;
        }
        log.tracef("Cache %s availability changed: %s -> %s", (Object)this.availabilityMode, (Object)newAvailabilityMode);
        this.availabilityMode = newAvailabilityMode;
        return true;
    }

    private <T> List<T> immutableAdd(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.add(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemove(List<T> list, T element) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.remove(element);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRemoveAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.removeAll(otherList);
        return Collections.unmodifiableList(result);
    }

    private <T> List<T> immutableRetainAll(List<T> list, List<T> otherList) {
        ArrayList<T> result = new ArrayList<T>(list);
        result.retainAll(otherList);
        return Collections.unmodifiableList(result);
    }

    public String toString() {
        return "ClusterCacheStatus{cacheName='" + this.cacheName + '\'' + ", members=" + this.expectedMembers + ", joiners=" + this.joiners + ", currentTopology=" + this.currentTopology + ", rebalanceConfirmationCollector=" + this.rebalanceConfirmationCollector + '}';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMergePartitions(Map<Address, CacheStatusResponse> statusResponses, List<Address> clusterMembers, boolean isMergeView) throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (statusResponses.isEmpty()) {
                throw new IllegalArgumentException("Should have at least one current topology");
            }
            try {
                HashMap<Address, CacheJoinInfo> joinInfos = new HashMap<Address, CacheJoinInfo>();
                HashSet<CacheTopology> currentTopologies = new HashSet<CacheTopology>();
                HashSet<CacheTopology> stableTopologies = new HashSet<CacheTopology>();
                for (Map.Entry<Address, CacheStatusResponse> e : statusResponses.entrySet()) {
                    Address sender = e.getKey();
                    CacheStatusResponse response = e.getValue();
                    joinInfos.put(sender, response.getCacheJoinInfo());
                    if (response.getCacheTopology() != null) {
                        currentTopologies.add(response.getCacheTopology());
                    }
                    if (response.getStableTopology() == null) continue;
                    stableTopologies.add(response.getStableTopology());
                }
                log.debugf("Recovered %d partition(s) for cache %s: %s", (Object)currentTopologies.size(), (Object)this.cacheName, (Object)currentTopologies);
                this.recoverMembers(joinInfos, currentTopologies, stableTopologies);
                this.availabilityStrategy.onPartitionMerge(this, statusResponses.values());
            }
            catch (Exception e) {
                log.failedToRecoverCacheState(this.cacheName, e);
            }
        }
    }

    private void recoverMembers(Map<Address, CacheJoinInfo> joinInfos, Collection<CacheTopology> currentTopologies, Collection<CacheTopology> stableTopologies) {
        this.expectedMembers = InfinispanCollections.emptyList();
        for (CacheTopology cacheTopology : stableTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (CacheTopology cacheTopology : currentTopologies) {
            this.addMembers(cacheTopology.getMembers(), joinInfos);
        }
        for (Map.Entry entry : joinInfos.entrySet()) {
            if (this.expectedMembers.contains(entry.getKey())) continue;
            this.addMember((Address)entry.getKey(), (CacheJoinInfo)entry.getValue());
        }
    }

    private void addMembers(Collection<Address> membersToAdd, Map<Address, CacheJoinInfo> joinInfos) {
        for (Address member : membersToAdd) {
            CacheJoinInfo joinInfo;
            if (this.expectedMembers.contains(member) || (joinInfo = joinInfos.get(member)) == null) continue;
            this.addMember(member, joinInfo);
        }
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStatusResponse doJoin(Address joiner, CacheJoinInfo joinInfo) throws Exception {
        CacheTopology topologyBeforeRebalance;
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            boolean isFirstMember = this.getCurrentTopology() == null;
            boolean memberJoined = this.addMember(joiner, joinInfo);
            if (!isFirstMember && !memberJoined) {
                if (trace) {
                    log.tracef("Trying to add node %s to cache %s, but it is already a member: members = %s, joiners = %s", joiner, this.cacheName, this.expectedMembers, this.joiners);
                }
                return new CacheStatusResponse(null, this.currentTopology, this.stableTopology, this.availabilityMode);
            }
            if (isFirstMember) {
                CacheTopology initialTopology = this.createInitialCacheTopology();
                this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, initialTopology, this.isTotalOrder(), this.isDistributed());
            }
            topologyBeforeRebalance = this.getCurrentTopology();
            this.availabilityStrategy.onJoin(this, joiner);
        }
        return new CacheStatusResponse(null, topologyBeforeRebalance, this.stableTopology, this.availabilityMode);
    }

    protected CacheTopology createInitialCacheTopology() {
        List<Address> initialMembers = this.getExpectedMembers();
        Object initialCH = this.joinInfo.getConsistentHashFactory().create(this.joinInfo.getHashFunction(), this.joinInfo.getNumOwners(), this.joinInfo.getNumSegments(), initialMembers, this.getCapacityFactors());
        CacheTopology initialTopology = new CacheTopology(0, 0, (ConsistentHash)initialCH, null);
        this.setCurrentTopology(initialTopology);
        this.setStableTopology(initialTopology);
        return initialTopology;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLeave(Address leaver) throws Exception {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (this.currentTopology == null) {
                return;
            }
            boolean actualLeaver = this.removeMember(leaver);
            if (!actualLeaver) {
                return;
            }
            this.availabilityStrategy.onGracefulLeave(this, leaver);
            boolean rebalanceCompleted = this.updateRebalanceMembers();
            if (rebalanceCompleted) {
                this.endRebalance();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startQueuedRebalance() {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            ConsistentHash updatedMembersCH;
            if (this.queuedRebalanceMembers == null) {
                if (this.stableTopology == null || this.stableTopology.getTopologyId() < this.currentTopology.getTopologyId()) {
                    this.stableTopology = this.currentTopology;
                    log.tracef("Updating stable topology for cache %s: %s", (Object)this.cacheName, (Object)this.stableTopology);
                    this.clusterTopologyManager.broadcastStableTopologyUpdate(this.cacheName, this.stableTopology, this.isTotalOrder(), this.isDistributed());
                }
                return;
            }
            CacheTopology cacheTopology = this.getCurrentTopology();
            if (!this.isRebalanceEnabled() && !this.cacheName.equals("__cluster_registry_cache__")) {
                log.tracef("Postponing rebalance for cache %s, rebalancing is disabled", (Object)this.cacheName);
                return;
            }
            if (this.isRebalanceInProgress()) {
                log.tracef("Postponing rebalance for cache %s, there's already a rebalance in progress: %s", (Object)this.cacheName, (Object)cacheTopology);
                return;
            }
            if (this.queuedRebalanceMembers.isEmpty()) {
                log.tracef("Ignoring request to rebalance cache %s, it doesn't have any member", (Object)this.cacheName);
                return;
            }
            ArrayList<Address> newMembers = new ArrayList<Address>(this.queuedRebalanceMembers);
            this.queuedRebalanceMembers = null;
            log.tracef("Rebalancing consistent hash for cache %s, members are %s", (Object)this.cacheName, (Object)newMembers);
            int newTopologyId = cacheTopology.getTopologyId() + 1;
            int newRebalanceId = cacheTopology.getRebalanceId() + 1;
            ConsistentHash currentCH = cacheTopology.getCurrentCH();
            if (currentCH == null) {
                log.tracef("Ignoring request to rebalance cache %s, it doesn't have a consistent hash", (Object)this.cacheName);
                return;
            }
            if (!this.expectedMembers.containsAll(newMembers)) {
                newMembers.removeAll(this.expectedMembers);
                log.tracef("Ignoring request to rebalance cache %s, we have new leavers: %s", (Object)this.cacheName, (Object)newMembers);
                return;
            }
            ConsistentHashFactory chFactory = this.getJoinInfo().getConsistentHashFactory();
            ConsistentHash balancedCH = chFactory.rebalance(updatedMembersCH = chFactory.updateMembers(currentCH, newMembers, this.getCapacityFactors()));
            if (balancedCH.equals(currentCH)) {
                log.tracef("The balanced CH is the same as the current CH, not rebalancing", new Object[0]);
                return;
            }
            CacheTopology newTopology = new CacheTopology(newTopologyId, newRebalanceId, currentCH, balancedCH);
            log.tracef("Updating cache %s topology for rebalance: %s", (Object)this.cacheName, (Object)newTopology);
            newTopology.logRoutingTableInformation();
            this.initRebalanceConfirmationCollector(newTopology);
        }
        this.clusterTopologyManager.broadcastRebalanceStart(this.cacheName, this.getCurrentTopology(), this.isTotalOrder(), this.isDistributed());
    }

    public boolean isRebalanceEnabled() {
        return this.clusterTopologyManager.isRebalancingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRebalanceEnabled(boolean enabled) {
        ClusterCacheStatus clusterCacheStatus = this;
        synchronized (clusterCacheStatus) {
            if (enabled) {
                log.debugf("Rebalancing is now enabled for cache %s", (Object)this.cacheName);
                this.queueRebalance(this.expectedMembers);
            } else {
                log.debugf("Rebalancing is now disabled for cache %s", (Object)this.cacheName);
            }
        }
    }

    public void forceRebalance() {
        this.queueRebalance(this.getCurrentTopology().getMembers());
        this.startQueuedRebalance();
    }
}

