/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite.statetransfer;

import org.infinispan.context.InvocationContext;
import org.infinispan.xsite.BackupReceiver;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.statetransfer.XSiteStateConsumer;
import org.infinispan.xsite.statetransfer.XSiteStateProvider;
import org.infinispan.xsite.statetransfer.XSiteStateTransferManager;

public class XSiteStateTransferControlCommand
extends XSiteReplicateCommand {
    public static final int COMMAND_ID = 28;
    private StateTransferControl control;
    private XSiteStateProvider provider;
    private XSiteStateConsumer consumer;
    private XSiteStateTransferManager stateTransferManager;
    private String siteName;
    private boolean statusOk;
    private int topologyId;

    public XSiteStateTransferControlCommand(String cacheName, StateTransferControl control, String siteName) {
        super(cacheName);
        this.control = control;
        this.siteName = siteName;
    }

    public XSiteStateTransferControlCommand(String cacheName) {
        super(cacheName);
    }

    public XSiteStateTransferControlCommand() {
        super(null);
    }

    @Override
    public Object performInLocalSite(BackupReceiver receiver) throws Throwable {
        receiver.handleStateTransferControl(this);
        return null;
    }

    public final void initialize(XSiteStateProvider provider, XSiteStateConsumer consumer, XSiteStateTransferManager stateTransferManager) {
        this.provider = provider;
        this.consumer = consumer;
        this.stateTransferManager = stateTransferManager;
    }

    @Override
    public Object perform(InvocationContext ctx) throws Throwable {
        switch (this.control) {
            case START_SEND: {
                this.provider.startStateTransfer(this.siteName, this.getOrigin(), this.topologyId);
                break;
            }
            case START_RECEIVE: {
                this.consumer.startStateTransfer(this.siteName);
                break;
            }
            case FINISH_RECEIVE: {
                this.consumer.endStateTransfer(this.siteName);
                break;
            }
            case FINISH_SEND: {
                this.stateTransferManager.notifyStatePushFinished(this.siteName, this.getOrigin(), this.statusOk);
                break;
            }
            case CANCEL_SEND: {
                this.provider.cancelStateTransfer(this.siteName);
                break;
            }
            case RESTART_SEND: {
                this.provider.cancelStateTransfer(this.siteName);
                this.provider.startStateTransfer(this.siteName, this.getOrigin(), this.topologyId);
                break;
            }
            case STATUS_REQUEST: {
                return this.stateTransferManager.getStatus();
            }
            case CLEAR_STATUS: {
                this.stateTransferManager.clearStatus();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown control command: " + this.consumer);
            }
        }
        return null;
    }

    @Override
    public byte getCommandId() {
        return 28;
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{this.control, this.siteName, this.statusOk, this.topologyId};
    }

    @Override
    public void setParameters(int commandId, Object[] parameters) {
        if (commandId != 28) {
            throw new IllegalArgumentException("CommandId is not valid! (" + commandId + " != " + 28 + ")");
        }
        this.control = (StateTransferControl)((Object)parameters[0]);
        this.siteName = (String)parameters[1];
        this.statusOk = (Boolean)parameters[2];
        this.topologyId = (Integer)parameters[3];
    }

    @Override
    public boolean isReturnValueExpected() {
        return this.control == StateTransferControl.STATUS_REQUEST;
    }

    public void setStatusOk(boolean statusOk) {
        this.statusOk = statusOk;
    }

    public void setSiteName(String siteName) {
        this.siteName = siteName;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setTopologyId(int topologyId) {
        this.topologyId = topologyId;
    }

    @Override
    public String toString() {
        return "XSiteStateTransferControlCommand{control=" + (Object)((Object)this.control) + ", siteName='" + this.siteName + '\'' + ", statusOk=" + this.statusOk + ", cacheName='" + this.cacheName + '\'' + '}';
    }

    public static enum StateTransferControl {
        START_SEND,
        START_RECEIVE,
        FINISH_SEND,
        FINISH_RECEIVE,
        CANCEL_SEND,
        RESTART_SEND,
        STATUS_REQUEST,
        CLEAR_STATUS;

    }
}

