/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.iteration.impl;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.commons.util.CloseableIterator;
import org.infinispan.commons.util.CollectionFactory;
import org.infinispan.commons.util.concurrent.ParallelIterableMap;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.InternalEntryFactory;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.filter.CollectionKeyFilter;
import org.infinispan.filter.CompositeKeyFilter;
import org.infinispan.filter.Converter;
import org.infinispan.filter.KeyFilter;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.filter.KeyValueFilterAsKeyFilter;
import org.infinispan.filter.KeyValueFilterConverter;
import org.infinispan.iteration.impl.EntryRetriever;
import org.infinispan.marshall.core.MarshalledEntry;
import org.infinispan.marshall.core.MarshalledValue;
import org.infinispan.metadata.InternalMetadata;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.event.CacheEntryActivatedEvent;
import org.infinispan.persistence.PersistenceUtil;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.TimeService;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LocalEntryRetriever<K, V>
implements EntryRetriever<K, V> {
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final int batchSize;
    protected final long timeout;
    protected final TimeUnit unit;
    protected DataContainer<K, V> dataContainer;
    protected PersistenceManager persistenceManager;
    protected ExecutorService executorService;
    protected Cache<K, V> cache;
    protected TimeService timeService;
    protected InternalEntryFactory entryFactory;
    protected Equivalence<K> keyEquivalence;
    protected final Executor withinThreadExecutor = new WithinThreadExecutor();
    boolean passivationEnabled;

    @Inject
    public void inject(DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, @ComponentName(value="org.infinispan.executors.transport") ExecutorService executorService, TimeService timeService, InternalEntryFactory entryFactory, Cache<K, V> cache, Configuration config) {
        this.dataContainer = dataContainer;
        this.persistenceManager = persistenceManager;
        this.executorService = executorService;
        this.timeService = timeService;
        this.entryFactory = entryFactory;
        this.cache = cache;
        this.passivationEnabled = config.persistence().passivation();
        this.keyEquivalence = config.dataContainer().keyEquivalence();
    }

    public LocalEntryRetriever(int batchSize, long timeout, TimeUnit unit) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be greater than 0");
        }
        if (timeout <= 0L) {
            throw new IllegalArgumentException("timeout must be greater than 0");
        }
        if (unit == null) {
            throw new NullPointerException("unit must not be null");
        }
        this.batchSize = batchSize;
        this.timeout = timeout;
        this.unit = unit;
    }

    @Override
    public <C> void startRetrievingValues(UUID identifier, Address origin, Set<Integer> segments, KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter, Set<Flag> flags) {
        throw new UnsupportedOperationException();
    }

    protected <C> void wireFilterAndConverterDependencies(KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, C> converter) {
        ComponentRegistry componentRegistry = this.cache.getAdvancedCache().getComponentRegistry();
        if (filter != null) {
            componentRegistry.wireDependencies(filter);
        }
        if (converter != null && converter != filter) {
            componentRegistry.wireDependencies(converter);
        }
    }

    @Override
    public <C> void receiveResponse(UUID identifier, Address origin, Set<Integer> completedSegments, Set<Integer> inDoubtSegments, Collection<CacheEntry<K, C>> entries) {
        throw new UnsupportedOperationException();
    }

    protected boolean shouldUseLoader(Set<Flag> flags) {
        return flags == null || !flags.contains((Object)Flag.SKIP_CACHE_LOAD);
    }

    protected <C> Converter<? super K, ? super V, ? extends C> checkForKeyValueFilterConverter(KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter) {
        Converter<? super K, ? super V, ? extends C> usedConverter;
        if (filter == converter && filter instanceof KeyValueFilterConverter) {
            usedConverter = null;
            if (this.log.isTraceEnabled()) {
                this.log.tracef("User supplied a KeyValueFilterConverter for both filter and converter, so ignoring converter", new Object[0]);
            }
        } else {
            usedConverter = converter;
        }
        return usedConverter;
    }

    @Override
    public <C> CloseableIterator<CacheEntry<K, C>> retrieveEntries(final KeyValueFilter<? super K, ? super V> filter, Converter<? super K, ? super V, ? extends C> converter, final Set<Flag> flags, EntryRetriever.SegmentListener listener) {
        final Converter<? super K, ? super V, ? extends C> usedConverter = this.checkForKeyValueFilterConverter(filter, converter);
        this.wireFilterAndConverterDependencies(filter, usedConverter);
        Itr iterator = new Itr(this.batchSize);
        final ItrQueuerHandler handler = new ItrQueuerHandler(iterator);
        this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    final Set processedKeys = CollectionFactory.makeSet(LocalEntryRetriever.this.keyEquivalence);
                    ArrayDeque queue = new ArrayDeque<CacheEntry<K, C>>(LocalEntryRetriever.this.batchSize){

                        @Override
                        public boolean add(CacheEntry<K, C> kcEntry) {
                            processedKeys.add(kcEntry.getKey());
                            return super.add(kcEntry);
                        }
                    };
                    MapAction action = new MapAction(LocalEntryRetriever.this.batchSize, usedConverter, queue, handler);
                    PassivationListener listener = null;
                    long currentTime = LocalEntryRetriever.this.timeService.wallClockTime();
                    try {
                        int interruptCheck = 0;
                        for (InternalCacheEntry internalCacheEntry : LocalEntryRetriever.this.dataContainer) {
                            if (internalCacheEntry.isExpired(currentTime)) continue;
                            InternalCacheEntry clone = LocalEntryRetriever.this.entryFactory.create(LocalEntryRetriever.unwrapMarshalledvalue(internalCacheEntry.getKey()), LocalEntryRetriever.unwrapMarshalledvalue(internalCacheEntry.getValue()), internalCacheEntry);
                            Object key = clone.getKey();
                            if (filter != null) {
                                if (usedConverter == null && filter instanceof KeyValueFilterConverter) {
                                    Object converted = ((KeyValueFilterConverter)filter).filterAndConvert(key, clone.getValue(), clone.getMetadata());
                                    if (converted == null) continue;
                                    clone.setValue(converted);
                                } else if (!filter.accept(key, clone.getValue(), clone.getMetadata())) continue;
                            }
                            action.apply(key, clone);
                            if (interruptCheck++ % LocalEntryRetriever.this.batchSize != 0 || !Thread.interrupted()) continue;
                            throw new CacheException("Entry Iterator was interrupted!");
                        }
                        if (LocalEntryRetriever.this.shouldUseLoader(flags) && LocalEntryRetriever.this.persistenceManager.getStoresAsString().size() > 0) {
                            if (LocalEntryRetriever.this.passivationEnabled) {
                                listener = new PassivationListener();
                                LocalEntryRetriever.this.cache.addListener(listener);
                            }
                            KeyFilter loaderFilter = filter == null || usedConverter == null && filter instanceof KeyValueFilterConverter ? new CollectionKeyFilter(processedKeys) : new CompositeKeyFilter(new CollectionKeyFilter(processedKeys), new KeyValueFilterAsKeyFilter(filter));
                            if (usedConverter == null && filter instanceof KeyValueFilterConverter) {
                                action = new MapAction(LocalEntryRetriever.this.batchSize, (KeyValueFilterConverter)filter, queue, handler);
                            }
                            LocalEntryRetriever.this.persistenceManager.processOnAllStores(LocalEntryRetriever.this.withinThreadExecutor, loaderFilter, new KeyValueActionForCacheLoaderTask(action), true, true);
                        }
                    }
                    finally {
                        if (listener != null) {
                            LocalEntryRetriever.this.cache.removeListener(listener);
                            AdvancedCache advancedCache = LocalEntryRetriever.this.cache.getAdvancedCache();
                            for (Object object : listener.activatedKeys) {
                                CacheEntry entry;
                                if (processedKeys.contains(object) || (entry = advancedCache.getCacheEntry(object)) == null) continue;
                                queue.add(entry);
                            }
                        }
                    }
                    if (LocalEntryRetriever.this.log.isTraceEnabled()) {
                        LocalEntryRetriever.this.log.trace("Completed transfer of entries from cache");
                    }
                    handler.handleBatch(true, queue);
                }
                catch (Throwable e) {
                    LocalEntryRetriever.this.log.exceptionProcessingEntryRetrievalValues(e);
                }
            }
        });
        return iterator;
    }

    protected static <T> T unwrapMarshalledvalue(T value) {
        if (value instanceof MarshalledValue) {
            return (T)((MarshalledValue)value).get();
        }
        return value;
    }

    protected class Itr<K, C>
    implements CloseableIterator<CacheEntry<K, C>> {
        private final BlockingQueue<CacheEntry<K, C>> queue;
        private final Lock nextLock = new ReentrantLock();
        private final Condition nextCondition = this.nextLock.newCondition();
        private boolean completed;

        public Itr(int batchSize) {
            this.queue = new ArrayBlockingQueue<CacheEntry<K, C>>(batchSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = !this.queue.isEmpty();
            if (!hasNext) {
                boolean interrupted = false;
                long targetTime = LocalEntryRetriever.this.timeService.expectedEndTime(LocalEntryRetriever.this.timeout, LocalEntryRetriever.this.unit);
                this.nextLock.lock();
                try {
                    while (!(hasNext = !this.queue.isEmpty()) && !this.completed) {
                        try {
                            if (this.nextCondition.await(LocalEntryRetriever.this.timeService.remainingTime(targetTime, TimeUnit.NANOSECONDS), TimeUnit.NANOSECONDS)) continue;
                            if (LocalEntryRetriever.this.log.isTraceEnabled()) {
                                LocalEntryRetriever.this.log.tracef("Did not retrieve entries in allotted timeout: %s units: unit", (Object)LocalEntryRetriever.this.timeout, (Object)LocalEntryRetriever.this.unit);
                            }
                            throw new TimeoutException("Did not retrieve entries in allotted timeout: " + LocalEntryRetriever.this.timeout + " units: " + (Object)((Object)LocalEntryRetriever.this.unit));
                        }
                        catch (InterruptedException e) {
                            interrupted = true;
                        }
                    }
                }
                finally {
                    this.nextLock.unlock();
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
            return hasNext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheEntry<K, C> next() {
            CacheEntry entry = (CacheEntry)this.queue.poll();
            if (entry == null) {
                if (this.completed) {
                    throw new NoSuchElementException();
                }
                this.nextLock.lock();
                try {
                    while ((entry = (CacheEntry)this.queue.poll()) == null && !this.completed) {
                        try {
                            this.nextCondition.await();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (entry == null) {
                        throw new NoSuchElementException();
                    }
                }
                finally {
                    this.nextLock.unlock();
                }
            }
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addEntries(Collection<CacheEntry<K, C>> entries) throws InterruptedException {
            boolean wasCompleted = this.completed;
            Iterator<CacheEntry<K, C>> itr = entries.iterator();
            while (!wasCompleted && itr.hasNext()) {
                CacheEntry<K, C> entry = null;
                while (itr.hasNext() && this.queue.offer(entry = itr.next())) {
                    entry = null;
                }
                this.nextLock.lock();
                try {
                    wasCompleted = this.completed;
                    this.nextCondition.signalAll();
                }
                finally {
                    this.nextLock.unlock();
                }
                if (wasCompleted || entry == null) continue;
                this.queue.put(entry);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            this.nextLock.lock();
            try {
                this.completed = true;
                this.nextCondition.signalAll();
            }
            finally {
                this.nextLock.unlock();
            }
        }
    }

    protected class ItrQueuerHandler<C>
    implements BatchHandler<K, C> {
        final Itr<K, C> iterator;

        public ItrQueuerHandler(Itr<K, C> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void handleBatch(boolean complete, Collection<CacheEntry<K, C>> entries) throws InterruptedException {
            this.iterator.addEntries(entries);
            if (complete) {
                this.iterator.close();
            }
        }
    }

    protected static interface BatchHandler<K, C> {
        public void handleBatch(boolean var1, Collection<CacheEntry<K, C>> var2) throws InterruptedException;
    }

    private class MapAction<C>
    implements ParallelIterableMap.KeyValueAction<K, InternalCacheEntry<K, V>> {
        final Converter<? super K, ? super V, ? extends C> converter;
        final Queue<CacheEntry<K, C>> queue;
        final int batchSize;
        final BatchHandler<K, C> handler;
        final AtomicInteger insertionCount = new AtomicInteger();

        public MapAction(int batchSize, Converter<? super K, ? super V, ? extends C> converter, Queue<CacheEntry<K, C>> queue, BatchHandler<K, C> handler) {
            this.batchSize = batchSize;
            this.converter = converter;
            this.queue = queue;
            this.handler = handler;
        }

        @Override
        public void apply(K k, InternalCacheEntry<K, V> kvInternalCacheEntry) {
            InternalCacheEntry clone = kvInternalCacheEntry.clone();
            if (this.converter != null) {
                C value = this.converter.convert(k, kvInternalCacheEntry.getValue(), kvInternalCacheEntry.getMetadata());
                if (value == null && this.converter instanceof KeyValueFilterConverter) {
                    return;
                }
                clone.setValue(value);
            }
            this.queue.add(clone);
            if (this.insertionCount.incrementAndGet() % this.batchSize == 0) {
                try {
                    this.handler.handleBatch(false, this.queue);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                this.queue.clear();
            }
        }
    }

    protected class KeyValueActionForCacheLoaderTask<K, V>
    implements AdvancedCacheLoader.CacheLoaderTask<K, V> {
        private final ParallelIterableMap.KeyValueAction<? super K, ? super InternalCacheEntry<K, V>> action;

        public KeyValueActionForCacheLoaderTask(ParallelIterableMap.KeyValueAction<? super K, ? super InternalCacheEntry<K, V>> action) {
            this.action = action;
        }

        @Override
        public void processEntry(MarshalledEntry<K, V> marshalledEntry, AdvancedCacheLoader.TaskContext taskContext) throws InterruptedException {
            if (!taskContext.isStopped()) {
                InternalMetadata metadata = marshalledEntry.getMetadata();
                if (metadata == null || !metadata.isExpired(LocalEntryRetriever.this.timeService.wallClockTime())) {
                    InternalCacheEntry<K, V> ice = PersistenceUtil.convert(marshalledEntry, LocalEntryRetriever.this.entryFactory);
                    this.action.apply(marshalledEntry.getKey(), ice);
                }
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
            }
        }
    }

    @Listener
    protected static class PassivationListener<K, V> {
        Queue<K> activatedKeys = new ConcurrentLinkedQueue<K>();

        protected PassivationListener() {
        }

        @CacheEntryActivated
        public void onEntryActivated(CacheEntryActivatedEvent<K, V> activatedEvent) {
            this.activatedKeys.add(activatedEvent.getKey());
        }
    }
}

