/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.transaction.xa.GlobalTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.BackupSender;

public class BaseBackupInterceptor
extends CommandInterceptor {
    protected BackupSender backupSender;
    protected TransactionTable txTable;
    private static final Log log = LogFactory.getLog(BaseBackupInterceptor.class);

    @Inject
    void init(BackupSender sender, TransactionTable txTable) {
        this.backupSender = sender;
        this.txTable = txTable;
    }

    protected boolean isTxFromRemoteSite(GlobalTransaction gtx) {
        LocalTransaction remoteTx = this.txTable.getLocalTransaction(gtx);
        return remoteTx != null && remoteTx.isFromRemoteSite();
    }

    protected boolean shouldInvokeRemoteTxCommand(TxInvocationContext ctx) {
        boolean shouldBackupRemotely = ctx.isOriginLocal() && ctx.hasModifications() && !((AbstractCacheTransaction)ctx.getCacheTransaction()).isFromStateTransfer();
        this.getLog().tracef("Should backup remotely? %s", (Object)shouldBackupRemotely);
        return shouldBackupRemotely;
    }

    protected final boolean skipXSiteBackup(FlagAffectedCommand command) {
        return command.hasFlag(Flag.SKIP_XSITE_BACKUP);
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

