/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.xsite;

import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.interceptors.xsite.BaseBackupInterceptor;

public class NonTransactionalBackupInterceptor
extends BaseBackupInterceptor {
    private CommandsFactory commandsFactory;
    private ClusteringDependentLogic clusteringDependentLogic;

    @Inject
    public void injectDependencies(CommandsFactory commandsFactory, ClusteringDependentLogic clusteringDependentLogic) {
        this.commandsFactory = commandsFactory;
        this.clusteringDependentLogic = clusteringDependentLogic;
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        return this.handleSingleKeyWriteCommand(ctx, command);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleMultipleKeysWriteCommand(ctx, command);
    }

    private Object handleSingleKeyWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        Object result = this.invokeNextInterceptor(ctx, command);
        if (this.skipXSiteBackup(command)) {
            return result;
        }
        if (command.isSuccessful() && this.clusteringDependentLogic.localNodeIsPrimaryOwner(command.getKey())) {
            this.backupSender.processResponses(this.backupSender.backupWrite(this.transform(command)), command);
        }
        return result;
    }

    private Object handleMultipleKeysWriteCommand(InvocationContext ctx, WriteCommand command) throws Throwable {
        if (!ctx.isOriginLocal() || this.skipXSiteBackup(command)) {
            return this.invokeNextInterceptor(ctx, command);
        }
        Object result = this.invokeNextInterceptor(ctx, command);
        this.backupSender.processResponses(this.backupSender.backupWrite(command), command);
        return result;
    }

    private WriteCommand transform(DataWriteCommand command) {
        if (command instanceof PutKeyValueCommand) {
            PutKeyValueCommand putCommand = (PutKeyValueCommand)command;
            return this.commandsFactory.buildPutKeyValueCommand(putCommand.getKey(), putCommand.getValue(), command.getMetadata(), command.getFlags());
        }
        if (command instanceof ReplaceCommand) {
            ReplaceCommand replaceCommand = (ReplaceCommand)command;
            return this.commandsFactory.buildPutKeyValueCommand(replaceCommand.getKey(), replaceCommand.getNewValue(), command.getMetadata(), command.getFlags());
        }
        if (command instanceof RemoveCommand) {
            return this.commandsFactory.buildRemoveCommand(command.getKey(), null, command.getFlags());
        }
        throw new IllegalArgumentException("Command " + command + " is not valid!");
    }
}

