/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence.jdbc.configuration;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.parsing.XmlConfigHelper;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfiguration;
import org.infinispan.persistence.jdbc.configuration.JdbcBinaryStoreConfiguration;
import org.infinispan.persistence.jdbc.configuration.ManagedConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.PooledConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;

public class JdbcBinaryStoreConfigurationBuilder
extends AbstractJdbcStoreConfigurationBuilder<JdbcBinaryStoreConfiguration, JdbcBinaryStoreConfigurationBuilder> {
    public static final int DEFAULT_CONCURRENCY_LEVEL = 2048;
    public static final int DEFAULT_LOCK_ACQUISITION_TIMEOUT = 60000;
    protected final BinaryTableManipulationConfigurationBuilder table = new BinaryTableManipulationConfigurationBuilder(this);
    private int concurrencyLevel = 2048;
    private long lockAcquisitionTimeout = 60000L;

    public JdbcBinaryStoreConfigurationBuilder(PersistenceConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public JdbcBinaryStoreConfigurationBuilder self() {
        return this;
    }

    public BinaryTableManipulationConfigurationBuilder table() {
        return this.table;
    }

    @Override
    public JdbcBinaryStoreConfigurationBuilder withProperties(Properties props) {
        Map<Object, Object> unrecognized = XmlConfigHelper.setValues(this, props, false, false);
        unrecognized = XmlConfigHelper.setValues(this.table, unrecognized, false, false);
        XmlConfigHelper.showUnrecognizedAttributes(unrecognized);
        this.properties = props;
        return this;
    }

    public JdbcBinaryStoreConfigurationBuilder lockAcquisitionTimeout(long lockAcquisitionTimeout) {
        this.lockAcquisitionTimeout = lockAcquisitionTimeout;
        return this.self();
    }

    public JdbcBinaryStoreConfigurationBuilder concurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
        return this.self();
    }

    @Override
    public JdbcBinaryStoreConfiguration create() {
        ConnectionFactoryConfiguration cf = this.connectionFactory != null ? (ConnectionFactoryConfiguration)this.connectionFactory.create() : null;
        return new JdbcBinaryStoreConfiguration(this.purgeOnStartup, this.fetchPersistentState, this.ignoreModifications, this.async.create(), this.singletonStore.create(), this.preload, this.shared, TypedProperties.toTypedProperties(this.properties), cf, this.manageConnectionFactory, this.table.create(), this.concurrencyLevel, this.lockAcquisitionTimeout, this.databaseType);
    }

    public JdbcBinaryStoreConfigurationBuilder read(JdbcBinaryStoreConfiguration template) {
        super.read(template);
        this.table.read(template.table());
        this.lockAcquisitionTimeout = template.lockAcquisitionTimeout();
        this.concurrencyLevel = template.lockConcurrencyLevel();
        return this;
    }

    public class BinaryTableManipulationConfigurationBuilder
    extends TableManipulationConfigurationBuilder<JdbcBinaryStoreConfigurationBuilder, BinaryTableManipulationConfigurationBuilder> {
        BinaryTableManipulationConfigurationBuilder(AbstractJdbcStoreConfigurationBuilder<?, JdbcBinaryStoreConfigurationBuilder> builder) {
            super(builder);
        }

        @Override
        public PooledConnectionFactoryConfigurationBuilder<JdbcBinaryStoreConfigurationBuilder> connectionPool() {
            return JdbcBinaryStoreConfigurationBuilder.this.connectionPool();
        }

        @Override
        public ManagedConnectionFactoryConfigurationBuilder<JdbcBinaryStoreConfigurationBuilder> dataSource() {
            return JdbcBinaryStoreConfigurationBuilder.this.dataSource();
        }

        @Override
        public BinaryTableManipulationConfigurationBuilder self() {
            return this;
        }
    }
}

