/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.demos;

import java.awt.Button;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Label;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Hashtable;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.View;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.RpcDispatcher;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;

public class QuoteClient
extends Frame
implements WindowListener,
ActionListener,
MembershipListener {
    static final String channel_name = "Quotes";
    RpcDispatcher disp;
    Channel channel;
    final Button get = new Button("Get");
    final Button set = new Button("Set");
    final Button quit = new Button("Quit");
    final Button get_all = new Button("All");
    final Label stock = new Label("Stock");
    final Label value = new Label("Value");
    final Label err_msg = new Label("Error");
    final TextField stock_field = new TextField();
    final TextField value_field = new TextField();
    final List listbox = new List();
    final Font default_font = new Font("Helvetica", 0, 12);
    static final String props = null;

    public QuoteClient() {
        try {
            this.channel = new JChannel(props);
            this.channel.setDiscardOwnMessages(true);
            this.disp = new RpcDispatcher(this.channel, null, (MembershipListener)this, this);
            this.channel.connect(channel_name);
        }
        catch (Exception e) {
            System.err.println("QuoteClient(): " + e);
        }
        this.addWindowListener(this);
    }

    private void showMsg(String msg) {
        this.err_msg.setText(msg);
        this.err_msg.setVisible(true);
    }

    private void clearMsg() {
        this.err_msg.setVisible(false);
    }

    public void start() {
        this.setLayout(null);
        this.setSize(400, 300);
        this.setFont(this.default_font);
        this.stock.setBounds(new Rectangle(10, 30, 60, 30));
        this.value.setBounds(new Rectangle(10, 60, 60, 30));
        this.stock_field.setBounds(new Rectangle(100, 30, 100, 30));
        this.value_field.setBounds(new Rectangle(100, 60, 100, 30));
        this.listbox.setBounds(210, 30, 150, 160);
        this.err_msg.setBounds(new Rectangle(10, 200, 350, 30));
        this.err_msg.setFont(new Font("Helvetica", 2, 12));
        this.err_msg.setForeground(Color.red);
        this.err_msg.setVisible(false);
        this.get.setBounds(new Rectangle(10, 250, 80, 30));
        this.set.setBounds(new Rectangle(100, 250, 80, 30));
        this.quit.setBounds(new Rectangle(190, 250, 80, 30));
        this.get_all.setBounds(new Rectangle(280, 250, 80, 30));
        this.get.addActionListener(this);
        this.set.addActionListener(this);
        this.quit.addActionListener(this);
        this.get_all.addActionListener(this);
        this.add(this.stock);
        this.add(this.value);
        this.add(this.stock_field);
        this.add(this.value_field);
        this.add(this.err_msg);
        this.add(this.get);
        this.add(this.set);
        this.add(this.quit);
        this.add(this.get_all);
        this.add(this.listbox);
        this.setVisible(true);
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.exit(0);
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        try {
            if (command.equals("Get")) {
                String stock_name = this.stock_field.getText();
                if (stock_name == null || stock_name.length() == 0) {
                    this.showMsg("Stock name is empty !");
                    return;
                }
                this.showMsg("Looking up value for " + stock_name + ':');
                RspList quotes = this.disp.callRemoteMethods(null, "getQuote", new Object[]{stock_name}, new Class[]{String.class}, new RequestOptions(ResponseMode.GET_ALL, 10000L));
                Float val = null;
                for (Rsp rsp : quotes.values()) {
                    Object quote = rsp.getValue();
                    if (quote == null || quote instanceof Throwable) continue;
                    val = (Float)quote;
                    break;
                }
                if (val != null) {
                    this.value_field.setText(val.toString());
                    this.clearMsg();
                } else {
                    this.value_field.setText("");
                    this.showMsg("Value for " + stock_name + " not found");
                }
            } else if (command.equals("Set")) {
                String stock_name = this.stock_field.getText();
                String stock_val = this.value_field.getText();
                if (stock_name == null || stock_val == null || stock_name.length() == 0 || stock_val.length() == 0) {
                    this.showMsg("Stock name and value have to be present to enter a new value");
                    return;
                }
                Float val = new Float(stock_val);
                this.disp.callRemoteMethods(null, "setQuote", new Object[]{stock_name, val}, new Class[]{String.class, Float.class}, new RequestOptions(ResponseMode.GET_FIRST, 0L));
                this.showMsg("Stock " + stock_name + " set to " + val);
            } else if (command.equals("All")) {
                this.listbox.removeAll();
                this.showMsg("Getting all stocks:");
                RspList rsp_list = this.disp.callRemoteMethods(null, "getAllStocks", null, null, new RequestOptions(ResponseMode.GET_ALL, 5000L));
                System.out.println("rsp_list is " + rsp_list);
                Hashtable all_stocks = null;
                for (Rsp rsp : rsp_list.values()) {
                    Object obj = rsp.getValue();
                    if (obj == null || obj instanceof Throwable) continue;
                    all_stocks = (Hashtable)obj;
                    break;
                }
                if (all_stocks == null) {
                    this.showMsg("No stocks found");
                    return;
                }
                this.clearMsg();
                this.listbox.removeAll();
                Enumeration en = all_stocks.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    Float val = (Float)all_stocks.get(key);
                    if (val == null) continue;
                    this.listbox.add(key + ": " + val.toString());
                }
            } else if (command.equals("Quit")) {
                this.setVisible(false);
                this.channel.close();
                System.exit(0);
            } else {
                System.out.println("Unknown action");
            }
        }
        catch (Exception ex) {
            this.value_field.setText("");
            ex.printStackTrace();
            this.showMsg(ex.toString());
        }
    }

    public void setQuote(String stock_name, Float value) {
    }

    public void printAllStocks() {
    }

    @Override
    public void viewAccepted(View new_view) {
        this.setTitle("Members in Quotes: " + (new_view.size() - 1));
    }

    @Override
    public void suspect(Address suspected_mbr) {
    }

    @Override
    public void block() {
    }

    @Override
    public void unblock() {
    }

    public static void main(String[] args) {
        QuoteClient client = new QuoteClient();
        client.start();
    }
}

