/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.partitionhandling.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.partitionhandling.AvailabilityMode;
import org.infinispan.partitionhandling.impl.AvailabilityStrategy;
import org.infinispan.partitionhandling.impl.AvailabilityStrategyContext;
import org.infinispan.remoting.transport.Address;
import org.infinispan.topology.CacheStatusResponse;
import org.infinispan.topology.CacheTopology;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PreferAvailabilityStrategy
implements AvailabilityStrategy {
    private static final Log log = LogFactory.getLog(PreferAvailabilityStrategy.class);

    @Override
    public void onJoin(AvailabilityStrategyContext context, Address joiner) {
        context.queueRebalance(context.getExpectedMembers());
    }

    @Override
    public void onGracefulLeave(AvailabilityStrategyContext context, Address leaver) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        newMembers.remove(leaver);
        if (newMembers.isEmpty()) {
            log.debugf("The last node of cache %s left", (Object)context.getCacheName());
            context.updateCurrentTopology(newMembers);
            return;
        }
        if (context.getStableTopology() != null && this.isDataLost(context.getStableTopology().getCurrentCH(), newMembers)) {
            log.lostDataBecauseOfGracefulLeaver(context.getCacheName(), leaver);
        }
        context.updateCurrentTopology(newMembers);
        context.queueRebalance(newMembers);
    }

    @Override
    public void onClusterViewChange(AvailabilityStrategyContext context, List<Address> clusterMembers) {
        CacheTopology currentTopology = context.getCurrentTopology();
        ArrayList<Address> newMembers = new ArrayList<Address>(currentTopology.getMembers());
        if (!newMembers.retainAll(clusterMembers)) {
            log.tracef("Cache %s did not lose any members, skipping rebalance", (Object)context.getCacheName());
            return;
        }
        this.checkForLostData(context, newMembers);
        context.updateCurrentTopology(newMembers);
        context.queueRebalance(newMembers);
    }

    protected void checkForLostData(AvailabilityStrategyContext context, List<Address> newMembers) {
        CacheTopology stableTopology = context.getStableTopology();
        List<Address> stableMembers = stableTopology.getMembers();
        ArrayList<Address> lostMembers = new ArrayList<Address>(stableMembers);
        lostMembers.removeAll(newMembers);
        if (this.isDataLost(stableTopology.getCurrentCH(), newMembers)) {
            log.lostDataBecauseOfAbruptLeavers(context.getCacheName(), lostMembers);
        } else if ((double)lostMembers.size() >= Math.ceil((double)stableMembers.size() / 2.0)) {
            log.minorityPartition(context.getCacheName(), newMembers, lostMembers, stableMembers);
        }
    }

    @Override
    public void onPartitionMerge(AvailabilityStrategyContext context, Collection<CacheStatusResponse> statusResponses) {
        CacheTopology topology;
        CacheTopology maxStableTopology = null;
        for (CacheStatusResponse response : statusResponses) {
            CacheTopology stableTopology = response.getStableTopology();
            if (stableTopology == null || maxStableTopology != null && maxStableTopology.getMembers().size() >= stableTopology.getMembers().size()) continue;
            maxStableTopology = stableTopology;
        }
        CacheTopology maxTopology = null;
        for (CacheStatusResponse response : statusResponses) {
            CacheTopology stableTopology = response.getStableTopology();
            if (!Objects.equals(stableTopology, maxStableTopology) || (topology = response.getCacheTopology()) == null || maxTopology != null && maxTopology.getMembers().size() >= topology.getMembers().size()) continue;
            maxTopology = topology;
        }
        if (maxTopology == null) {
            log.debugf("No current topology, recovered only joiners for cache %s", (Object)context.getCacheName());
        }
        int maxTopologyId = 0;
        for (CacheStatusResponse response : statusResponses) {
            topology = response.getCacheTopology();
            if (topology == null || maxTopologyId >= topology.getTopologyId()) continue;
            maxTopologyId = topology.getTopologyId();
        }
        CacheTopology mergedTopology = null;
        if (maxTopology != null) {
            mergedTopology = new CacheTopology(maxTopologyId + 1, maxTopology.getRebalanceId(), maxTopology.getCurrentCH(), null, maxTopology.getActualMembers());
        }
        context.updateTopologiesAfterMerge(mergedTopology, maxStableTopology, null);
        List<Address> newMembers = context.getExpectedMembers();
        ArrayList<Address> survivingMembers = new ArrayList<Address>(newMembers);
        if (mergedTopology != null && survivingMembers.retainAll(mergedTopology.getMembers())) {
            this.checkForLostData(context, survivingMembers);
        }
        context.updateCurrentTopology(survivingMembers);
        context.queueRebalance(newMembers);
    }

    @Override
    public void onRebalanceEnd(AvailabilityStrategyContext context) {
    }

    @Override
    public void onManualAvailabilityChange(AvailabilityStrategyContext context, AvailabilityMode newAvailabilityMode) {
    }

    private boolean isDataLost(ConsistentHash currentCH, List<Address> newMembers) {
        for (int i = 0; i < currentCH.getNumSegments(); ++i) {
            if (InfinispanCollections.containsAny(newMembers, currentCH.locateOwnersForSegment(i))) continue;
            return true;
        }
        return false;
    }
}

