/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class StateTransferLockImpl
implements StateTransferLock {
    private static final Log log = LogFactory.getLog(StateTransferLockImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final ReadWriteLock ownershipLock = new ReentrantReadWriteLock();
    private volatile int topologyId = -1;
    private final Lock topologyLock = new ReentrantLock();
    private final Condition topologyCondition = this.topologyLock.newCondition();
    private volatile int transactionDataTopologyId = -1;
    private final Lock transactionDataLock = new ReentrantLock();
    private final Condition transactionDataCondition = this.transactionDataLock.newCondition();

    @Override
    public void acquireExclusiveTopologyLock() {
        this.ownershipLock.writeLock().lock();
    }

    @Override
    public void releaseExclusiveTopologyLock() {
        this.ownershipLock.writeLock().unlock();
    }

    @Override
    public void acquireSharedTopologyLock() {
        this.ownershipLock.readLock().lock();
    }

    @Override
    public void releaseSharedTopologyLock() {
        this.ownershipLock.readLock().unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTransactionDataReceived(int topologyId) {
        if (topologyId < this.transactionDataTopologyId) {
            throw new IllegalStateException("Cannot set a topology id (" + topologyId + ") that is lower than the current one (" + this.transactionDataTopologyId + ")");
        }
        if (trace) {
            log.tracef("Signalling transaction data received for topology %d", (Object)topologyId);
        }
        this.transactionDataTopologyId = topologyId;
        this.transactionDataLock.lock();
        try {
            this.transactionDataCondition.signalAll();
        }
        finally {
            this.transactionDataLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTransactionData(int expectedTopologyId, long timeout, TimeUnit unit) throws InterruptedException {
        if (trace) {
            log.tracef("Waiting for transaction data for topology %d, current topology is %d", (Object)expectedTopologyId, (Object)this.transactionDataTopologyId);
        }
        if (this.transactionDataTopologyId >= expectedTopologyId) {
            return;
        }
        this.transactionDataLock.lock();
        try {
            long timeoutNanos = unit.toNanos(timeout);
            while (this.transactionDataTopologyId < expectedTopologyId && timeoutNanos > 0L) {
                timeoutNanos = this.transactionDataCondition.awaitNanos(timeoutNanos);
            }
            if (timeoutNanos <= 0L) {
                throw new TimeoutException("Timed out waiting for topology " + expectedTopologyId);
            }
        }
        finally {
            this.transactionDataLock.unlock();
        }
        if (trace) {
            log.tracef("Received transaction data for topology %d, expected topology was %d", (Object)this.transactionDataTopologyId, (Object)expectedTopologyId);
        }
    }

    @Override
    public boolean transactionDataReceived(int expectedTopologyId) {
        if (trace) {
            log.tracef("Checking if transaction data was received for topology %s, current topology is %s", (Object)expectedTopologyId, (Object)this.transactionDataTopologyId);
        }
        return this.transactionDataTopologyId >= expectedTopologyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyTopologyInstalled(int topologyId) {
        if (topologyId < this.topologyId) {
            throw new IllegalStateException("Cannot set a topology id (" + topologyId + ") that is lower than the current one (" + this.topologyId + ")");
        }
        if (trace) {
            log.tracef("Signalling topology %d is installed", (Object)topologyId);
        }
        this.topologyId = topologyId;
        this.topologyLock.lock();
        try {
            this.topologyCondition.signalAll();
        }
        finally {
            this.topologyLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForTopology(int expectedTopologyId, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.topologyId >= expectedTopologyId) {
            return;
        }
        if (trace) {
            log.tracef("Waiting for topology %d to be installed, current topology is %d", (Object)expectedTopologyId, (Object)this.topologyId);
        }
        this.topologyLock.lock();
        try {
            long timeoutNanos = unit.toNanos(timeout);
            while (this.topologyId < expectedTopologyId && timeoutNanos > 0L) {
                timeoutNanos = this.topologyCondition.awaitNanos(timeoutNanos);
            }
            if (timeoutNanos <= 0L) {
                throw new TimeoutException("Timed out waiting for topology " + expectedTopologyId);
            }
        }
        finally {
            this.topologyLock.unlock();
        }
        if (trace) {
            log.tracef("Topology %d is now installed, expected topology was %d", (Object)this.topologyId, (Object)expectedTopologyId);
        }
    }

    @Override
    public boolean topologyReceived(int expectedTopologyId) {
        return this.topologyId >= expectedTopologyId;
    }
}

