/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.RecoveryConfiguration;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.TransactionProtocol;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.transaction.lookup.TransactionSynchronizationRegistryLookup;

public class TransactionConfiguration {
    private final boolean autoCommit;
    private long cacheStopTimeout;
    private final boolean eagerLockingSingleNode;
    private LockingMode lockingMode;
    private final boolean syncCommitPhase;
    private final boolean syncRollbackPhase;
    private TransactionManagerLookup transactionManagerLookup;
    private final TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup;
    private final TransactionMode transactionMode;
    private boolean useEagerLocking;
    private final boolean useSynchronization;
    private final RecoveryConfiguration recovery;
    private final boolean use1PcForAutoCommitTransactions;
    private final long reaperWakeUpInterval;
    private final long completedTxTimeout;
    private final TransactionProtocol transactionProtocol;

    TransactionConfiguration(boolean autoCommit, long cacheStopTimeout, boolean eagerLockingSingleNode, LockingMode lockingMode, boolean syncCommitPhase, boolean syncRollbackPhase, TransactionManagerLookup transactionManagerLookup, TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup, TransactionMode transactionMode, boolean useEagerLocking, boolean useSynchronization, boolean use1PcForAutoCommitTransactions, long reaperWakeUpInterval, long completedTxTimeout, RecoveryConfiguration recovery, TransactionProtocol transactionProtocol) {
        this.autoCommit = autoCommit;
        this.cacheStopTimeout = cacheStopTimeout;
        this.eagerLockingSingleNode = eagerLockingSingleNode;
        this.lockingMode = lockingMode;
        this.syncCommitPhase = syncCommitPhase;
        this.syncRollbackPhase = syncRollbackPhase;
        this.transactionManagerLookup = transactionManagerLookup;
        this.transactionSynchronizationRegistryLookup = transactionSynchronizationRegistryLookup;
        this.transactionMode = transactionMode;
        this.useEagerLocking = useEagerLocking;
        this.useSynchronization = useSynchronization;
        this.recovery = recovery;
        this.use1PcForAutoCommitTransactions = use1PcForAutoCommitTransactions;
        this.reaperWakeUpInterval = reaperWakeUpInterval;
        this.completedTxTimeout = completedTxTimeout;
        this.transactionProtocol = transactionProtocol;
    }

    public boolean autoCommit() {
        return this.autoCommit;
    }

    public TransactionConfiguration cacheStopTimeout(long l) {
        this.cacheStopTimeout = l;
        return this;
    }

    public long cacheStopTimeout() {
        return this.cacheStopTimeout;
    }

    @Deprecated
    public boolean eagerLockingSingleNode() {
        return this.eagerLockingSingleNode;
    }

    public LockingMode lockingMode() {
        return this.lockingMode;
    }

    public TransactionConfiguration lockingMode(LockingMode lockingMode) {
        this.lockingMode = lockingMode;
        return this;
    }

    public boolean syncCommitPhase() {
        return this.syncCommitPhase;
    }

    @Deprecated
    public TransactionConfiguration syncCommitPhase(boolean b) {
        return this;
    }

    public boolean syncRollbackPhase() {
        return this.syncRollbackPhase;
    }

    @Deprecated
    public TransactionConfiguration syncRollbackPhase(boolean b) {
        return this;
    }

    public TransactionManagerLookup transactionManagerLookup() {
        return this.transactionManagerLookup;
    }

    public TransactionConfiguration transactionManagerLookup(TransactionManagerLookup transactionManagerLookup) {
        this.transactionManagerLookup = transactionManagerLookup;
        return this;
    }

    public TransactionSynchronizationRegistryLookup transactionSynchronizationRegistryLookup() {
        return this.transactionSynchronizationRegistryLookup;
    }

    public TransactionMode transactionMode() {
        return this.transactionMode;
    }

    @Deprecated
    public boolean useEagerLocking() {
        return this.useEagerLocking;
    }

    @Deprecated
    public TransactionConfiguration useEagerLocking(boolean b) {
        this.useEagerLocking = b;
        return this;
    }

    public boolean useSynchronization() {
        return this.useSynchronization;
    }

    public RecoveryConfiguration recovery() {
        return this.recovery;
    }

    public long reaperWakeUpInterval() {
        return this.reaperWakeUpInterval;
    }

    public long completedTxTimeout() {
        return this.completedTxTimeout;
    }

    public boolean use1PcForAutoCommitTransactions() {
        return this.use1PcForAutoCommitTransactions;
    }

    public String toString() {
        return "TransactionConfiguration{autoCommit=" + this.autoCommit + ", cacheStopTimeout=" + this.cacheStopTimeout + ", eagerLockingSingleNode=" + this.eagerLockingSingleNode + ", lockingMode=" + (Object)((Object)this.lockingMode) + ", syncCommitPhase=" + this.syncCommitPhase + ", syncRollbackPhase=" + this.syncRollbackPhase + ", transactionManagerLookup=" + this.transactionManagerLookup + ", transactionSynchronizationRegistryLookup=" + this.transactionSynchronizationRegistryLookup + ", transactionMode=" + (Object)((Object)this.transactionMode) + ", useEagerLocking=" + this.useEagerLocking + ", useSynchronization=" + this.useSynchronization + ", recovery=" + this.recovery + ", reaperWakeUpInterval=" + this.reaperWakeUpInterval + ", completedTxTimeout=" + this.completedTxTimeout + ", use1PcForAutoCommitTransactions=" + this.use1PcForAutoCommitTransactions + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransactionConfiguration that = (TransactionConfiguration)o;
        if (this.autoCommit != that.autoCommit) {
            return false;
        }
        if (this.cacheStopTimeout != that.cacheStopTimeout) {
            return false;
        }
        if (this.eagerLockingSingleNode != that.eagerLockingSingleNode) {
            return false;
        }
        if (this.syncCommitPhase != that.syncCommitPhase) {
            return false;
        }
        if (this.syncRollbackPhase != that.syncRollbackPhase) {
            return false;
        }
        if (this.use1PcForAutoCommitTransactions != that.use1PcForAutoCommitTransactions) {
            return false;
        }
        if (this.useEagerLocking != that.useEagerLocking) {
            return false;
        }
        if (this.useSynchronization != that.useSynchronization) {
            return false;
        }
        if (this.lockingMode != that.lockingMode) {
            return false;
        }
        if (this.recovery != null ? !this.recovery.equals(that.recovery) : that.recovery != null) {
            return false;
        }
        if (this.transactionManagerLookup != null ? !this.transactionManagerLookup.equals(that.transactionManagerLookup) : that.transactionManagerLookup != null) {
            return false;
        }
        if (this.transactionMode != that.transactionMode) {
            return false;
        }
        if (this.transactionSynchronizationRegistryLookup != null ? !this.transactionSynchronizationRegistryLookup.equals(that.transactionSynchronizationRegistryLookup) : that.transactionSynchronizationRegistryLookup != null) {
            return false;
        }
        return this.transactionProtocol == that.transactionProtocol;
    }

    public int hashCode() {
        int result = this.autoCommit ? 1 : 0;
        result = 31 * result + (int)(this.cacheStopTimeout ^ this.cacheStopTimeout >>> 32);
        result = 31 * result + (this.eagerLockingSingleNode ? 1 : 0);
        result = 31 * result + (this.lockingMode != null ? this.lockingMode.hashCode() : 0);
        result = 31 * result + (this.syncCommitPhase ? 1 : 0);
        result = 31 * result + (this.syncRollbackPhase ? 1 : 0);
        result = 31 * result + (this.transactionManagerLookup != null ? this.transactionManagerLookup.hashCode() : 0);
        result = 31 * result + (this.transactionSynchronizationRegistryLookup != null ? this.transactionSynchronizationRegistryLookup.hashCode() : 0);
        result = 31 * result + (this.transactionMode != null ? this.transactionMode.hashCode() : 0);
        result = 31 * result + (this.useEagerLocking ? 1 : 0);
        result = 31 * result + (this.useSynchronization ? 1 : 0);
        result = 31 * result + (this.recovery != null ? this.recovery.hashCode() : 0);
        result = 31 * result + (this.use1PcForAutoCommitTransactions ? 1 : 0);
        result = 31 * result + (this.transactionProtocol != null ? this.transactionProtocol.hashCode() : 0);
        return result;
    }

    public TransactionProtocol transactionProtocol() {
        return this.transactionProtocol;
    }
}

